/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp;

import java.util.Arrays;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.StreamMultiplexer$$Lambda$1;

public class StreamMultiplexer {
    private Stream[] activeStreams = new Stream[4];
    private int activeStreamCount = 0;

    public void onPriorityChanged(Stream stream) {
        this.sort();
    }

    public int peekPriority() {
        return this.activeStreamCount == 0 ? Integer.MIN_VALUE : this.activeStreams[0].getPriority();
    }

    public void resume(Stream stream) {
        int position = this.getInsertPosition(stream);
        if (position == -1) {
            return;
        }
        if (this.activeStreamCount == this.activeStreams.length) {
            this.activeStreams = Arrays.copyOf(this.activeStreams, this.activeStreams.length * 2);
        }
        for (int i = this.activeStreamCount; i > position; --i) {
            this.activeStreams[i] = this.activeStreams[i - 1];
        }
        this.activeStreams[position] = stream;
        ++this.activeStreamCount;
    }

    public String getActive() {
        StringBuilder active = new StringBuilder();
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (i > 0) {
                active.append(", ");
            }
            active.append(this.activeStreams[i].getId());
        }
        return active.toString();
    }

    private int getInsertPosition(Stream stream) {
        if (this.activeStreamCount == 0) {
            return 0;
        }
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (this.activeStreams[i] == stream) {
                return -1;
            }
            if (stream.getPriority() <= this.activeStreams[i].getPriority()) continue;
            return i;
        }
        return this.activeStreamCount;
    }

    public FrameData next(int availableSpaceInPacket) {
        FrameData result = null;
        int removed = 0;
        for (int i = 0; i < this.activeStreamCount; ++i) {
            if (removed != 0) {
                this.activeStreams[i - removed] = this.activeStreams[i];
            }
            if (result != null || (result = this.activeStreams[i].next(availableSpaceInPacket)) != null) continue;
            ++removed;
        }
        this.activeStreamCount -= removed;
        return result;
    }

    private void sort() {
        Arrays.sort(this.activeStreams, 0, this.activeStreamCount, StreamMultiplexer$$Lambda$1.lambdaFactory$());
    }

    static /* synthetic */ int lambda$sort$0(Stream a, Stream b) {
        return a.getPriority() - b.getPriority();
    }

    public static interface Stream {
        public int getId();

        public int getPriority();

        public FrameData next(int var1);
    }
}

