/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.packetstreams.qpsp.frames;

import org.openzen.packetstreams.io.BytesDataInput;
import org.openzen.packetstreams.io.BytesDataOutput;
import org.openzen.packetstreams.qpsp.FrameData;
import org.openzen.packetstreams.qpsp.QPSPConnection;
import org.openzen.packetstreams.qpsp.QPSPStream;
import org.openzen.packetstreams.qpsp.frames.Frame;
import org.openzen.packetstreams.qpsp.frames.OutgoingFrame;

public class StopWaitingFrame
implements Frame,
OutgoingFrame {
    private final QPSPConnection connection;
    private final long seq;

    public static StopWaitingFrame deserialize(BytesDataInput input, QPSPConnection connection) {
        return new StopWaitingFrame(connection, connection.decodeCompactedSEQ(input));
    }

    public StopWaitingFrame(QPSPConnection connection, long seq) {
        this.connection = connection;
        this.seq = seq;
    }

    @Override
    public boolean tryExecute() {
        this.connection.deliverStopWaiting(this.seq);
        return true;
    }

    @Override
    public QPSPStream getStream() {
        return null;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public FrameData encode() {
        BytesDataOutput output = new BytesDataOutput();
        output.writeUByte(11);
        this.connection.encodeCompactedSEQ(output, this.seq);
        return new FrameData(Integer.MAX_VALUE, this.seq, output.toByteArray(), true, false);
    }

    @Override
    public FrameData encodeAsFragmented() {
        throw new UnsupportedOperationException("Not encodable as fragmented");
    }

    @Override
    public long getBlockingSeq() {
        return -1L;
    }
}

