/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.expression.CoalesceExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionCoalesce
extends ParsedExpression {
    private final ParsedExpression left;
    private final ParsedExpression right;

    public ParsedExpressionCoalesce(CodePosition position, ParsedExpression left, ParsedExpression right) {
        super(position);
        this.left = left;
        this.right = right;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        Expression cLeft = this.left.compile(scope).eval();
        StoredType cLeftType = cLeft.type;
        if (!cLeftType.isOptional()) {
            return new InvalidExpression(this.position, cLeft.type, CompileExceptionCode.COALESCE_TARGET_NOT_OPTIONAL, "Type of the first expression is not optional");
        }
        StoredType resultType = cLeftType.withoutOptional();
        Expression cRight = this.right.compile(scope.withHint(resultType)).eval();
        TypeMembers resultTypeMembers = scope.getTypeMembers(resultType);
        cLeft = cLeft.castImplicit(this.position, scope, (resultType = resultTypeMembers.union(cRight.type)).isOptional() ? resultType : scope.getTypeRegistry().getOptional(resultType.type).stored(resultType.getSpecifiedStorage()));
        cRight = cRight.castImplicit(this.position, scope, resultType);
        return new CoalesceExpression(this.position, cLeft, cRight);
    }

    @Override
    public boolean hasStrongType() {
        return this.left.hasStrongType();
    }
}

