/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.ConcatMap;
import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.statement.Statement;

public class ScriptBlock
extends Taggable {
    public final Module module;
    public final ZSPackage pkg;
    public final List<Statement> statements;

    public ScriptBlock(Module module, ZSPackage pkg, List<Statement> statements) {
        this.module = module;
        this.pkg = pkg;
        this.statements = statements;
    }

    public ScriptBlock withStatements(List<Statement> newStatements) {
        ScriptBlock result = new ScriptBlock(this.module, this.pkg, newStatements);
        result.addAllTagsFrom(this);
        return result;
    }

    public ScriptBlock normalize(TypeScope scope) {
        ArrayList<Statement> normalized = new ArrayList<Statement>();
        for (Statement statement : this.statements) {
            normalized.add(statement.normalize(scope, ConcatMap.empty(LoopStatement.class, LoopStatement.class)));
        }
        ScriptBlock result = new ScriptBlock(this.module, this.pkg, normalized);
        result.addAllTagsFrom(this);
        return result;
    }
}

