/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.openzen.zenscript.javabytecode.JavaBytecodeModule;
import org.openzen.zenscript.javabytecode.compiler.JavaClassWriter;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaBytecodeRunUnit {
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private final List<JavaMethod> scripts = new ArrayList<JavaMethod>();
    private boolean scriptsWritten = false;

    public void add(JavaBytecodeModule module) {
        this.scriptsWritten = false;
        for (Map.Entry<String, byte[]> classEntry : module.getClasses().entrySet()) {
            this.classes.put(classEntry.getKey().replace('/', '.'), classEntry.getValue());
        }
        this.scripts.addAll(module.getScripts());
    }

    public void run() {
        this.writeScripts();
        ScriptClassLoader classLoader = new ScriptClassLoader();
        try {
            classLoader.loadClass("Scripts").getMethod("run", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(JavaBytecodeRunUnit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void dump(File directory) {
        this.writeScripts();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (Map.Entry<String, byte[]> classEntry : this.classes.entrySet()) {
            File output = new File(directory, classEntry.getKey() + ".class");
            try {
                FileOutputStream outputStream = new FileOutputStream(output);
                Throwable throwable = null;
                try {
                    outputStream.write(classEntry.getValue());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void writeScripts() {
        if (this.scriptsWritten) {
            return;
        }
        JavaClassWriter scriptsClassWriter = new JavaClassWriter(2);
        scriptsClassWriter.visit(52, 1, "Scripts", null, "java/lang/Object", null);
        JavaMethod runMethod = JavaMethod.getStatic(new JavaClass("script", "Scripts", JavaClass.Kind.CLASS), "run", "()V", 9);
        JavaWriter runWriter = new JavaWriter((ClassVisitor)scriptsClassWriter, runMethod, null, null, null, new String[0]);
        runWriter.start();
        for (JavaMethod method : this.scripts) {
            runWriter.invokeStatic(method);
        }
        runWriter.ret();
        runWriter.end();
        this.classes.put("Scripts", scriptsClassWriter.toByteArray());
        this.scriptsWritten = true;
    }

    public class ScriptClassLoader
    extends ClassLoader {
        private final Map<String, Class> customClasses = new HashMap<String, Class>();

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.customClasses.containsKey(name)) {
                return this.customClasses.get(name);
            }
            if (JavaBytecodeRunUnit.this.classes.containsKey(name)) {
                byte[] bytes = (byte[])JavaBytecodeRunUnit.this.classes.get(name);
                this.customClasses.put(name, this.defineClass(name, bytes, 0, bytes.length, null));
                return this.customClasses.get(name);
            }
            return super.loadClass(name);
        }
    }
}

