/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.definition.VariantDefinition;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.ref.DefinitionMemberRef;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaImplementation;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaNativeClass;
import org.openzen.zenscript.javashared.JavaParameterInfo;
import org.openzen.zenscript.javashared.JavaVariantOption;

public class JavaCompiledModule {
    public final Module module;
    private final Map<HighLevelDefinition, JavaClass> classes = new HashMap<HighLevelDefinition, JavaClass>();
    private final Map<HighLevelDefinition, JavaClass> expansionClasses = new HashMap<HighLevelDefinition, JavaClass>();
    private final Map<HighLevelDefinition, JavaNativeClass> nativeClasses = new HashMap<HighLevelDefinition, JavaNativeClass>();
    private final Map<ImplementationMember, JavaImplementation> implementations = new HashMap<ImplementationMember, JavaImplementation>();
    private final Map<IDefinitionMember, JavaField> fields = new HashMap<IDefinitionMember, JavaField>();
    private final Map<IDefinitionMember, JavaMethod> methods = new HashMap<IDefinitionMember, JavaMethod>();
    private final Map<FunctionParameter, JavaParameterInfo> parameters = new HashMap<FunctionParameter, JavaParameterInfo>();
    private final Map<VariantDefinition.Option, JavaVariantOption> variantOptions = new HashMap<VariantDefinition.Option, JavaVariantOption>();

    public JavaCompiledModule(Module module) {
        this.module = module;
    }

    public void setClassInfo(HighLevelDefinition definition, JavaClass cls) {
        this.classes.put(definition, cls);
    }

    public void setExpansionClassInfo(HighLevelDefinition definition, JavaClass cls) {
        this.expansionClasses.put(definition, cls);
    }

    public JavaClass getClassInfo(HighLevelDefinition definition) {
        JavaClass cls = this.classes.get(definition);
        if (cls == null) {
            throw new IllegalStateException("Missing class info for class " + definition.name);
        }
        return cls;
    }

    public JavaClass getExpansionClassInfo(HighLevelDefinition definition) {
        JavaClass cls = this.expansionClasses.get(definition);
        if (cls == null) {
            return this.getClassInfo(definition);
        }
        return cls;
    }

    public JavaClass optClassInfo(HighLevelDefinition definition) {
        return this.classes.get(definition);
    }

    public boolean hasClassInfo(HighLevelDefinition definition) {
        return this.classes.containsKey(definition);
    }

    public void setNativeClassInfo(HighLevelDefinition definition, JavaNativeClass cls) {
        this.nativeClasses.put(definition, cls);
    }

    public JavaNativeClass getNativeClassInfo(HighLevelDefinition definition) {
        return this.nativeClasses.get(definition);
    }

    public void setVariantOption(VariantDefinition.Option option, JavaVariantOption value) {
        this.variantOptions.put(option, value);
    }

    public JavaVariantOption getVariantOption(VariantDefinition.Option option) {
        JavaVariantOption result = this.variantOptions.get(option);
        if (result == null) {
            throw new IllegalStateException("Variant option unknown: " + option.name);
        }
        return result;
    }

    public void setImplementationInfo(ImplementationMember member, JavaImplementation implementation) {
        this.implementations.put(member, implementation);
    }

    public JavaImplementation getImplementationInfo(ImplementationMember member) {
        JavaImplementation implementation = this.implementations.get(member);
        if (implementation == null) {
            throw new IllegalStateException("Implementation unknown: " + member.type);
        }
        return implementation;
    }

    public void setFieldInfo(IDefinitionMember member, JavaField field) {
        this.fields.put(member, field);
    }

    public JavaField optFieldInfo(IDefinitionMember member) {
        return this.fields.get(member);
    }

    public JavaField getFieldInfo(IDefinitionMember member) {
        JavaField field = this.fields.get(member);
        if (field == null) {
            throw new IllegalStateException("Missing field info for field " + member.getDefinition().name + "." + member.describe());
        }
        return field;
    }

    public void setMethodInfo(IDefinitionMember member, JavaMethod method) {
        this.methods.put(member, method);
    }

    public JavaMethod getMethodInfo(DefinitionMemberRef member) {
        return this.getMethodInfo(member.getTarget());
    }

    public JavaMethod getMethodInfo(IDefinitionMember member) {
        JavaMethod method = this.methods.get(member);
        if (method == null) {
            throw new IllegalStateException("Missing method info for method " + member.getDefinition().name + "." + member.describe());
        }
        return method;
    }

    public void setParameterInfo(FunctionParameter parameter, JavaParameterInfo info) {
        this.parameters.put(parameter, info);
    }

    public JavaParameterInfo getParameterInfo(FunctionParameter parameter) {
        JavaParameterInfo info = this.parameters.get(parameter);
        if (info == null) {
            throw new IllegalStateException("Missing parameter info for parameter " + parameter.name);
        }
        return info;
    }
}

