/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.type.IParsedType;

public class ParsedCallArguments {
    public static final ParsedCallArguments NONE = new ParsedCallArguments(null, Collections.emptyList());
    private final List<IParsedType> typeArguments;
    public final List<ParsedExpression> arguments;

    public static ParsedCallArguments parse(ZSTokenParser tokens) throws ParseException {
        List<IParsedType> typeArguments = IParsedType.parseTypeArgumentsForCall(tokens);
        tokens.required(ZSTokenType.T_BROPEN, "( expected");
        ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>();
        try {
            if (tokens.optional(ZSTokenType.T_BRCLOSE) == null) {
                do {
                    arguments.add(ParsedExpression.parse(tokens));
                } while (tokens.optional(ZSTokenType.T_COMMA) != null);
                tokens.required(ZSTokenType.T_BRCLOSE, ") expected");
            }
        }
        catch (ParseException ex) {
            tokens.logError(ex);
            tokens.recoverUntilToken(ZSTokenType.T_BRCLOSE);
        }
        return new ParsedCallArguments(typeArguments, arguments);
    }

    public static ParsedCallArguments parseForAnnotation(ZSTokenParser tokens) throws ParseException {
        List<IParsedType> typeArguments = IParsedType.parseTypeArgumentsForCall(tokens);
        ArrayList<ParsedExpression> arguments = new ArrayList<ParsedExpression>();
        if (tokens.isNext(ZSTokenType.T_BROPEN)) {
            tokens.required(ZSTokenType.T_BROPEN, "( expected");
            try {
                if (tokens.optional(ZSTokenType.T_BRCLOSE) == null) {
                    do {
                        arguments.add(ParsedExpression.parse(tokens));
                    } while (tokens.optional(ZSTokenType.T_COMMA) != null);
                    tokens.required(ZSTokenType.T_BRCLOSE, ") expected");
                }
            }
            catch (ParseException ex) {
                tokens.logError(ex);
                tokens.recoverUntilToken(ZSTokenType.T_BRCLOSE);
            }
        }
        return new ParsedCallArguments(typeArguments, arguments);
    }

    public ParsedCallArguments(List<IParsedType> typeArguments, List<ParsedExpression> arguments) {
        this.typeArguments = typeArguments;
        this.arguments = arguments;
    }

    public CallArguments compileCall(CodePosition position, ExpressionScope scope, StoredType[] genericParameters, TypeMemberGroup member) throws CompileException {
        List<FunctionHeader> possibleHeaders = member.getMethodMembers().stream().map(method -> ((FunctionalMemberRef)method.member).getHeader()).collect(Collectors.toList());
        return this.compileCall(position, scope, genericParameters, possibleHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public CallArguments compileCall(CodePosition position, ExpressionScope scope, StoredType[] typeArguments, List<FunctionHeader> candidateFunctions) throws CompileException {
        void var9_18;
        void var9_15;
        if (this.typeArguments != null) {
            typeArguments = new StoredType[this.typeArguments.size()];
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                typeArguments[i] = this.typeArguments.get(i).compile(scope);
            }
        }
        List<Object> candidates = new ArrayList<FunctionHeader>();
        for (FunctionHeader header : candidateFunctions) {
            if (!this.isCompatibleWith(scope, header, typeArguments)) continue;
            candidates.add(header);
        }
        if (candidates.isEmpty()) {
            StringBuilder explanation = new StringBuilder();
            CallArguments arguments = this.compileCallNaive(position, scope);
            for (FunctionHeader functionHeader : candidateFunctions) {
                explanation.append(functionHeader.explainWhyIncompatible(scope, arguments)).append("\n");
            }
            throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "No compatible methods found: \n" + explanation.toString());
        }
        ExpressionScope innerScope = scope;
        if (candidates.size() == 1) {
            innerScope = scope.forCall((FunctionHeader)candidates.get(0));
        } else if ((candidates = candidates.stream().filter(candidate -> candidate.getNumberOfTypeParameters() == 0).collect(Collectors.toList())).isEmpty()) {
            throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "Could not determine call type parameters");
        }
        List[] predictedTypes = new List[this.arguments.size()];
        for (int i = 0; i < predictedTypes.length; ++i) {
            predictedTypes[i] = new ArrayList();
        }
        for (FunctionHeader functionHeader : candidates) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (predictedTypes[i].contains(functionHeader.parameters[i].type)) continue;
                predictedTypes[i].add(functionHeader.parameters[i].type);
            }
        }
        Expression[] cArguments = new Expression[this.arguments.size()];
        boolean bl = false;
        while (var9_15 < cArguments.length) {
            IPartialExpression cArgument = this.arguments.get((int)var9_15).compile(innerScope.withHints(predictedTypes[var9_15]));
            cArguments[var9_15] = cArgument.eval();
            ++var9_15;
        }
        StoredType[] storedTypeArray = typeArguments;
        if (storedTypeArray == null || storedTypeArray.length == 0) {
            for (FunctionHeader functionHeader : candidates) {
                if (functionHeader.typeParameters == null) continue;
                StoredType[] storedTypeArray2 = new StoredType[functionHeader.typeParameters.length];
                for (int i = 0; i < storedTypeArray2.length; ++i) {
                    storedTypeArray2[i] = innerScope.genericInferenceMap.get(functionHeader.typeParameters[i]) == null ? new InvalidTypeID(position, CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE, "Could not infer type parameter " + functionHeader.typeParameters[i].name).stored() : innerScope.genericInferenceMap.get(functionHeader.typeParameters[i]);
                }
            }
        }
        return new CallArguments((StoredType[])var9_18, cArguments);
    }

    public CallArguments compileCall(CodePosition position, ExpressionScope scope, StoredType[] typeArguments, FunctionHeader function) throws CompileException {
        ExpressionScope innerScope = scope.forCall(function);
        List[] predictedTypes = new List[this.arguments.size()];
        for (int i = 0; i < predictedTypes.length; ++i) {
            predictedTypes[i] = new ArrayList();
            predictedTypes[i].add(function.parameters[i].type);
        }
        Expression[] cArguments = new Expression[this.arguments.size()];
        for (int i = 0; i < cArguments.length; ++i) {
            IPartialExpression cArgument = this.arguments.get(i).compile(innerScope.withHints(predictedTypes[i]));
            cArguments[i] = cArgument.eval();
        }
        StoredType[] typeArguments2 = typeArguments;
        if (typeArguments2 == null && function.typeParameters != null) {
            typeArguments2 = new StoredType[function.typeParameters.length];
            for (int i = 0; i < typeArguments2.length; ++i) {
                if (innerScope.genericInferenceMap.get(function.typeParameters[i]) == null) {
                    throw new CompileException(position, CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE, "Could not infer type parameter " + function.typeParameters[i].name);
                }
                typeArguments2[i] = innerScope.genericInferenceMap.get(function.typeParameters[i]);
            }
        }
        return new CallArguments(typeArguments2, cArguments);
    }

    private CallArguments compileCallNaive(CodePosition position, ExpressionScope scope) throws CompileException {
        Expression[] cArguments = new Expression[this.arguments.size()];
        for (int i = 0; i < cArguments.length; ++i) {
            IPartialExpression cArgument = this.arguments.get(i).compile(scope);
            cArguments[i] = cArgument.eval();
        }
        return new CallArguments(StoredType.NONE, cArguments);
    }

    private boolean isCompatibleWith(BaseScope scope, FunctionHeader header, StoredType[] typeArguments) {
        if (this.arguments.size() != header.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (typeArguments == null && header.typeParameters != null && header.parameters[i].type.hasInferenceBlockingTypeParameters(header.typeParameters)) {
                return false;
            }
            if (this.arguments.get(i).isCompatibleWith(scope, header.parameters[i].type.getNormalized())) continue;
            return false;
        }
        return true;
    }
}

