/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.Objects;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Modifiers;
import org.openzen.zenscript.codemodel.Module;

public final class AccessScope {
    public final Module module;
    public final HighLevelDefinition definition;

    public AccessScope(Module module, HighLevelDefinition definition) {
        this.module = module;
        this.definition = definition;
    }

    public boolean hasAccessTo(AccessScope other, int access) {
        if (Modifiers.isPublic(access)) {
            return true;
        }
        if (this.definition == other.definition || this.definition.isOuterOf(other.definition) || other.definition.isOuterOf(this.definition)) {
            return true;
        }
        if (Modifiers.isPrivate(access)) {
            return false;
        }
        if (Modifiers.isInternal(access)) {
            return this.module == other.module;
        }
        if (Modifiers.isProtected(access)) {
            return this.definition.isSubclassOf(other.definition);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.module);
        hash = 79 * hash + Objects.hashCode(this.definition);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessScope other = (AccessScope)obj;
        return this.module == other.module && this.definition == other.definition;
    }
}

