/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.definition;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.definition.DefinitionVisitor;
import org.openzen.zenscript.codemodel.definition.DefinitionVisitorWithContext;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.member.CallerMember;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPriority;
import org.openzen.zenscript.codemodel.type.storage.StaticStorageTag;

public class FunctionDefinition
extends HighLevelDefinition {
    public FunctionHeader header;
    public CallerMember caller;
    public final TypeMemberGroup callerGroup;

    public FunctionDefinition(CodePosition position, Module module, ZSPackage pkg, String name, int modifiers, HighLevelDefinition outerDefinition) {
        super(position, module, pkg, name, modifiers, outerDefinition);
        this.callerGroup = new TypeMemberGroup(true, name);
    }

    public FunctionDefinition(CodePosition position, Module module, ZSPackage pkg, String name, int modifiers, FunctionHeader header, GlobalTypeRegistry registry) {
        this(position, module, pkg, name, modifiers, null);
        this.setHeader(registry, header);
    }

    public void setHeader(GlobalTypeRegistry registry, FunctionHeader header) {
        this.header = header;
        this.caller = new CallerMember(this.position, this, 129, header, null);
        this.addMember(this.caller);
        this.callerGroup.addMethod(new FunctionalMemberRef(this.caller, registry.getFunction(header).stored(StaticStorageTag.INSTANCE), GenericMapper.EMPTY), TypeMemberPriority.SPECIFIED);
    }

    public void setCode(Statement statement) {
        this.caller.setBody(statement);
    }

    @Override
    public <T> T accept(DefinitionVisitor<T> visitor) {
        return visitor.visitFunction(this);
    }

    @Override
    public <C, R> R accept(C context, DefinitionVisitorWithContext<C, R> visitor) {
        return visitor.visitFunction(context, this);
    }
}

