/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.NewExpression;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.codemodel.type.storage.UniqueStorageTag;
import stdlib.Strings;

public class ExpressionBuilder {
    public final CodePosition position;
    public final ExpressionScope scope;

    public ExpressionBuilder(CodePosition position, ExpressionScope scope) {
        this.position = position;
        this.scope = scope;
    }

    public Expression constructNew(CodePosition position, String typename, Expression ... arguments) throws CompileException {
        String[] nameParts = Strings.split(typename, '.');
        ArrayList<GenericName> name = new ArrayList<GenericName>();
        for (String namePart : nameParts) {
            name.add(new GenericName(namePart));
        }
        TypeID type = this.scope.getType(position, name);
        if (type == null) {
            throw new CompileException(position, CompileExceptionCode.NO_SUCH_TYPE, "No such type: " + typename);
        }
        return this.constructNew(position, type.stored(UniqueStorageTag.INSTANCE), arguments);
    }

    public Expression constructNew(CodePosition position, StoredType type, Expression ... arguments) throws CompileException {
        TypeMemberGroup constructors = this.scope.getTypeMembers(type).getOrCreateGroup(OperatorType.CONSTRUCTOR);
        List<StoredType>[] predictedTypes = constructors.predictCallTypes(position, this.scope, this.scope.hints, arguments.length);
        CallArguments compiledArguments = new CallArguments(arguments);
        FunctionalMemberRef member = constructors.selectMethod(position, this.scope, compiledArguments, true, true);
        if (member == null) {
            throw new CompileException(position, CompileExceptionCode.CALL_NO_VALID_METHOD, "No matching constructor found");
        }
        if (!member.isConstructor()) {
            throw new CompileException(position, CompileExceptionCode.INTERNAL_ERROR, "COMPILER BUG: constructor is not a constructor");
        }
        return new NewExpression(position, type, member, compiledArguments, compiledArguments.getNumberOfTypeArguments() == 0 ? member.getHeader() : member.getHeader().fillGenericArguments(CodePosition.BUILTIN, this.scope, compiledArguments.typeArguments));
    }

    public Expression not(Expression value) throws CompileException {
        TypeMembers members = this.scope.getTypeMembers(value.type);
        return members.getOrCreateGroup(OperatorType.NOT).call(this.position, this.scope, value, CallArguments.EMPTY, false);
    }
}

