/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.scope;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.GetLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.GetMatchingVariantField;
import org.openzen.zenscript.codemodel.expression.switchvalue.VariantOptionSwitchValue;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.statement.VarStatement;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPreparer;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class ExpressionScope
extends BaseScope {
    private final BaseScope outer;
    private final BaseScope.DollarEvaluator dollar;
    public final List<StoredType> hints;
    public final Map<TypeParameter, StoredType> genericInferenceMap;
    public final Map<String, Function<CodePosition, Expression>> innerVariables = new HashMap<String, Function<CodePosition, Expression>>();

    public ExpressionScope(BaseScope outer) {
        this.outer = outer;
        this.hints = Collections.emptyList();
        this.dollar = null;
        this.genericInferenceMap = Collections.emptyMap();
    }

    public ExpressionScope(BaseScope outer, List<StoredType> hints) {
        this.outer = outer;
        this.hints = hints;
        this.dollar = null;
        this.genericInferenceMap = Collections.emptyMap();
    }

    public ExpressionScope(BaseScope scope, StoredType hint) {
        this.outer = scope;
        this.hints = hint.type == BasicTypeID.UNDETERMINED ? Collections.emptyList() : Collections.singletonList(hint);
        this.dollar = null;
        this.genericInferenceMap = Collections.emptyMap();
    }

    private ExpressionScope(BaseScope scope, List<StoredType> hints, BaseScope.DollarEvaluator dollar, Map<TypeParameter, StoredType> genericInferenceMap, Map<String, Function<CodePosition, Expression>> innerVariables) {
        this.outer = scope;
        this.hints = hints;
        this.dollar = dollar;
        this.genericInferenceMap = genericInferenceMap;
        this.innerVariables.putAll(innerVariables);
    }

    public void addInnerVariable(VarStatement variable) {
        this.innerVariables.put(variable.name, position -> new GetLocalVariableExpression((CodePosition)position, variable));
    }

    public void addMatchingVariantOption(String name, int index, VariantOptionSwitchValue value) {
        this.innerVariables.put(name, position -> new GetMatchingVariantField((CodePosition)position, value, index));
    }

    public List<StoredType> getResultTypeHints() {
        return this.hints;
    }

    public ExpressionScope withoutHints() {
        return new ExpressionScope(this.outer, Collections.emptyList(), this.dollar, this.genericInferenceMap, this.innerVariables);
    }

    public ExpressionScope withHint(StoredType hint) {
        return new ExpressionScope(this.outer, Collections.singletonList(hint), this.dollar, this.genericInferenceMap, this.innerVariables);
    }

    public ExpressionScope withHints(List<StoredType> hints) {
        return new ExpressionScope(this.outer, hints, this.dollar, this.genericInferenceMap, this.innerVariables);
    }

    public ExpressionScope createInner(List<StoredType> hints, BaseScope.DollarEvaluator dollar) {
        return new ExpressionScope(this.outer, hints, dollar, this.genericInferenceMap, this.innerVariables);
    }

    public ExpressionScope forCall(FunctionHeader header) {
        if (header.typeParameters == null) {
            return this;
        }
        HashMap<TypeParameter, StoredType> genericInferenceMap = new HashMap<TypeParameter, StoredType>();
        for (TypeParameter parameter : header.typeParameters) {
            genericInferenceMap.put(parameter, null);
        }
        return new ExpressionScope(this.outer, this.hints, this.dollar, genericInferenceMap, this.innerVariables);
    }

    @Override
    public ZSPackage getRootPackage() {
        return this.outer.getRootPackage();
    }

    @Override
    public LocalMemberCache getMemberCache() {
        return this.outer.getMemberCache();
    }

    @Override
    public IPartialExpression get(CodePosition position, GenericName name) throws CompileException {
        if (name.hasNoArguments() && this.innerVariables.containsKey(name.name)) {
            return this.innerVariables.get(name.name).apply(position);
        }
        return this.outer.get(position, name);
    }

    @Override
    public TypeID getType(CodePosition position, List<GenericName> name) {
        return this.outer.getType(position, name);
    }

    @Override
    public StorageTag getStorageTag(CodePosition position, String name, String[] parameters) {
        return this.outer.getStorageTag(position, name, parameters);
    }

    @Override
    public LoopStatement getLoop(String name) {
        return this.outer.getLoop(name);
    }

    @Override
    public FunctionHeader getFunctionHeader() {
        return this.outer.getFunctionHeader();
    }

    @Override
    public StoredType getThisType() {
        return this.outer.getThisType();
    }

    @Override
    public BaseScope.DollarEvaluator getDollar() {
        return this.dollar == null ? this.outer.getDollar() : this.dollar;
    }

    @Override
    public IPartialExpression getOuterInstance(CodePosition position) throws CompileException {
        return this.outer.getOuterInstance(position);
    }

    @Override
    public AnnotationDefinition getAnnotation(String name) {
        return this.outer.getAnnotation(name);
    }

    @Override
    public TypeMemberPreparer getPreparer() {
        return this.outer.getPreparer();
    }

    @Override
    public GenericMapper getLocalTypeParameters() {
        return this.outer.getLocalTypeParameters();
    }
}

