/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeMatcher;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.ValueStorageTag;

public class StoredType {
    public static final StoredType[] NONE = new StoredType[0];
    public final TypeID type;
    private final StorageTag storage;

    public static Map<TypeParameter, StoredType> getMapping(TypeParameter[] parameters, StoredType[] arguments) {
        HashMap<TypeParameter, StoredType> typeArguments = new HashMap<TypeParameter, StoredType>();
        for (int i = 0; i < parameters.length; ++i) {
            typeArguments.put(parameters[i], arguments[i]);
        }
        return typeArguments;
    }

    public static Map<TypeParameter, StoredType> getSelfMapping(GlobalTypeRegistry registry, TypeParameter[] parameters) {
        HashMap<TypeParameter, StoredType> typeArguments = new HashMap<TypeParameter, StoredType>();
        for (TypeParameter parameter : parameters) {
            typeArguments.put(parameter, registry.getGeneric(parameter).stored(parameter.storage));
        }
        return typeArguments;
    }

    public StoredType(TypeID type, StorageTag storage) {
        if (storage == ValueStorageTag.INSTANCE) {
            throw new IllegalArgumentException("storage of a nonvalue type cannot be value");
        }
        this.type = type;
        this.storage = storage;
    }

    public StorageTag getSpecifiedStorage() {
        return this.storage;
    }

    public StorageTag getActualStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        return this.type.isValueType() ? ValueStorageTag.INSTANCE : AutoStorageTag.INSTANCE;
    }

    public StoredType getNormalized() {
        return this.type.getNormalized() == this.type ? this : new StoredType(this.type.getNormalized(), this.storage);
    }

    public StoredType getSuperType(GlobalTypeRegistry registry) {
        TypeID superType = this.type.getSuperType(registry);
        return superType == null ? null : superType.stored(this.storage);
    }

    public StoredType instance(GenericMapper mapper) {
        return this.type.instance(mapper, this.storage);
    }

    public boolean isDestructible() {
        return this.type.isDestructible() && this.getActualStorage().isDestructible();
    }

    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return this.type.isDestructible(scanning) && this.getActualStorage().isDestructible();
    }

    public boolean hasDefaultValue() {
        return this.type.hasDefaultValue();
    }

    public boolean isOptional() {
        return this.type.isOptional();
    }

    public boolean isConst() {
        return this.getActualStorage().isConst();
    }

    public boolean isImmutable() {
        return this.getActualStorage().isImmutable();
    }

    public boolean isBasic(BasicTypeID type) {
        return this.type == type;
    }

    public boolean isGeneric() {
        return this.type.isGeneric();
    }

    public StoredType withoutOptional() {
        return new StoredType(this.type.withoutOptional(), this.storage);
    }

    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.type.hasInferenceBlockingTypeParameters(parameters);
    }

    public Map<TypeParameter, StoredType> inferTypeParameters(LocalMemberCache cache, StoredType targetType) {
        return this.type.inferTypeParameters(cache, targetType);
    }

    public boolean isVariant() {
        return this.type.isVariant();
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isDefinition(HighLevelDefinition definition) {
        return this.type.isDefinition(definition);
    }

    public DefinitionTypeID asDefinition() {
        return (DefinitionTypeID)this.type;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.type);
        hash = 41 * hash + Objects.hashCode(this.storage);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StoredType other = (StoredType)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.storage, other.storage);
    }

    public String toString() {
        return this.storage == null ? this.type.toString() : this.type.toString(this.storage);
    }

    public static class MatchingTypeVisitor
    implements TypeVisitor<Boolean> {
        private final TypeID type;
        private final Map<TypeParameter, StoredType> mapping;
        private final LocalMemberCache cache;

        public MatchingTypeVisitor(LocalMemberCache cache, TypeID type, Map<TypeParameter, StoredType> mapping) {
            this.type = type;
            this.mapping = mapping;
            this.cache = cache;
        }

        @Override
        public Boolean visitBasic(BasicTypeID basic) {
            return basic == this.type;
        }

        @Override
        public Boolean visitString(StringTypeID string) {
            return string == this.type;
        }

        @Override
        public Boolean visitArray(ArrayTypeID array) {
            if (this.type instanceof ArrayTypeID) {
                ArrayTypeID arrayType = (ArrayTypeID)this.type;
                if (arrayType.dimension != array.dimension) {
                    return false;
                }
                return this.match(arrayType.elementType, array.elementType);
            }
            return false;
        }

        @Override
        public Boolean visitAssoc(AssocTypeID assoc) {
            if (this.type instanceof AssocTypeID) {
                AssocTypeID assocType = (AssocTypeID)this.type;
                return this.match(assocType.keyType, assoc.keyType) && this.match(assocType.valueType, assoc.valueType);
            }
            return false;
        }

        @Override
        public Boolean visitIterator(IteratorTypeID iterator) {
            if (this.type instanceof IteratorTypeID) {
                IteratorTypeID iteratorType = (IteratorTypeID)this.type;
                if (iteratorType.iteratorTypes.length != iterator.iteratorTypes.length) {
                    return false;
                }
                boolean result = true;
                for (int i = 0; i < iteratorType.iteratorTypes.length; ++i) {
                    result = result && this.match(iterator.iteratorTypes[i], iteratorType.iteratorTypes[i]);
                }
                return result;
            }
            return false;
        }

        @Override
        public Boolean visitFunction(FunctionTypeID function) {
            if (this.type instanceof FunctionTypeID) {
                FunctionTypeID functionType = (FunctionTypeID)this.type;
                if (functionType.header.parameters.length != function.header.parameters.length) {
                    return false;
                }
                if (!this.match(functionType.header.getReturnType(), function.header.getReturnType())) {
                    return false;
                }
                for (int i = 0; i < function.header.parameters.length; ++i) {
                    if (this.match(functionType.header.parameters[i].type, function.header.parameters[i].type)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitDefinition(DefinitionTypeID definition) {
            if (this.type instanceof DefinitionTypeID) {
                DefinitionTypeID definitionType = (DefinitionTypeID)this.type;
                if (definitionType.definition != definition.definition) {
                    return false;
                }
                if (definition.typeArguments != null) {
                    for (int i = 0; i < definitionType.typeArguments.length; ++i) {
                        if (this.match(definitionType.typeArguments[i], definition.typeArguments[i])) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitGeneric(GenericTypeID generic) {
            if (this.mapping.containsKey(generic.parameter)) {
                return this.mapping.get(generic.parameter) == this.type;
            }
            if (this.type == generic || generic.matches(this.cache, this.type.stored())) {
                this.mapping.put(generic.parameter, this.type.stored());
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitRange(RangeTypeID range) {
            if (this.type instanceof RangeTypeID) {
                RangeTypeID rangeType = (RangeTypeID)this.type;
                return this.match(rangeType.baseType, range.baseType);
            }
            return false;
        }

        @Override
        public Boolean visitOptional(OptionalTypeID type) {
            if (this.type instanceof OptionalTypeID) {
                OptionalTypeID constType = (OptionalTypeID)this.type;
                return this.match(constType.baseType, type.baseType.stored());
            }
            return false;
        }

        private boolean match(StoredType type, StoredType pattern) {
            if (pattern.storage != null && type.storage != pattern.storage) {
                return false;
            }
            return TypeMatcher.match(this.cache, type, pattern) != null;
        }

        private boolean match(TypeID type, StoredType pattern) {
            return TypeMatcher.match(this.cache, type.stored(), pattern) != null;
        }

        @Override
        public Boolean visitGenericMap(GenericMapTypeID map) {
            return map == this.type;
        }
    }
}

