/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringJoiner;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.codemodel.expression.AndAndExpression;
import org.openzen.zenscript.codemodel.expression.ArrayExpression;
import org.openzen.zenscript.codemodel.expression.CallExpression;
import org.openzen.zenscript.codemodel.expression.CallStaticExpression;
import org.openzen.zenscript.codemodel.expression.CapturedClosureExpression;
import org.openzen.zenscript.codemodel.expression.CapturedDirectExpression;
import org.openzen.zenscript.codemodel.expression.CapturedExpression;
import org.openzen.zenscript.codemodel.expression.CapturedLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.CapturedParameterExpression;
import org.openzen.zenscript.codemodel.expression.CapturedThisExpression;
import org.openzen.zenscript.codemodel.expression.CastExpression;
import org.openzen.zenscript.codemodel.expression.CheckNullExpression;
import org.openzen.zenscript.codemodel.expression.CoalesceExpression;
import org.openzen.zenscript.codemodel.expression.CompareExpression;
import org.openzen.zenscript.codemodel.expression.ConditionalExpression;
import org.openzen.zenscript.codemodel.expression.ConstExpression;
import org.openzen.zenscript.codemodel.expression.ConstantBoolExpression;
import org.openzen.zenscript.codemodel.expression.ConstantByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantCharExpression;
import org.openzen.zenscript.codemodel.expression.ConstantDoubleExpression;
import org.openzen.zenscript.codemodel.expression.ConstantFloatExpression;
import org.openzen.zenscript.codemodel.expression.ConstantIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantLongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantSByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantULongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUSizeExpression;
import org.openzen.zenscript.codemodel.expression.ConstructorSuperCallExpression;
import org.openzen.zenscript.codemodel.expression.ConstructorThisCallExpression;
import org.openzen.zenscript.codemodel.expression.EnumConstantExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.FunctionExpression;
import org.openzen.zenscript.codemodel.expression.GetFieldExpression;
import org.openzen.zenscript.codemodel.expression.GetFunctionParameterExpression;
import org.openzen.zenscript.codemodel.expression.GetLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.GetMatchingVariantField;
import org.openzen.zenscript.codemodel.expression.GetStaticFieldExpression;
import org.openzen.zenscript.codemodel.expression.GetterExpression;
import org.openzen.zenscript.codemodel.expression.GlobalCallExpression;
import org.openzen.zenscript.codemodel.expression.GlobalExpression;
import org.openzen.zenscript.codemodel.expression.InterfaceCastExpression;
import org.openzen.zenscript.codemodel.expression.IsExpression;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.expression.MakeConstExpression;
import org.openzen.zenscript.codemodel.expression.MapExpression;
import org.openzen.zenscript.codemodel.expression.MatchExpression;
import org.openzen.zenscript.codemodel.expression.NewExpression;
import org.openzen.zenscript.codemodel.expression.NullExpression;
import org.openzen.zenscript.codemodel.expression.OrOrExpression;
import org.openzen.zenscript.codemodel.expression.PanicExpression;
import org.openzen.zenscript.codemodel.expression.PostCallExpression;
import org.openzen.zenscript.codemodel.expression.RangeExpression;
import org.openzen.zenscript.codemodel.expression.SameObjectExpression;
import org.openzen.zenscript.codemodel.expression.SetFieldExpression;
import org.openzen.zenscript.codemodel.expression.SetFunctionParameterExpression;
import org.openzen.zenscript.codemodel.expression.SetLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.SetStaticFieldExpression;
import org.openzen.zenscript.codemodel.expression.SetterExpression;
import org.openzen.zenscript.codemodel.expression.StaticGetterExpression;
import org.openzen.zenscript.codemodel.expression.StaticSetterExpression;
import org.openzen.zenscript.codemodel.expression.StorageCastExpression;
import org.openzen.zenscript.codemodel.expression.SupertypeCastExpression;
import org.openzen.zenscript.codemodel.expression.ThisExpression;
import org.openzen.zenscript.codemodel.expression.ThrowExpression;
import org.openzen.zenscript.codemodel.expression.TryConvertExpression;
import org.openzen.zenscript.codemodel.expression.TryRethrowAsExceptionExpression;
import org.openzen.zenscript.codemodel.expression.TryRethrowAsResultExpression;
import org.openzen.zenscript.codemodel.expression.VariantValueExpression;
import org.openzen.zenscript.codemodel.expression.WrapOptionalExpression;
import org.openzen.zenscript.codemodel.expression.switchvalue.VariantOptionSwitchValue;
import org.openzen.zenscript.codemodel.member.ref.DefinitionMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FieldMemberRef;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.storage.BorrowStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.UniqueStorageTag;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.JavaLocalVariableInfo;
import org.openzen.zenscript.javabytecode.compiler.CompilerUtils;
import org.openzen.zenscript.javabytecode.compiler.JavaBoxingTypeVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaCapturedExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaClassWriter;
import org.openzen.zenscript.javabytecode.compiler.JavaStatementVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaSwitchLabel;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaParameterInfo;
import org.openzen.zenscript.javashared.JavaTypeUtils;
import org.openzen.zenscript.javashared.JavaVariantOption;

public class JavaExpressionVisitor
implements ExpressionVisitor<Void> {
    private static final JavaMethod BOOLEAN_PARSE = JavaMethod.getNativeStatic(JavaClass.BOOLEAN, "parseBoolean", "(Ljava/lang/String;)Z");
    private static final JavaMethod BOOLEAN_TO_STRING = JavaMethod.getNativeStatic(JavaClass.BOOLEAN, "toString", "(Z)Ljava/lang/String;");
    private static final JavaMethod BYTE_PARSE = JavaMethod.getNativeStatic(JavaClass.BYTE, "parseByte", "(Ljava/lang/String;)B");
    private static final JavaMethod BYTE_PARSE_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.BYTE, "parseByte", "(Ljava/lang/String;I)B");
    private static final JavaField BYTE_MIN_VALUE = new JavaField(JavaClass.BYTE, "MIN_VALUE", "B");
    private static final JavaField BYTE_MAX_VALUE = new JavaField(JavaClass.BYTE, "MAX_VALUE", "B");
    private static final JavaMethod BYTE_TO_STRING = JavaMethod.getNativeStatic(JavaClass.BYTE, "toString", "(B)Ljava/lang/String;");
    private static final JavaMethod SHORT_PARSE = JavaMethod.getNativeStatic(JavaClass.SHORT, "parseShort", "(Ljava/lang/String;)S");
    private static final JavaMethod SHORT_PARSE_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.SHORT, "parseShort", "(Ljava/lang/String;I)S");
    private static final JavaField SHORT_MIN_VALUE = new JavaField(JavaClass.SHORT, "MIN_VALUE", "S");
    private static final JavaField SHORT_MAX_VALUE = new JavaField(JavaClass.SHORT, "MAX_VALUE", "S");
    private static final JavaMethod SHORT_TO_STRING = JavaMethod.getNativeStatic(JavaClass.SHORT, "toString", "(S)Ljava/lang/String;");
    private static final JavaMethod INTEGER_COMPARE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.INTEGER, "compareUnsigned", "(II)I");
    private static final JavaMethod INTEGER_DIVIDE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.INTEGER, "divideUnsigned", "(II)I");
    private static final JavaMethod INTEGER_REMAINDER_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.INTEGER, "remainderUnsigned", "(II)I");
    private static final JavaMethod INTEGER_NUMBER_OF_TRAILING_ZEROS = JavaMethod.getNativeStatic(JavaClass.INTEGER, "numberOfTrailingZeros", "(I)I");
    private static final JavaMethod INTEGER_NUMBER_OF_LEADING_ZEROS = JavaMethod.getNativeStatic(JavaClass.INTEGER, "numberOfLeadingZeros", "(I)I");
    private static final JavaMethod INTEGER_PARSE = JavaMethod.getNativeStatic(JavaClass.INTEGER, "parseInt", "(Ljava/lang/String;)I");
    private static final JavaMethod INTEGER_PARSE_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.INTEGER, "parseInt", "(Ljava/lang/String;I)I");
    private static final JavaMethod INTEGER_PARSE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.INTEGER, "parseUnsignedInt", "(Ljava/lang/String;)I");
    private static final JavaMethod INTEGER_PARSE_UNSIGNED_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.INTEGER, "parseUnsignedInt", "(Ljava/lang/String;I)I");
    private static final JavaMethod INTEGER_HIGHEST_ONE_BIT = JavaMethod.getNativeStatic(JavaClass.INTEGER, "highestOneBit", "(I)I");
    private static final JavaMethod INTEGER_LOWEST_ONE_BIT = JavaMethod.getNativeStatic(JavaClass.INTEGER, "lowestOneBit", "(I)I");
    private static final JavaMethod INTEGER_BIT_COUNT = JavaMethod.getNativeStatic(JavaClass.INTEGER, "bitCount", "(I)I");
    private static final JavaField INTEGER_MIN_VALUE = new JavaField(JavaClass.INTEGER, "MIN_VALUE", "I");
    private static final JavaField INTEGER_MAX_VALUE = new JavaField(JavaClass.INTEGER, "MAX_VALUE", "I");
    private static final JavaMethod INTEGER_TO_STRING = JavaMethod.getNativeStatic(JavaClass.INTEGER, "toString", "(I)Ljava/lang/String;");
    private static final JavaMethod INTEGER_TO_UNSIGNED_STRING = JavaMethod.getNativeStatic(JavaClass.INTEGER, "toUnsignedString", "(I)Ljava/lang/String;");
    private static final JavaMethod LONG_COMPARE = JavaMethod.getNativeStatic(JavaClass.LONG, "compare", "(JJ)I");
    private static final JavaMethod LONG_COMPARE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.LONG, "compareUnsigned", "(JJ)I");
    private static final JavaMethod LONG_DIVIDE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.LONG, "divideUnsigned", "(JJ)J");
    private static final JavaMethod LONG_REMAINDER_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.LONG, "remainderUnsigned", "(JJ)J");
    private static final JavaMethod LONG_NUMBER_OF_TRAILING_ZEROS = JavaMethod.getNativeStatic(JavaClass.LONG, "numberOfTrailingZeros", "(J)I");
    private static final JavaMethod LONG_NUMBER_OF_LEADING_ZEROS = JavaMethod.getNativeStatic(JavaClass.LONG, "numberOfLeadingZeros", "(J)I");
    private static final JavaMethod LONG_PARSE = JavaMethod.getNativeStatic(JavaClass.LONG, "parseLong", "(Ljava/lang/String;)J");
    private static final JavaMethod LONG_PARSE_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.LONG, "parseLong", "(Ljava/lang/String;I)J");
    private static final JavaMethod LONG_PARSE_UNSIGNED = JavaMethod.getNativeStatic(JavaClass.LONG, "parseUnsignedLong", "(Ljava/lang/String;)J");
    private static final JavaMethod LONG_PARSE_UNSIGNED_WITH_BASE = JavaMethod.getNativeStatic(JavaClass.LONG, "parseUnsignedLong", "(Ljava/lang/String;I)J");
    private static final JavaMethod LONG_HIGHEST_ONE_BIT = JavaMethod.getNativeStatic(JavaClass.LONG, "highestOneBit", "(J)J");
    private static final JavaMethod LONG_LOWEST_ONE_BIT = JavaMethod.getNativeStatic(JavaClass.LONG, "lowestOneBit", "(J)J");
    private static final JavaMethod LONG_BIT_COUNT = JavaMethod.getNativeStatic(JavaClass.LONG, "bitCount", "(J)I");
    private static final JavaField LONG_MIN_VALUE = new JavaField(JavaClass.LONG, "MIN_VALUE", "J");
    private static final JavaField LONG_MAX_VALUE = new JavaField(JavaClass.LONG, "MAX_VALUE", "J");
    private static final JavaMethod LONG_TO_STRING = JavaMethod.getNativeStatic(JavaClass.LONG, "toString", "(J)Ljava/lang/String;");
    private static final JavaMethod LONG_TO_UNSIGNED_STRING = JavaMethod.getNativeStatic(JavaClass.LONG, "toUnsignedString", "(J)Ljava/lang/String;");
    private static final JavaMethod FLOAT_COMPARE = JavaMethod.getNativeStatic(JavaClass.FLOAT, "compare", "(FF)I");
    private static final JavaMethod FLOAT_PARSE = JavaMethod.getNativeStatic(JavaClass.FLOAT, "parseFloat", "(Ljava/lang/String;)F");
    private static final JavaMethod FLOAT_FROM_BITS = JavaMethod.getNativeStatic(JavaClass.FLOAT, "intBitsToFloat", "(I)F");
    private static final JavaMethod FLOAT_BITS = JavaMethod.getNativeStatic(JavaClass.FLOAT, "floatToRawIntBits", "(F)I");
    private static final JavaField FLOAT_MIN_VALUE = new JavaField(JavaClass.FLOAT, "MIN_VALUE", "F");
    private static final JavaField FLOAT_MAX_VALUE = new JavaField(JavaClass.FLOAT, "MAX_VALUE", "F");
    private static final JavaMethod FLOAT_TO_STRING = JavaMethod.getNativeStatic(JavaClass.FLOAT, "toString", "(F)Ljava/lang/String;");
    private static final JavaMethod DOUBLE_COMPARE = JavaMethod.getNativeStatic(JavaClass.DOUBLE, "compare", "(DD)I");
    private static final JavaMethod DOUBLE_PARSE = JavaMethod.getNativeStatic(JavaClass.DOUBLE, "parseDouble", "(Ljava/lang/String;)D");
    private static final JavaMethod DOUBLE_FROM_BITS = JavaMethod.getNativeStatic(JavaClass.DOUBLE, "longBitsToDouble", "(J)D");
    private static final JavaMethod DOUBLE_BITS = JavaMethod.getNativeStatic(JavaClass.DOUBLE, "doubleToRawLongBits", "(D)J");
    private static final JavaField DOUBLE_MIN_VALUE = new JavaField(JavaClass.DOUBLE, "MIN_VALUE", "D");
    private static final JavaField DOUBLE_MAX_VALUE = new JavaField(JavaClass.DOUBLE, "MAX_VALUE", "D");
    private static final JavaMethod DOUBLE_TO_STRING = JavaMethod.getNativeStatic(JavaClass.DOUBLE, "toString", "(D)Ljava/lang/String;");
    private static final JavaMethod CHARACTER_TO_LOWER_CASE = JavaMethod.getNativeVirtual(JavaClass.CHARACTER, "toLowerCase", "()C");
    private static final JavaMethod CHARACTER_TO_UPPER_CASE = JavaMethod.getNativeVirtual(JavaClass.CHARACTER, "toUpperCase", "()C");
    private static final JavaField CHARACTER_MIN_VALUE = new JavaField(JavaClass.CHARACTER, "MIN_VALUE", "C");
    private static final JavaField CHARACTER_MAX_VALUE = new JavaField(JavaClass.CHARACTER, "MAX_VALUE", "C");
    private static final JavaMethod CHARACTER_TO_STRING = JavaMethod.getNativeStatic(JavaClass.CHARACTER, "toString", "(C)Ljava/lang/String;");
    private static final JavaMethod STRING_COMPARETO = JavaMethod.getNativeVirtual(JavaClass.STRING, "compareTo", "(Ljava/lang/String;)I");
    private static final JavaMethod STRING_CONCAT = JavaMethod.getNativeVirtual(JavaClass.STRING, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
    private static final JavaMethod STRING_CHAR_AT = JavaMethod.getNativeVirtual(JavaClass.STRING, "charAt", "(I)C");
    private static final JavaMethod STRING_SUBSTRING = JavaMethod.getNativeVirtual(JavaClass.STRING, "substring", "(II)Ljava/lang/String;");
    private static final JavaMethod STRING_TRIM = JavaMethod.getNativeVirtual(JavaClass.STRING, "trim", "()Ljava/lang/String;");
    private static final JavaMethod STRING_TO_LOWER_CASE = JavaMethod.getNativeVirtual(JavaClass.STRING, "toLowerCase", "()Ljava/lang/String;");
    private static final JavaMethod STRING_TO_UPPER_CASE = JavaMethod.getNativeVirtual(JavaClass.STRING, "toUpperCase", "()Ljava/lang/String;");
    private static final JavaMethod STRING_LENGTH = JavaMethod.getNativeVirtual(JavaClass.STRING, "length", "()I");
    private static final JavaMethod STRING_CHARACTERS = JavaMethod.getNativeVirtual(JavaClass.STRING, "toCharArray", "()[C");
    private static final JavaMethod STRING_ISEMPTY = JavaMethod.getNativeVirtual(JavaClass.STRING, "isEmpty", "()Z");
    private static final JavaMethod ENUM_COMPARETO = JavaMethod.getNativeVirtual(JavaClass.ENUM, "compareTo", "(Ljava/lang/Enum;)I");
    private static final JavaMethod ENUM_NAME = JavaMethod.getNativeVirtual(JavaClass.ENUM, "name", "()Ljava/lang/String;");
    private static final JavaMethod ENUM_ORDINAL = JavaMethod.getNativeVirtual(JavaClass.ENUM, "ordinal", "()I");
    private static final JavaMethod MAP_GET = JavaMethod.getNativeVirtual(JavaClass.MAP, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
    private static final JavaMethod MAP_PUT = JavaMethod.getNativeVirtual(JavaClass.MAP, "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final JavaMethod MAP_CONTAINS_KEY = JavaMethod.getNativeVirtual(JavaClass.MAP, "containsKey", "(Ljava/lang/Object;)Z");
    private static final JavaMethod MAP_SIZE = JavaMethod.getNativeVirtual(JavaClass.MAP, "size", "()I");
    private static final JavaMethod MAP_ISEMPTY = JavaMethod.getNativeVirtual(JavaClass.MAP, "isEmpty", "()Z");
    private static final JavaMethod MAP_KEYS = JavaMethod.getNativeVirtual(JavaClass.MAP, "keys", "()Ljava/lang/Object;");
    private static final JavaMethod MAP_VALUES = JavaMethod.getNativeVirtual(JavaClass.MAP, "values", "()Ljava/lang/Object;");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_OBJECTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([Ljava/lang/Object;II)[Ljava/lang/Object;");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_BOOLS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([ZII)[Z");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_BYTES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([BII)[B");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_SHORTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([SII)[S");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_INTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([III)[I");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_LONGS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([JII)[J");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_FLOATS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([FII)[F");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_DOUBLES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([DII)[D");
    private static final JavaMethod ARRAYS_COPY_OF_RANGE_CHARS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "copyOfRange", "([CII)[C");
    private static final JavaMethod ARRAYS_EQUALS_OBJECTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([Ljava/lang/Object[Ljava/lang/Object)Z");
    private static final JavaMethod ARRAYS_EQUALS_BOOLS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([Z[Z)Z");
    private static final JavaMethod ARRAYS_EQUALS_BYTES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([B[B)Z");
    private static final JavaMethod ARRAYS_EQUALS_SHORTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([S[S)Z");
    private static final JavaMethod ARRAYS_EQUALS_INTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([I[I)Z");
    private static final JavaMethod ARRAYS_EQUALS_LONGS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([L[L)Z");
    private static final JavaMethod ARRAYS_EQUALS_FLOATS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([F[F)Z");
    private static final JavaMethod ARRAYS_EQUALS_DOUBLES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([D[D)Z");
    private static final JavaMethod ARRAYS_EQUALS_CHARS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "equals", "([C[C)Z");
    private static final JavaMethod ARRAYS_DEEPHASHCODE = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "deepHashCode", "([Ljava/lang/Object;)");
    private static final JavaMethod ARRAYS_HASHCODE_BOOLS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([Z)I");
    private static final JavaMethod ARRAYS_HASHCODE_BYTES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([B)I");
    private static final JavaMethod ARRAYS_HASHCODE_SHORTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([S)I");
    private static final JavaMethod ARRAYS_HASHCODE_INTS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([I)I");
    private static final JavaMethod ARRAYS_HASHCODE_LONGS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([L)I");
    private static final JavaMethod ARRAYS_HASHCODE_FLOATS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([F)I");
    private static final JavaMethod ARRAYS_HASHCODE_DOUBLES = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([D)I");
    private static final JavaMethod ARRAYS_HASHCODE_CHARS = JavaMethod.getNativeStatic(JavaClass.ARRAYS, "hashCode", "([C)I");
    public static final JavaMethod OBJECT_HASHCODE = JavaMethod.getNativeVirtual(JavaClass.OBJECT, "hashCode", "()I");
    private static final JavaMethod COLLECTION_SIZE = JavaMethod.getNativeVirtual(JavaClass.COLLECTION, "size", "()I");
    private static final JavaMethod COLLECTION_TOARRAY = JavaMethod.getNativeVirtual(JavaClass.COLLECTION, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
    private static final JavaMethod SHARED_INIT = JavaMethod.getConstructor(JavaClass.SHARED, "(Ljava/lang/Object;)V", 1);
    private static final JavaMethod SHARED_GET = JavaMethod.getNativeVirtual(JavaClass.SHARED, "get", "()Ljava/lang/Object;");
    private static final JavaMethod SHARED_ADDREF = JavaMethod.getNativeVirtual(JavaClass.SHARED, "addRef", "()V");
    private static final JavaMethod SHARED_RELEASE = JavaMethod.getNativeVirtual(JavaClass.SHARED, "release", "()V");
    protected final JavaWriter javaWriter;
    private final JavaCapturedExpressionVisitor capturedExpressionVisitor = new JavaCapturedExpressionVisitor(this);
    private final JavaBytecodeContext context;
    private final JavaCompiledModule module;

    public JavaExpressionVisitor(JavaBytecodeContext context, JavaCompiledModule module, JavaWriter javaWriter) {
        this.javaWriter = javaWriter;
        this.context = context;
        this.module = module;
    }

    @Override
    public Void visitAndAnd(AndAndExpression expression) {
        Label end = new Label();
        Label onFalse = new Label();
        expression.left.accept(this);
        this.javaWriter.ifEQ(onFalse);
        expression.right.accept(this);
        this.javaWriter.goTo(end);
        this.javaWriter.label(onFalse);
        this.javaWriter.iConst0();
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitArray(ArrayExpression expression) {
        this.javaWriter.constant(expression.expressions.length);
        Type type = this.context.getType(((ArrayTypeID)expression.type.type).elementType);
        this.javaWriter.newArray(type);
        for (int i = 0; i < expression.expressions.length; ++i) {
            this.javaWriter.dup();
            this.javaWriter.constant(i);
            expression.expressions[i].accept(this);
            this.javaWriter.arrayStore(type);
        }
        return null;
    }

    @Override
    public Void visitCompare(CompareExpression expression) {
        block16: {
            block15: {
                if (expression.operator.getBuiltin() == null) break block15;
                switch (expression.operator.getBuiltin()) {
                    case BYTE_COMPARE: {
                        expression.left.accept(this);
                        this.javaWriter.constant(255);
                        this.javaWriter.iAnd();
                        expression.right.accept(this);
                        this.javaWriter.constant(255);
                        this.javaWriter.iAnd();
                        this.compareInt(expression.comparison);
                        break block16;
                    }
                    case USHORT_COMPARE: {
                        expression.left.accept(this);
                        this.javaWriter.constant(65535);
                        this.javaWriter.iAnd();
                        expression.right.accept(this);
                        this.javaWriter.constant(65535);
                        this.javaWriter.iAnd();
                        this.compareInt(expression.comparison);
                        break block16;
                    }
                    case SBYTE_COMPARE: 
                    case SHORT_COMPARE: 
                    case INT_COMPARE: 
                    case CHAR_COMPARE: 
                    case USIZE_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.compareInt(expression.comparison);
                        break block16;
                    }
                    case UINT_COMPARE: 
                    case USIZE_COMPARE_UINT: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeStatic(INTEGER_COMPARE_UNSIGNED);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case LONG_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeStatic(LONG_COMPARE);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case ULONG_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeStatic(LONG_COMPARE_UNSIGNED);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case ULONG_COMPARE_UINT: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.i2l();
                        this.javaWriter.constant(0xFFFFFFFFL);
                        this.javaWriter.lAnd();
                        this.javaWriter.invokeStatic(LONG_COMPARE_UNSIGNED);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case ULONG_COMPARE_USIZE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.i2l();
                        this.javaWriter.invokeStatic(LONG_COMPARE_UNSIGNED);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case FLOAT_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeStatic(FLOAT_COMPARE);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case DOUBLE_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeStatic(DOUBLE_COMPARE);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case STRING_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeVirtual(STRING_COMPARETO);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    case ENUM_COMPARE: {
                        expression.left.accept(this);
                        expression.right.accept(this);
                        this.javaWriter.invokeVirtual(ENUM_COMPARETO);
                        this.compareGeneric(expression.comparison);
                        break block16;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown builtin comparator: " + (Object)((Object)expression.operator.getBuiltin()));
                    }
                }
            }
            if (!this.checkAndExecuteMethodInfo(expression.operator, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            expression.left.accept(this);
            expression.right.accept(this);
            this.compareGeneric(expression.comparison);
        }
        return null;
    }

    private void compareInt(CompareType comparator) {
        Label exit = new Label();
        Label isTrue = new Label();
        switch (comparator) {
            case EQ: {
                this.javaWriter.ifICmpEQ(isTrue);
                break;
            }
            case NE: {
                this.javaWriter.ifICmpNE(isTrue);
                break;
            }
            case GT: {
                this.javaWriter.ifICmpGT(isTrue);
                break;
            }
            case GE: {
                this.javaWriter.ifICmpGE(isTrue);
                break;
            }
            case LT: {
                this.javaWriter.ifICmpLT(isTrue);
                break;
            }
            case LE: {
                this.javaWriter.ifICmpLE(isTrue);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid comparator: " + (Object)((Object)comparator));
            }
        }
        this.javaWriter.iConst0();
        this.javaWriter.goTo(exit);
        this.javaWriter.label(isTrue);
        this.javaWriter.iConst1();
        this.javaWriter.label(exit);
    }

    private void compareGeneric(CompareType comparator) {
        Label exit = new Label();
        Label isTrue = new Label();
        switch (comparator) {
            case EQ: {
                this.javaWriter.ifEQ(isTrue);
                break;
            }
            case NE: {
                this.javaWriter.ifNE(isTrue);
                break;
            }
            case GT: {
                this.javaWriter.ifGT(isTrue);
                break;
            }
            case GE: {
                this.javaWriter.ifGE(isTrue);
                break;
            }
            case LT: {
                this.javaWriter.ifLT(isTrue);
                break;
            }
            case LE: {
                this.javaWriter.ifLE(isTrue);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid comparator: " + (Object)((Object)comparator));
            }
        }
        this.javaWriter.iConst0();
        this.javaWriter.goTo(exit);
        this.javaWriter.label(isTrue);
        this.javaWriter.iConst1();
        this.javaWriter.label(exit);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Void visitCall(CallExpression expression) {
        builtin = expression.member.getBuiltin();
        if (builtin == null) {
            expression.target.accept(this);
            for (Expression argument : expression.arguments.arguments) {
                argument.accept(this);
            }
            if (!this.checkAndExecuteMethodInfo(expression.member, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            if (expression.member.getTarget().header.getReturnType().isGeneric()) {
                this.javaWriter.checkCast(this.context.getInternalName(expression.type));
            }
            return null;
        }
        switch (2.$SwitchMap$org$openzen$zenscript$codemodel$type$member$BuiltinID[builtin.ordinal()]) {
            case 18: 
            case 19: {
                break;
            }
            default: {
                expression.target.accept(this);
                for (Expression argument : expression.arguments.arguments) {
                    argument.accept(this);
                }
            }
        }
        block3 : switch (2.$SwitchMap$org$openzen$zenscript$codemodel$type$member$BuiltinID[builtin.ordinal()]) {
            case 20: {
                this.javaWriter.iConst1();
                this.javaWriter.iXor();
                break;
            }
            case 21: {
                this.javaWriter.iAnd();
                break;
            }
            case 22: {
                this.javaWriter.iOr();
                break;
            }
            case 23: {
                this.javaWriter.iXor();
                break;
            }
            case 24: {
                this.javaWriter.iXor();
                this.javaWriter.iConst1();
                this.javaWriter.iXor();
                break;
            }
            case 25: {
                this.javaWriter.iXor();
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                this.javaWriter.iNot();
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                this.javaWriter.iNeg();
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                this.javaWriter.iAdd();
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.javaWriter.iSub();
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                this.javaWriter.iMul();
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                this.javaWriter.iDiv();
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.javaWriter.iRem();
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_DIVIDE_UNSIGNED);
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_REMAINDER_UNSIGNED);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                this.javaWriter.iAnd();
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                this.javaWriter.iOr();
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                this.javaWriter.iXor();
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                this.javaWriter.iShl();
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                this.javaWriter.iShr();
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                this.javaWriter.iUShr();
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_NUMBER_OF_TRAILING_ZEROS);
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_NUMBER_OF_LEADING_ZEROS);
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                this.javaWriter.iNot();
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_NUMBER_OF_TRAILING_ZEROS);
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                this.javaWriter.iNot();
                this.javaWriter.invokeStatic(JavaExpressionVisitor.INTEGER_NUMBER_OF_LEADING_ZEROS);
                break;
            }
            case 121: 
            case 122: {
                this.javaWriter.lNot();
                break;
            }
            case 123: {
                this.javaWriter.lNeg();
                break;
            }
            case 124: 
            case 125: {
                this.javaWriter.lAdd();
                break;
            }
            case 126: 
            case 127: {
                this.javaWriter.lSub();
                break;
            }
            case 128: 
            case 129: {
                this.javaWriter.lMul();
                break;
            }
            case 130: {
                this.javaWriter.lDiv();
                break;
            }
            case 131: {
                this.javaWriter.lRem();
                break;
            }
            case 132: 
            case 133: {
                this.javaWriter.lAnd();
                break;
            }
            case 134: 
            case 135: {
                this.javaWriter.lOr();
                break;
            }
            case 136: 
            case 137: {
                this.javaWriter.lXor();
                break;
            }
            case 138: 
            case 139: {
                this.javaWriter.lShl();
                break;
            }
            case 140: {
                this.javaWriter.lShr();
                break;
            }
            case 141: 
            case 142: {
                this.javaWriter.lUShr();
                break;
            }
            case 143: 
            case 144: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_NUMBER_OF_TRAILING_ZEROS);
                break;
            }
            case 145: 
            case 146: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_NUMBER_OF_LEADING_ZEROS);
                break;
            }
            case 147: 
            case 148: {
                this.javaWriter.lNot();
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_NUMBER_OF_TRAILING_ZEROS);
                break;
            }
            case 149: 
            case 150: {
                this.javaWriter.lNot();
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_NUMBER_OF_LEADING_ZEROS);
                break;
            }
            case 151: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_DIVIDE_UNSIGNED);
                break;
            }
            case 152: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.LONG_REMAINDER_UNSIGNED);
                break;
            }
            case 153: {
                this.javaWriter.fNeg();
                break;
            }
            case 154: {
                this.javaWriter.fAdd();
                break;
            }
            case 155: {
                this.javaWriter.fSub();
                break;
            }
            case 156: {
                this.javaWriter.fMul();
                break;
            }
            case 157: {
                this.javaWriter.fDiv();
                break;
            }
            case 158: {
                this.javaWriter.fRem();
                break;
            }
            case 159: {
                this.javaWriter.dNeg();
                break;
            }
            case 160: {
                this.javaWriter.dAdd();
                break;
            }
            case 161: {
                this.javaWriter.dSub();
                break;
            }
            case 162: {
                this.javaWriter.dMul();
                break;
            }
            case 163: {
                this.javaWriter.dDiv();
                break;
            }
            case 164: {
                this.javaWriter.dRem();
                break;
            }
            case 165: {
                this.javaWriter.iAdd();
                break;
            }
            case 166: 
            case 167: {
                this.javaWriter.iSub();
                break;
            }
            case 168: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 169: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.CHARACTER_TO_LOWER_CASE);
                break;
            }
            case 170: {
                this.javaWriter.invokeStatic(JavaExpressionVisitor.CHARACTER_TO_UPPER_CASE);
                break;
            }
            case 171: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_CONCAT);
                break;
            }
            case 172: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_CHAR_AT);
                break;
            }
            case 18: {
                expression.target.accept(this);
                argument = expression.arguments.arguments[0];
                if (argument instanceof RangeExpression) {
                    rangeArgument = (RangeExpression)argument;
                    rangeArgument.from.accept(this);
                    rangeArgument.to.accept(this);
                } else {
                    argument.accept(this);
                    this.javaWriter.dup();
                    tmp = this.javaWriter.local(Type.getType((String)"zsynthetic/IntRange"));
                    this.javaWriter.storeInt(tmp);
                    this.javaWriter.getField("zsynthetic/IntRange", "from", "I");
                    this.javaWriter.loadInt(tmp);
                    this.javaWriter.getField("zsynthetic/IntRange", "to", "I");
                }
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_SUBSTRING);
                break;
            }
            case 173: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 174: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_TRIM);
                break;
            }
            case 175: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_TO_LOWER_CASE);
                break;
            }
            case 176: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.STRING_TO_UPPER_CASE);
                break;
            }
            case 177: 
            case 178: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_GET);
                type /* !! */  = (AssocTypeID)expression.target.type.type;
                this.javaWriter.checkCast(this.context.getInternalName(type /* !! */ .valueType));
                break;
            }
            case 179: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_PUT);
                this.javaWriter.pop();
                break;
            }
            case 180: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_CONTAINS_KEY);
                break;
            }
            case 181: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 182: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                exit = new Label();
                this.javaWriter.iConst0();
                this.javaWriter.ifACmpNe(exit);
                this.javaWriter.iConst1();
                this.javaWriter.label(exit);
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: {
                exit = new Label();
                this.javaWriter.iConst0();
                this.javaWriter.ifACmpEq(exit);
                this.javaWriter.iConst1();
                this.javaWriter.label(exit);
                break;
            }
            case 193: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_GET);
                break;
            }
            case 194: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_PUT);
                this.javaWriter.pop();
                break;
            }
            case 195: {
                this.javaWriter.invokeVirtual(JavaExpressionVisitor.MAP_CONTAINS_KEY);
                break;
            }
            case 196: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 197: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 198: {
                type /* !! */  = (ArrayTypeID)expression.target.type.type;
                this.javaWriter.arrayLoad(this.context.getType(type /* !! */ .elementType));
                break;
            }
            case 199: {
                type /* !! */  = (ArrayTypeID)expression.target.type.type;
                this.javaWriter.arrayStore(this.context.getType(type /* !! */ .elementType));
                break;
            }
            case 19: {
                type /* !! */  = (ArrayTypeID)expression.target.type.type;
                expression.target.accept(this);
                argument = expression.arguments.arguments[0];
                if (argument instanceof RangeExpression) {
                    rangeArgument = (RangeExpression)argument;
                    rangeArgument.from.accept(this);
                    rangeArgument.to.accept(this);
                } else {
                    argument.accept(this);
                    this.javaWriter.dup();
                    tmp = this.javaWriter.local(Type.getType((String)"zsynthetic/IntRange"));
                    this.javaWriter.storeInt(tmp);
                    this.javaWriter.getField("zsynthetic/IntRange", "from", "I");
                    this.javaWriter.loadInt(tmp);
                    this.javaWriter.getField("zsynthetic/IntRange", "to", "I");
                }
                if (type /* !! */ .elementType.type instanceof BasicTypeID) {
                    switch (2.$SwitchMap$org$openzen$zenscript$codemodel$type$BasicTypeID[((BasicTypeID)type /* !! */ .elementType.type).ordinal()]) {
                        case 1: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_BOOLS);
                            break block3;
                        }
                        case 2: 
                        case 3: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_BYTES);
                            break block3;
                        }
                        case 4: 
                        case 5: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_SHORTS);
                            break block3;
                        }
                        case 6: 
                        case 7: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_INTS);
                            break block3;
                        }
                        case 8: 
                        case 9: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_LONGS);
                            break block3;
                        }
                        case 10: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_FLOATS);
                            break block3;
                        }
                        case 11: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_DOUBLES);
                            break block3;
                        }
                        case 12: {
                            this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_CHARS);
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Unknown basic type: " + type /* !! */ .elementType);
                }
                this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_COPY_OF_RANGE_OBJECTS);
                this.javaWriter.checkCast(this.context.getInternalName(expression.target.type));
                break;
            }
            case 200: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            case 201: 
            case 202: {
                type /* !! */  = (ArrayTypeID)expression.target.type.type;
                if (!(type /* !! */ .elementType.type instanceof BasicTypeID)) ** GOTO lbl386
                switch (2.$SwitchMap$org$openzen$zenscript$codemodel$type$BasicTypeID[((BasicTypeID)type /* !! */ .elementType.type).ordinal()]) {
                    case 1: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_BOOLS);
                        ** GOTO lbl387
                    }
                    case 2: 
                    case 3: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_BYTES);
                        ** GOTO lbl387
                    }
                    case 4: 
                    case 5: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_SHORTS);
                        ** GOTO lbl387
                    }
                    case 6: 
                    case 7: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_INTS);
                        ** GOTO lbl387
                    }
                    case 8: 
                    case 9: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_LONGS);
                        ** GOTO lbl387
                    }
                    case 10: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_FLOATS);
                        ** GOTO lbl387
                    }
                    case 11: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_DOUBLES);
                        ** GOTO lbl387
                    }
                    case 12: {
                        this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_CHARS);
                        ** GOTO lbl387
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown basic type: " + type /* !! */ .elementType);
                    }
                }
lbl386:
                // 1 sources

                this.javaWriter.invokeStatic(JavaExpressionVisitor.ARRAYS_EQUALS_OBJECTS);
lbl387:
                // 9 sources

                if (builtin != BuiltinID.ARRAY_NOTEQUALS) break;
                this.javaWriter.iConst1();
                this.javaWriter.iXor();
                break;
            }
            case 203: {
                this.javaWriter.invokeInterface(JavaMethod.getNativeVirtual(JavaClass.fromInternalName(this.context.getInternalName(expression.target.type), JavaClass.Kind.INTERFACE), "accept", this.context.getMethodDescriptor(expression.instancedHeader)));
                break;
            }
            case 204: {
                throw new UnsupportedOperationException("Not yet supported!");
            }
            default: {
                throw new UnsupportedOperationException("Unknown builtin: " + (Object)builtin);
            }
        }
        return null;
    }

    @Override
    public Void visitCallStatic(CallStaticExpression expression) {
        for (Expression argument : expression.arguments.arguments) {
            argument.accept(this);
        }
        BuiltinID builtin = expression.member.getBuiltin();
        if (builtin == null) {
            if (!this.checkAndExecuteMethodInfo(expression.member, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            return null;
        }
        switch (builtin) {
            case BOOL_PARSE: {
                this.javaWriter.invokeStatic(BOOLEAN_PARSE);
                break;
            }
            case BYTE_PARSE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED);
                break;
            }
            case BYTE_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED_WITH_BASE);
                break;
            }
            case SBYTE_PARSE: {
                this.javaWriter.invokeStatic(BYTE_PARSE);
                break;
            }
            case SBYTE_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(BYTE_PARSE_WITH_BASE);
                break;
            }
            case SHORT_PARSE: {
                this.javaWriter.invokeStatic(SHORT_PARSE);
                break;
            }
            case SHORT_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(SHORT_PARSE_WITH_BASE);
                break;
            }
            case USHORT_PARSE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED);
                break;
            }
            case USHORT_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED_WITH_BASE);
                break;
            }
            case INT_PARSE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE);
                break;
            }
            case INT_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_WITH_BASE);
                break;
            }
            case UINT_PARSE: 
            case USIZE_PARSE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED);
                break;
            }
            case UINT_PARSE_WITH_BASE: 
            case USIZE_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(INTEGER_PARSE_UNSIGNED_WITH_BASE);
                break;
            }
            case LONG_PARSE: {
                this.javaWriter.invokeStatic(LONG_PARSE);
                break;
            }
            case LONG_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(LONG_PARSE_WITH_BASE);
                break;
            }
            case ULONG_PARSE: {
                this.javaWriter.invokeStatic(LONG_PARSE_UNSIGNED);
                break;
            }
            case ULONG_PARSE_WITH_BASE: {
                this.javaWriter.invokeStatic(LONG_PARSE_UNSIGNED_WITH_BASE);
                break;
            }
            case FLOAT_FROM_BITS: {
                this.javaWriter.invokeStatic(FLOAT_FROM_BITS);
                break;
            }
            case FLOAT_PARSE: {
                this.javaWriter.invokeStatic(FLOAT_PARSE);
                break;
            }
            case DOUBLE_FROM_BITS: {
                this.javaWriter.invokeStatic(DOUBLE_FROM_BITS);
                break;
            }
            case DOUBLE_PARSE: {
                this.javaWriter.invokeStatic(DOUBLE_PARSE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown builtin: " + (Object)((Object)builtin));
            }
        }
        return null;
    }

    @Override
    public Void visitCapturedClosure(CapturedClosureExpression expression) {
        return expression.accept(this.capturedExpressionVisitor);
    }

    @Override
    public Void visitCapturedDirect(CapturedDirectExpression expression) {
        return expression.accept(this.capturedExpressionVisitor);
    }

    @Override
    public Void visitCapturedLocalVariable(CapturedLocalVariableExpression expression) {
        return expression.accept(this.capturedExpressionVisitor);
    }

    @Override
    public Void visitCapturedParameter(CapturedParameterExpression expression) {
        return expression.accept(this.capturedExpressionVisitor);
    }

    @Override
    public Void visitCapturedThis(CapturedThisExpression expression) {
        return expression.accept(this.capturedExpressionVisitor);
    }

    @Override
    public Void visitCast(CastExpression expression) {
        expression.target.accept(this);
        BuiltinID builtin = expression.member.member.builtin;
        if (builtin == null) {
            if (!this.checkAndExecuteMethodInfo(expression.member, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            return null;
        }
        switch (builtin) {
            case BOOL_TO_STRING: {
                this.javaWriter.invokeStatic(BOOLEAN_TO_STRING);
                break;
            }
            case BYTE_TO_SBYTE: {
                this.javaWriter.i2b();
                break;
            }
            case BYTE_TO_SHORT: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                this.javaWriter.i2s();
                break;
            }
            case BYTE_TO_USHORT: 
            case BYTE_TO_INT: 
            case BYTE_TO_UINT: 
            case BYTE_TO_USIZE: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                break;
            }
            case BYTE_TO_LONG: 
            case BYTE_TO_ULONG: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                this.javaWriter.i2l();
                break;
            }
            case BYTE_TO_FLOAT: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                this.javaWriter.i2f();
                break;
            }
            case BYTE_TO_DOUBLE: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                this.javaWriter.i2d();
                break;
            }
            case BYTE_TO_CHAR: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                break;
            }
            case BYTE_TO_STRING: {
                this.javaWriter.constant(255);
                this.javaWriter.iAnd();
                this.javaWriter.invokeStatic(INTEGER_TO_STRING);
                break;
            }
            case SBYTE_TO_BYTE: 
            case SBYTE_TO_SHORT: 
            case SBYTE_TO_USHORT: 
            case SBYTE_TO_INT: 
            case SBYTE_TO_UINT: 
            case SBYTE_TO_USIZE: {
                break;
            }
            case SBYTE_TO_LONG: 
            case SBYTE_TO_ULONG: {
                this.javaWriter.i2l();
                break;
            }
            case SBYTE_TO_FLOAT: {
                this.javaWriter.i2f();
                break;
            }
            case SBYTE_TO_DOUBLE: {
                this.javaWriter.i2d();
                break;
            }
            case SBYTE_TO_CHAR: {
                break;
            }
            case SBYTE_TO_STRING: {
                this.javaWriter.invokeStatic(INTEGER_TO_STRING);
                break;
            }
            case SHORT_TO_BYTE: {
                break;
            }
            case SHORT_TO_SBYTE: {
                this.javaWriter.i2b();
                break;
            }
            case SHORT_TO_USHORT: 
            case SHORT_TO_INT: 
            case SHORT_TO_UINT: 
            case SHORT_TO_USIZE: {
                break;
            }
            case SHORT_TO_LONG: 
            case SHORT_TO_ULONG: {
                this.javaWriter.i2l();
                break;
            }
            case SHORT_TO_FLOAT: {
                this.javaWriter.i2f();
                break;
            }
            case SHORT_TO_DOUBLE: {
                this.javaWriter.i2d();
                break;
            }
            case SHORT_TO_CHAR: {
                break;
            }
            case SHORT_TO_STRING: {
                this.javaWriter.invokeStatic(SHORT_TO_STRING);
                break;
            }
            case USHORT_TO_BYTE: {
                break;
            }
            case USHORT_TO_SBYTE: {
                this.javaWriter.i2b();
                break;
            }
            case USHORT_TO_SHORT: {
                this.javaWriter.i2s();
                break;
            }
            case USHORT_TO_INT: 
            case USHORT_TO_UINT: 
            case USHORT_TO_USIZE: {
                this.javaWriter.constant(65535);
                this.javaWriter.iAnd();
                break;
            }
            case USHORT_TO_LONG: 
            case USHORT_TO_ULONG: {
                this.javaWriter.constant(65535L);
                this.javaWriter.iAnd();
                break;
            }
            case USHORT_TO_FLOAT: {
                this.javaWriter.constant(65535L);
                this.javaWriter.iAnd();
                this.javaWriter.i2f();
                break;
            }
            case USHORT_TO_DOUBLE: {
                this.javaWriter.constant(65535L);
                this.javaWriter.iAnd();
                this.javaWriter.i2d();
                break;
            }
            case USHORT_TO_CHAR: {
                this.javaWriter.constant(65535L);
                this.javaWriter.iAnd();
                break;
            }
            case USHORT_TO_STRING: {
                this.javaWriter.constant(65535L);
                this.javaWriter.iAnd();
                this.javaWriter.invokeStatic(INTEGER_TO_STRING);
                break;
            }
            case INT_TO_BYTE: 
            case USIZE_TO_BYTE: {
                break;
            }
            case INT_TO_SBYTE: 
            case USIZE_TO_SBYTE: {
                this.javaWriter.i2b();
                break;
            }
            case INT_TO_SHORT: 
            case USIZE_TO_SHORT: {
                this.javaWriter.i2s();
                break;
            }
            case INT_TO_USHORT: 
            case USIZE_TO_USHORT: {
                break;
            }
            case INT_TO_UINT: 
            case USIZE_TO_INT: 
            case USIZE_TO_UINT: 
            case INT_TO_USIZE: {
                break;
            }
            case INT_TO_LONG: 
            case INT_TO_ULONG: 
            case USIZE_TO_LONG: 
            case USIZE_TO_ULONG: {
                this.javaWriter.i2l();
                break;
            }
            case INT_TO_FLOAT: 
            case USIZE_TO_FLOAT: {
                this.javaWriter.i2f();
                break;
            }
            case INT_TO_DOUBLE: 
            case USIZE_TO_DOUBLE: {
                this.javaWriter.i2d();
                break;
            }
            case INT_TO_CHAR: 
            case USIZE_TO_CHAR: {
                this.javaWriter.i2s();
                break;
            }
            case INT_TO_STRING: 
            case USIZE_TO_STRING: {
                this.javaWriter.invokeStatic(INTEGER_TO_STRING);
                break;
            }
            case UINT_TO_BYTE: {
                break;
            }
            case UINT_TO_SBYTE: {
                this.javaWriter.i2b();
                break;
            }
            case UINT_TO_SHORT: {
                this.javaWriter.i2s();
                break;
            }
            case UINT_TO_USHORT: 
            case UINT_TO_INT: 
            case UINT_TO_USIZE: {
                break;
            }
            case UINT_TO_LONG: {
                this.javaWriter.i2l();
                break;
            }
            case UINT_TO_ULONG: {
                this.javaWriter.i2l();
                this.javaWriter.constant(0xFFFFFFFFL);
                this.javaWriter.lAnd();
                break;
            }
            case UINT_TO_FLOAT: {
                this.javaWriter.i2l();
                this.javaWriter.constant(0xFFFFFFFFL);
                this.javaWriter.lAnd();
                this.javaWriter.l2f();
                break;
            }
            case UINT_TO_DOUBLE: {
                this.javaWriter.i2l();
                this.javaWriter.constant(0xFFFFFFFFL);
                this.javaWriter.lAnd();
                this.javaWriter.l2d();
                break;
            }
            case UINT_TO_CHAR: {
                this.javaWriter.i2s();
                break;
            }
            case UINT_TO_STRING: {
                this.javaWriter.invokeStatic(INTEGER_TO_UNSIGNED_STRING);
                break;
            }
            case LONG_TO_BYTE: {
                this.javaWriter.l2i();
                break;
            }
            case LONG_TO_SBYTE: {
                this.javaWriter.l2i();
                this.javaWriter.i2b();
                break;
            }
            case LONG_TO_SHORT: {
                this.javaWriter.l2i();
                this.javaWriter.i2s();
                break;
            }
            case LONG_TO_USHORT: 
            case LONG_TO_INT: 
            case LONG_TO_UINT: 
            case LONG_TO_USIZE: {
                this.javaWriter.l2i();
                break;
            }
            case LONG_TO_ULONG: {
                break;
            }
            case LONG_TO_FLOAT: {
                this.javaWriter.l2f();
                break;
            }
            case LONG_TO_DOUBLE: {
                this.javaWriter.l2d();
                break;
            }
            case LONG_TO_CHAR: {
                this.javaWriter.l2i();
                this.javaWriter.i2s();
                break;
            }
            case LONG_TO_STRING: {
                this.javaWriter.invokeStatic(LONG_TO_STRING);
                break;
            }
            case ULONG_TO_BYTE: {
                this.javaWriter.l2i();
                break;
            }
            case ULONG_TO_SBYTE: {
                this.javaWriter.l2i();
                this.javaWriter.i2b();
                break;
            }
            case ULONG_TO_SHORT: {
                this.javaWriter.l2i();
                this.javaWriter.i2s();
                break;
            }
            case ULONG_TO_USHORT: 
            case ULONG_TO_INT: 
            case ULONG_TO_UINT: 
            case ULONG_TO_USIZE: {
                this.javaWriter.l2i();
                break;
            }
            case ULONG_TO_LONG: {
                break;
            }
            case ULONG_TO_FLOAT: {
                this.javaWriter.l2f();
                break;
            }
            case ULONG_TO_DOUBLE: {
                this.javaWriter.l2d();
            }
            case ULONG_TO_CHAR: {
                this.javaWriter.l2i();
                this.javaWriter.i2s();
                break;
            }
            case ULONG_TO_STRING: {
                this.javaWriter.invokeStatic(LONG_TO_UNSIGNED_STRING);
                break;
            }
            case FLOAT_TO_BYTE: {
                this.javaWriter.f2i();
                break;
            }
            case FLOAT_TO_SBYTE: {
                this.javaWriter.f2i();
                this.javaWriter.i2b();
                break;
            }
            case FLOAT_TO_SHORT: {
                this.javaWriter.f2i();
                this.javaWriter.i2s();
                break;
            }
            case FLOAT_TO_USHORT: 
            case FLOAT_TO_UINT: 
            case FLOAT_TO_INT: 
            case FLOAT_TO_USIZE: {
                this.javaWriter.f2i();
                break;
            }
            case FLOAT_TO_LONG: 
            case FLOAT_TO_ULONG: {
                this.javaWriter.f2l();
                break;
            }
            case FLOAT_TO_DOUBLE: {
                this.javaWriter.f2d();
                break;
            }
            case FLOAT_TO_STRING: {
                this.javaWriter.invokeStatic(FLOAT_TO_STRING);
                break;
            }
            case DOUBLE_TO_BYTE: {
                this.javaWriter.d2i();
                break;
            }
            case DOUBLE_TO_SBYTE: {
                this.javaWriter.d2i();
                this.javaWriter.i2b();
                break;
            }
            case DOUBLE_TO_SHORT: {
                this.javaWriter.d2i();
                this.javaWriter.i2s();
                break;
            }
            case DOUBLE_TO_USHORT: 
            case DOUBLE_TO_INT: 
            case DOUBLE_TO_UINT: 
            case DOUBLE_TO_USIZE: {
                this.javaWriter.d2i();
                break;
            }
            case DOUBLE_TO_LONG: 
            case DOUBLE_TO_ULONG: {
                this.javaWriter.d2l();
                break;
            }
            case DOUBLE_TO_FLOAT: {
                this.javaWriter.d2f();
                break;
            }
            case DOUBLE_TO_STRING: {
                this.javaWriter.invokeStatic(DOUBLE_TO_STRING);
                break;
            }
            case CHAR_TO_BYTE: {
                break;
            }
            case CHAR_TO_SBYTE: {
                this.javaWriter.i2s();
                break;
            }
            case CHAR_TO_SHORT: 
            case CHAR_TO_USHORT: 
            case CHAR_TO_INT: 
            case CHAR_TO_UINT: 
            case CHAR_TO_USIZE: {
                break;
            }
            case CHAR_TO_LONG: 
            case CHAR_TO_ULONG: {
                this.javaWriter.i2l();
                break;
            }
            case CHAR_TO_STRING: {
                this.javaWriter.invokeStatic(CHARACTER_TO_STRING);
                break;
            }
            case ENUM_TO_STRING: {
                this.javaWriter.invokeVirtual(ENUM_NAME);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown builtin cast: " + (Object)((Object)builtin));
            }
        }
        return null;
    }

    @Override
    public Void visitCheckNull(CheckNullExpression expression) {
        Label end = new Label();
        expression.value.accept(this);
        this.javaWriter.dup();
        this.javaWriter.ifNonNull(end);
        this.javaWriter.pop();
        this.javaWriter.newObject("java/lang/NullPointerException");
        this.javaWriter.dup();
        this.javaWriter.constant("Tried to convert a null value to nonnull type " + this.context.getType(expression.type).getClassName());
        this.javaWriter.invokeSpecial(NullPointerException.class, "<init>", "(Ljava/lang/String;)V");
        this.javaWriter.aThrow();
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitCoalesce(CoalesceExpression expression) {
        Label end = new Label();
        expression.left.accept(this);
        this.javaWriter.dup();
        this.javaWriter.ifNonNull(end);
        this.javaWriter.pop();
        expression.right.accept(this);
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitConditional(ConditionalExpression expression) {
        Label end = new Label();
        Label onElse = new Label();
        expression.condition.accept(this);
        this.javaWriter.ifEQ(onElse);
        expression.ifThen.accept(this);
        this.javaWriter.goTo(end);
        this.javaWriter.label(onElse);
        expression.ifElse.accept(this);
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitConst(ConstExpression expression) {
        BuiltinID builtin = expression.constant.member.builtin;
        if (builtin == null) {
            this.javaWriter.getStaticField(this.context.getJavaField(expression.constant));
            return null;
        }
        switch (builtin) {
            case BYTE_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case BYTE_GET_MAX_VALUE: {
                this.javaWriter.constant(255);
                break;
            }
            case SBYTE_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(BYTE_MIN_VALUE);
                break;
            }
            case SBYTE_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(BYTE_MAX_VALUE);
                break;
            }
            case SHORT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(SHORT_MIN_VALUE);
                break;
            }
            case SHORT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(SHORT_MAX_VALUE);
                break;
            }
            case USHORT_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case USHORT_GET_MAX_VALUE: {
                this.javaWriter.constant(65535);
                break;
            }
            case INT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(INTEGER_MIN_VALUE);
                break;
            }
            case INT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(INTEGER_MAX_VALUE);
                break;
            }
            case UINT_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case UINT_GET_MAX_VALUE: {
                this.javaWriter.constant(-1);
                break;
            }
            case LONG_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(LONG_MIN_VALUE);
                break;
            }
            case LONG_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(LONG_MAX_VALUE);
                break;
            }
            case ULONG_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case ULONG_GET_MAX_VALUE: {
                this.javaWriter.constant(-1L);
                break;
            }
            case USIZE_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case USIZE_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(INTEGER_MAX_VALUE);
                break;
            }
            case USIZE_BITS: {
                this.javaWriter.constant(32);
                break;
            }
            case FLOAT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(FLOAT_MIN_VALUE);
                break;
            }
            case FLOAT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(FLOAT_MAX_VALUE);
                break;
            }
            case DOUBLE_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(DOUBLE_MIN_VALUE);
                break;
            }
            case DOUBLE_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(DOUBLE_MAX_VALUE);
                break;
            }
            case CHAR_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(CHARACTER_MIN_VALUE);
                break;
            }
            case CHAR_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(CHARACTER_MAX_VALUE);
                break;
            }
            case ENUM_VALUES: {
                DefinitionTypeID type = (DefinitionTypeID)expression.type.type;
                JavaClass cls = this.context.getJavaClass(type.definition);
                this.javaWriter.invokeStatic(JavaMethod.getNativeStatic(cls, "values", "()[L" + cls.internalName + ";"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown builtin: " + (Object)((Object)builtin));
            }
        }
        return null;
    }

    @Override
    public Void visitConstantBool(ConstantBoolExpression expression) {
        if (expression.value) {
            this.javaWriter.iConst1();
        } else {
            this.javaWriter.iConst0();
        }
        return null;
    }

    @Override
    public Void visitConstantByte(ConstantByteExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantChar(ConstantCharExpression expression) {
        this.getJavaWriter().constant(Character.valueOf(expression.value));
        return null;
    }

    @Override
    public Void visitConstantDouble(ConstantDoubleExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantFloat(ConstantFloatExpression expression) {
        this.getJavaWriter().constant(Float.valueOf(expression.value));
        return null;
    }

    @Override
    public Void visitConstantInt(ConstantIntExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantLong(ConstantLongExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantSByte(ConstantSByteExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantShort(ConstantShortExpression expression) {
        this.getJavaWriter().siPush(expression.value);
        return null;
    }

    @Override
    public Void visitConstantString(ConstantStringExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantUInt(ConstantUIntExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantULong(ConstantULongExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantUShort(ConstantUShortExpression expression) {
        this.getJavaWriter().constant(expression.value);
        return null;
    }

    @Override
    public Void visitConstantUSize(ConstantUSizeExpression expression) {
        this.getJavaWriter().constant((int)expression.value);
        return null;
    }

    @Override
    public Void visitConstructorThisCall(ConstructorThisCallExpression expression) {
        this.javaWriter.loadObject(0);
        if (this.javaWriter.method.cls.isEnum()) {
            this.javaWriter.loadObject(1);
            this.javaWriter.loadInt(2);
        }
        for (Expression argument : expression.arguments.arguments) {
            argument.accept(this);
        }
        String internalName = this.context.getInternalName(expression.objectType);
        this.javaWriter.invokeSpecial(internalName, "<init>", this.javaWriter.method.cls.isEnum() ? this.context.getEnumConstructorDescriptor(expression.constructor.getHeader()) : this.context.getMethodDescriptor(expression.constructor.getHeader()));
        return null;
    }

    @Override
    public Void visitConstructorSuperCall(ConstructorSuperCallExpression expression) {
        this.javaWriter.loadObject(0);
        for (Expression argument : expression.arguments.arguments) {
            argument.accept(this);
        }
        this.javaWriter.invokeSpecial(this.context.getInternalName(expression.objectType), "<init>", this.context.getMethodDescriptor(expression.constructor.getHeader()));
        CompilerUtils.writeDefaultFieldInitializers(this.context, this.javaWriter, this.javaWriter.forDefinition, false);
        return null;
    }

    @Override
    public Void visitEnumConstant(EnumConstantExpression expression) {
        this.javaWriter.getStaticField(this.context.getInternalName(expression.type), expression.value.name, this.context.getDescriptor(expression.type));
        return null;
    }

    @Override
    public Void visitFunction(final FunctionExpression expression) {
        CompilerUtils.tagMethodParameters(this.context, this.module, expression.header, false);
        String descriptor = this.context.getMethodDescriptor(expression.header);
        String signature = this.context.getMethodSignature(expression.header);
        String signature2 = this.context.getMethodDescriptor(expression.header);
        final String name = this.context.getLambdaCounter();
        JavaMethod methodInfo = JavaMethod.getNativeVirtual(this.javaWriter.method.cls, "accept", descriptor);
        JavaClassWriter lambdaCW = new JavaClassWriter(2);
        lambdaCW.visit(52, 1, name, null, "java/lang/Object", new String[]{this.context.getInternalName(new FunctionTypeID(null, expression.header).stored(UniqueStorageTag.INSTANCE))});
        final JavaWriter functionWriter = new JavaWriter((ClassVisitor)lambdaCW, methodInfo, null, signature, null, "java/lang/Override");
        this.javaWriter.newObject(name);
        this.javaWriter.dup();
        String constructorDesc = this.calcFunctionSignature(expression.closure);
        JavaWriter constructorWriter = new JavaWriter((ClassVisitor)lambdaCW, JavaMethod.getConstructor(this.javaWriter.method.cls, constructorDesc, 1), null, null, null, new String[0]);
        constructorWriter.start();
        constructorWriter.loadObject(0);
        constructorWriter.dup();
        constructorWriter.invokeSpecial(Object.class, "<init>", "()V");
        int i = 0;
        for (CapturedExpression capture : expression.closure.captures) {
            constructorWriter.dup();
            Type type = this.context.getType(capture.type);
            lambdaCW.visitField(18, "captured" + ++i, type.getDescriptor(), null, null).visitEnd();
            ((Expression)capture).accept(this);
            constructorWriter.load(type, i);
            constructorWriter.putField(name, "captured" + i, type.getDescriptor());
        }
        constructorWriter.pop();
        this.javaWriter.invokeSpecial(name, "<init>", constructorDesc);
        constructorWriter.ret();
        constructorWriter.end();
        functionWriter.start();
        JavaStatementVisitor CSV = new JavaStatementVisitor(this.context, new JavaExpressionVisitor(this.context, this.module, functionWriter){

            @Override
            public Void visitGetLocalVariable(GetLocalVariableExpression varExpression) {
                int position = JavaExpressionVisitor.calculateMemberPosition(varExpression, expression);
                functionWriter.loadObject(0);
                functionWriter.getField(name, "captured" + position, JavaExpressionVisitor.this.context.getDescriptor(varExpression.variable.type));
                return null;
            }

            @Override
            public Void visitCapturedParameter(CapturedParameterExpression varExpression) {
                int position = JavaExpressionVisitor.calculateMemberPosition(varExpression, expression);
                functionWriter.loadObject(0);
                functionWriter.getField(name, "captured" + position, JavaExpressionVisitor.this.context.getDescriptor(varExpression.parameter.type));
                return null;
            }
        });
        expression.body.accept(CSV);
        functionWriter.ret();
        functionWriter.end();
        lambdaCW.visitEnd();
        this.context.register(name, lambdaCW.toByteArray());
        try (FileOutputStream out = new FileOutputStream(name + ".class");){
            out.write(lambdaCW.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int calculateMemberPosition(GetLocalVariableExpression localVariableExpression, FunctionExpression expression) {
        int h = 1;
        for (CapturedExpression capture : expression.closure.captures) {
            if (capture instanceof CapturedLocalVariableExpression && ((CapturedLocalVariableExpression)capture).variable == localVariableExpression.variable) {
                return h;
            }
            if (capture instanceof CapturedClosureExpression && ((CapturedClosureExpression)capture).value instanceof CapturedLocalVariableExpression && ((CapturedLocalVariableExpression)((CapturedClosureExpression)capture).value).variable == localVariableExpression.variable) {
                return h;
            }
            ++h;
        }
        throw new RuntimeException(localVariableExpression.position.toString() + ": Captured Statement error");
    }

    private static int calculateMemberPosition(CapturedParameterExpression functionParameterExpression, FunctionExpression expression) {
        int h = 1;
        for (CapturedExpression capture : expression.closure.captures) {
            if (capture instanceof CapturedParameterExpression && ((CapturedParameterExpression)capture).parameter == functionParameterExpression.parameter) {
                return h;
            }
            ++h;
        }
        throw new RuntimeException(functionParameterExpression.position.toString() + ": Captured Statement error");
    }

    private String calcFunctionSignature(LambdaClosure closure) {
        StringJoiner joiner = new StringJoiner("", "(", ")V");
        for (CapturedExpression capture : closure.captures) {
            String descriptor = this.context.getDescriptor(capture.type);
            joiner.add(descriptor);
        }
        return joiner.toString();
    }

    @Override
    public Void visitGetField(GetFieldExpression expression) {
        expression.accept(this);
        this.getField(expression.field);
        return null;
    }

    @Override
    public Void visitGetFunctionParameter(GetFunctionParameterExpression expression) {
        JavaParameterInfo parameter = this.module.getParameterInfo(expression.parameter);
        if (parameter == null) {
            throw new RuntimeException(expression.position.toString() + ": Could not resolve lambda parameter" + expression.parameter);
        }
        this.javaWriter.load(this.context.getType(expression.parameter.type), parameter.index);
        return null;
    }

    @Override
    public Void visitGetLocalVariable(GetLocalVariableExpression expression) {
        Label label = new Label();
        JavaLocalVariableInfo tag = this.javaWriter.getLocalVariable(expression.variable.variable);
        tag.end = label;
        this.javaWriter.load(tag.type, tag.local);
        this.javaWriter.label(label);
        return null;
    }

    @Override
    public Void visitGetMatchingVariantField(GetMatchingVariantField expression) {
        this.javaWriter.loadObject(0);
        StoredType type = expression.value.option.getParameterType(expression.index);
        JavaVariantOption tag = this.context.getJavaVariantOption(expression.value.option);
        this.javaWriter.checkCast(tag.variantOptionClass.internalName);
        this.javaWriter.getField(new JavaField(tag.variantOptionClass, "field" + expression.index, this.context.getDescriptor(type)));
        return null;
    }

    @Override
    public Void visitGetStaticField(GetStaticFieldExpression expression) {
        this.javaWriter.getStaticField(this.context.getJavaField(expression.field));
        return null;
    }

    @Override
    public Void visitGetter(GetterExpression expression) {
        expression.target.accept(this);
        BuiltinID builtin = expression.getter.member.builtin;
        if (builtin == null) {
            if (this.context.hasJavaField(expression.getter)) {
                this.javaWriter.getField(this.context.getJavaField(expression.getter));
                return null;
            }
            if (!this.checkAndExecuteMethodInfo(expression.getter, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            return null;
        }
        block0 : switch (builtin) {
            case INT_HIGHEST_ONE_BIT: 
            case UINT_HIGHEST_ONE_BIT: 
            case USIZE_HIGHEST_ONE_BIT: {
                this.javaWriter.invokeStatic(INTEGER_HIGHEST_ONE_BIT);
                break;
            }
            case INT_LOWEST_ONE_BIT: 
            case UINT_LOWEST_ONE_BIT: 
            case USIZE_LOWEST_ONE_BIT: {
                this.javaWriter.invokeStatic(INTEGER_LOWEST_ONE_BIT);
                break;
            }
            case INT_HIGHEST_ZERO_BIT: 
            case UINT_HIGHEST_ZERO_BIT: 
            case USIZE_HIGHEST_ZERO_BIT: {
                this.javaWriter.iNeg();
                this.javaWriter.invokeStatic(INTEGER_HIGHEST_ONE_BIT);
                break;
            }
            case INT_LOWEST_ZERO_BIT: 
            case UINT_LOWEST_ZERO_BIT: 
            case USIZE_LOWEST_ZERO_BIT: {
                this.javaWriter.iNeg();
                this.javaWriter.invokeStatic(INTEGER_LOWEST_ONE_BIT);
                break;
            }
            case INT_BIT_COUNT: 
            case UINT_BIT_COUNT: 
            case USIZE_BIT_COUNT: {
                this.javaWriter.invokeStatic(INTEGER_BIT_COUNT);
                break;
            }
            case LONG_HIGHEST_ONE_BIT: 
            case ULONG_HIGHEST_ONE_BIT: {
                this.javaWriter.invokeStatic(LONG_HIGHEST_ONE_BIT);
                break;
            }
            case LONG_LOWEST_ONE_BIT: 
            case ULONG_LOWEST_ONE_BIT: {
                this.javaWriter.invokeStatic(LONG_LOWEST_ONE_BIT);
                break;
            }
            case LONG_HIGHEST_ZERO_BIT: 
            case ULONG_HIGHEST_ZERO_BIT: {
                this.javaWriter.lNeg();
                this.javaWriter.invokeStatic(LONG_HIGHEST_ONE_BIT);
                break;
            }
            case LONG_LOWEST_ZERO_BIT: 
            case ULONG_LOWEST_ZERO_BIT: {
                this.javaWriter.lNeg();
                this.javaWriter.invokeStatic(LONG_LOWEST_ONE_BIT);
                break;
            }
            case LONG_BIT_COUNT: 
            case ULONG_BIT_COUNT: {
                this.javaWriter.invokeStatic(LONG_BIT_COUNT);
                break;
            }
            case FLOAT_BITS: {
                this.javaWriter.invokeStatic(FLOAT_BITS);
                break;
            }
            case DOUBLE_BITS: {
                this.javaWriter.invokeStatic(DOUBLE_BITS);
                break;
            }
            case STRING_LENGTH: {
                this.javaWriter.invokeVirtual(STRING_LENGTH);
                break;
            }
            case STRING_CHARACTERS: {
                this.javaWriter.invokeVirtual(STRING_CHARACTERS);
                break;
            }
            case STRING_ISEMPTY: {
                this.javaWriter.invokeVirtual(STRING_ISEMPTY);
                break;
            }
            case ASSOC_SIZE: {
                this.javaWriter.invokeVirtual(MAP_SIZE);
                break;
            }
            case ASSOC_ISEMPTY: {
                this.javaWriter.invokeVirtual(MAP_ISEMPTY);
                break;
            }
            case ASSOC_KEYS: {
                Type resultType = this.context.getType(expression.type);
                this.javaWriter.invokeVirtual(MAP_KEYS);
                this.javaWriter.dup();
                this.javaWriter.invokeVirtual(COLLECTION_SIZE);
                this.javaWriter.newArray(resultType);
                this.javaWriter.invokeVirtual(COLLECTION_TOARRAY);
                this.javaWriter.checkCast(resultType);
                break;
            }
            case ASSOC_VALUES: {
                Type resultType = this.context.getType(expression.type);
                this.javaWriter.invokeVirtual(MAP_VALUES);
                this.javaWriter.dup();
                this.javaWriter.invokeVirtual(COLLECTION_SIZE);
                this.javaWriter.newArray(resultType);
                this.javaWriter.invokeVirtual(COLLECTION_TOARRAY);
                this.javaWriter.checkCast(resultType);
                break;
            }
            case ASSOC_HASHCODE: {
                this.javaWriter.invokeVirtual(OBJECT_HASHCODE);
                break;
            }
            case GENERICMAP_HASHCODE: {
                this.javaWriter.invokeVirtual(OBJECT_HASHCODE);
                break;
            }
            case ARRAY_LENGTH: {
                this.javaWriter.arrayLength();
                break;
            }
            case ARRAY_HASHCODE: {
                ArrayTypeID type = (ArrayTypeID)expression.target.type.type;
                if (type.elementType.type instanceof BasicTypeID) {
                    switch ((BasicTypeID)type.elementType.type) {
                        case BOOL: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_BOOLS);
                            break block0;
                        }
                        case BYTE: 
                        case SBYTE: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_BYTES);
                            break block0;
                        }
                        case SHORT: 
                        case USHORT: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_SHORTS);
                            break block0;
                        }
                        case INT: 
                        case UINT: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_INTS);
                            break block0;
                        }
                        case LONG: 
                        case ULONG: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_LONGS);
                            break block0;
                        }
                        case FLOAT: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_FLOATS);
                            break block0;
                        }
                        case DOUBLE: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_DOUBLES);
                            break block0;
                        }
                        case CHAR: {
                            this.javaWriter.invokeStatic(ARRAYS_HASHCODE_CHARS);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unknown basic type: " + type.elementType);
                }
                this.javaWriter.invokeStatic(ARRAYS_DEEPHASHCODE);
                break;
            }
            case ARRAY_ISEMPTY: {
                Label isTrue = new Label();
                Label exit = new Label();
                this.javaWriter.arrayLength();
                this.javaWriter.ifEQ(isTrue);
                this.javaWriter.iConst0();
                this.javaWriter.goTo(exit);
                this.javaWriter.label(isTrue);
                this.javaWriter.iConst1();
                this.javaWriter.label(exit);
                break;
            }
            case ENUM_NAME: {
                this.javaWriter.invokeVirtual(ENUM_NAME);
                break;
            }
            case ENUM_ORDINAL: {
                this.javaWriter.invokeVirtual(ENUM_ORDINAL);
                break;
            }
            case OBJECT_HASHCODE: {
                this.javaWriter.invokeVirtual(OBJECT_HASHCODE);
                break;
            }
            case RANGE_FROM: {
                RangeTypeID type = (RangeTypeID)expression.target.type.type;
                Type jType = this.context.getType(expression.target.type);
                this.javaWriter.getField(jType.getInternalName(), "from", this.context.getDescriptor(type.baseType));
                break;
            }
            case RANGE_TO: {
                RangeTypeID type = (RangeTypeID)expression.target.type.type;
                Type jType = this.context.getType(expression.target.type);
                this.javaWriter.getField(jType.getInternalName(), "to", this.context.getDescriptor(type.baseType));
            }
        }
        return null;
    }

    @Override
    public Void visitGlobal(GlobalExpression expression) {
        return expression.resolution.accept(this);
    }

    @Override
    public Void visitGlobalCall(GlobalCallExpression expression) {
        return expression.resolution.accept(this);
    }

    @Override
    public Void visitInterfaceCast(InterfaceCastExpression expression) {
        expression.value.accept(this);
        this.javaWriter.checkCast(this.context.getInternalName(expression.type));
        return null;
    }

    @Override
    public Void visitIs(IsExpression expression) {
        expression.value.accept(this);
        this.javaWriter.instanceOf(this.context.getInternalName(expression.isType.stored(BorrowStorageTag.INVOCATION)));
        return null;
    }

    @Override
    public Void visitMakeConst(MakeConstExpression expression) {
        return null;
    }

    @Override
    public Void visitMap(MapExpression expression) {
        this.javaWriter.newObject("java/util/HashMap");
        this.javaWriter.dup();
        this.javaWriter.invokeSpecial("java/util/HashMap", "<init>", "()V");
        for (int i = 0; i < expression.keys.length; ++i) {
            this.javaWriter.dup();
            expression.keys[i].accept(this);
            expression.values[i].accept(this);
            this.javaWriter.invokeInterface(MAP_PUT);
            this.javaWriter.pop();
        }
        return null;
    }

    @Override
    public Void visitMatch(MatchExpression expression) {
        Label start = new Label();
        Label end = new Label();
        this.javaWriter.label(start);
        expression.value.accept(this);
        if (expression.value.type.type instanceof StringTypeID) {
            this.javaWriter.invokeVirtual(OBJECT_HASHCODE);
        }
        for (MatchExpression.Case aCase : expression.cases) {
            if (!(aCase.key instanceof VariantOptionSwitchValue)) continue;
            VariantOptionSwitchValue variantOptionSwitchValue = (VariantOptionSwitchValue)aCase.key;
            MatchExpression.Case[] option = this.context.getJavaVariantOption(variantOptionSwitchValue.option);
            this.javaWriter.invokeVirtual(JavaMethod.getNativeVirtual(option.variantClass, "getDenominator", "()I"));
            break;
        }
        boolean hasNoDefault = JavaExpressionVisitor.hasNoDefault(expression);
        MatchExpression.Case[] cases = expression.cases;
        JavaSwitchLabel[] switchLabels = new JavaSwitchLabel[hasNoDefault ? cases.length : cases.length - 1];
        Label defaultLabel = new Label();
        int i = 0;
        for (MatchExpression.Case matchCase : cases) {
            if (matchCase.key == null) continue;
            switchLabels[i++] = new JavaSwitchLabel(CompilerUtils.getKeyForSwitch(matchCase.key), new Label());
        }
        JavaSwitchLabel[] sortedSwitchLabels = Arrays.copyOf(switchLabels, switchLabels.length);
        Arrays.sort(sortedSwitchLabels, Comparator.comparingInt(a -> a.key));
        this.javaWriter.lookupSwitch(defaultLabel, sortedSwitchLabels);
        i = 0;
        for (MatchExpression.Case switchCase : cases) {
            if (hasNoDefault || switchCase.key != null) {
                this.javaWriter.label(switchLabels[i++].label);
            } else {
                this.javaWriter.label(defaultLabel);
            }
            switchCase.value.accept(this);
            this.javaWriter.goTo(end);
        }
        if (hasNoDefault) {
            this.javaWriter.label(defaultLabel);
            if (this.context.getType(expression.type).getOpcode(54) == 58) {
                this.javaWriter.aConstNull();
            } else {
                this.javaWriter.iConst0();
            }
        }
        this.javaWriter.label(end);
        return null;
    }

    private static boolean hasNoDefault(MatchExpression switchStatement) {
        for (MatchExpression.Case switchCase : switchStatement.cases) {
            if (switchCase.key != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Void visitNew(NewExpression expression) {
        JavaMethod method = this.context.getJavaMethod(expression.constructor);
        this.javaWriter.newObject(method.cls.internalName);
        this.javaWriter.dup();
        for (Expression argument : expression.arguments.arguments) {
            argument.accept(this);
        }
        this.javaWriter.invokeSpecial(method);
        return null;
    }

    @Override
    public Void visitNull(NullExpression expression) {
        if (!expression.type.isBasic(BasicTypeID.NULL) && expression.type.type.withoutOptional() == BasicTypeID.USIZE) {
            this.javaWriter.constant(-1);
        } else {
            this.javaWriter.aConstNull();
        }
        return null;
    }

    @Override
    public Void visitOrOr(OrOrExpression expression) {
        Label end = new Label();
        Label onTrue = new Label();
        expression.left.accept(this);
        this.javaWriter.ifNE(onTrue);
        expression.right.accept(this);
        this.javaWriter.goTo(end);
        this.javaWriter.label(onTrue);
        this.javaWriter.iConst1();
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitPanic(PanicExpression expression) {
        this.javaWriter.newObject("java/lang/AssertionError");
        this.javaWriter.dup();
        expression.value.accept(this);
        this.javaWriter.invokeSpecial(AssertionError.class, "<init>", "(Ljava/lang/String;)V");
        this.javaWriter.aThrow();
        return null;
    }

    @Override
    public Void visitPostCall(PostCallExpression expression) {
        expression.target.accept(this);
        this.javaWriter.dup(this.context.getType(expression.type));
        if (!this.checkAndExecuteMethodInfo(expression.member, expression.type)) {
            throw new IllegalStateException("Call target has no method info!");
        }
        return null;
    }

    @Override
    public Void visitRange(RangeExpression expression) {
        RangeTypeID type = (RangeTypeID)expression.type.type;
        Type cls = this.context.getType(expression.type);
        this.javaWriter.newObject(cls.getInternalName());
        this.javaWriter.dup();
        expression.from.accept(this);
        expression.to.accept(this);
        this.javaWriter.invokeSpecial(cls.getInternalName(), "<init>", "(" + this.context.getDescriptor(type.baseType) + this.context.getDescriptor(type.baseType) + ")V");
        return null;
    }

    @Override
    public Void visitSameObject(SameObjectExpression expression) {
        expression.left.accept(this);
        expression.right.accept(this);
        Label end = new Label();
        Label equal = new Label();
        if (expression.inverted) {
            this.javaWriter.ifACmpNe(equal);
        } else {
            this.javaWriter.ifACmpEq(equal);
        }
        this.javaWriter.iConst0();
        this.javaWriter.goTo(end);
        this.javaWriter.label(equal);
        this.javaWriter.iConst1();
        this.javaWriter.label(end);
        return null;
    }

    @Override
    public Void visitSetField(SetFieldExpression expression) {
        expression.target.accept(this);
        expression.value.accept(this);
        this.putField(expression.field);
        return null;
    }

    @Override
    public Void visitSetFunctionParameter(SetFunctionParameterExpression expression) {
        expression.value.accept(this);
        JavaParameterInfo parameter = this.module.getParameterInfo(expression.parameter);
        this.javaWriter.store(this.context.getType(expression.type), parameter.index);
        return null;
    }

    @Override
    public Void visitSetLocalVariable(SetLocalVariableExpression expression) {
        expression.value.accept(this);
        Label label = new Label();
        this.javaWriter.label(label);
        JavaLocalVariableInfo tag = this.javaWriter.getLocalVariable(expression.variable.variable);
        tag.end = label;
        this.javaWriter.store(tag.type, tag.local);
        return null;
    }

    @Override
    public Void visitSetStaticField(SetStaticFieldExpression expression) {
        expression.value.accept(this);
        this.javaWriter.putStaticField(this.context.getJavaField(expression.field));
        return null;
    }

    @Override
    public Void visitSetter(SetterExpression expression) {
        return null;
    }

    @Override
    public Void visitStaticGetter(StaticGetterExpression expression) {
        BuiltinID builtin = expression.getter.member.builtin;
        if (builtin == null) {
            if (this.context.hasJavaField(expression.getter)) {
                this.javaWriter.getStaticField(this.context.getJavaField(expression.getter));
                return null;
            }
            if (!this.checkAndExecuteMethodInfo(expression.getter, expression.type)) {
                throw new IllegalStateException("Call target has no method info!");
            }
            return null;
        }
        switch (builtin) {
            case BYTE_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case BYTE_GET_MAX_VALUE: {
                this.javaWriter.constant(255);
                break;
            }
            case SBYTE_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(BYTE_MIN_VALUE);
                break;
            }
            case SBYTE_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(BYTE_MAX_VALUE);
                break;
            }
            case SHORT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(SHORT_MIN_VALUE);
                break;
            }
            case SHORT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(SHORT_MAX_VALUE);
                break;
            }
            case USHORT_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case USHORT_GET_MAX_VALUE: {
                this.javaWriter.constant(65535);
                break;
            }
            case INT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(INTEGER_MIN_VALUE);
                break;
            }
            case INT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(INTEGER_MAX_VALUE);
                break;
            }
            case UINT_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case UINT_GET_MAX_VALUE: {
                this.javaWriter.constant(-1);
                break;
            }
            case LONG_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(LONG_MIN_VALUE);
                break;
            }
            case LONG_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(LONG_MAX_VALUE);
                break;
            }
            case ULONG_GET_MIN_VALUE: {
                this.javaWriter.iConst0();
                break;
            }
            case ULONG_GET_MAX_VALUE: {
                this.javaWriter.constant(-1L);
                break;
            }
            case FLOAT_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(FLOAT_MIN_VALUE);
                break;
            }
            case FLOAT_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(FLOAT_MAX_VALUE);
                break;
            }
            case DOUBLE_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(DOUBLE_MIN_VALUE);
                break;
            }
            case DOUBLE_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(DOUBLE_MAX_VALUE);
                break;
            }
            case CHAR_GET_MIN_VALUE: {
                this.javaWriter.getStaticField(CHARACTER_MIN_VALUE);
                break;
            }
            case CHAR_GET_MAX_VALUE: {
                this.javaWriter.getStaticField(CHARACTER_MAX_VALUE);
                break;
            }
            case ENUM_VALUES: {
                DefinitionTypeID type = (DefinitionTypeID)expression.type.type;
                JavaClass cls = this.context.getJavaClass(type.definition);
                this.javaWriter.invokeStatic(JavaMethod.getNativeStatic(cls, "values", "()[L" + cls.internalName + ";"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown builtin: " + (Object)((Object)builtin));
            }
        }
        throw new UnsupportedOperationException("Unknown builtin: " + (Object)((Object)builtin));
    }

    @Override
    public Void visitStaticSetter(StaticSetterExpression expression) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Void visitStorageCast(StorageCastExpression expression) {
        expression.value.accept(this);
        if (expression.type.isDestructible()) {
            StorageTag fromTag = expression.value.type.getActualStorage();
            StorageTag toTag = expression.type.getActualStorage();
            if (JavaTypeUtils.isShared(fromTag) && toTag == BorrowStorageTag.INVOCATION) {
                this.javaWriter.invokeVirtual(SHARED_GET);
            } else if (fromTag == UniqueStorageTag.INSTANCE && JavaTypeUtils.isShared(toTag)) {
                this.javaWriter.newObject("zsynthetic/Shared");
                this.javaWriter.dup();
                this.javaWriter.invokeSpecial(SHARED_INIT);
            }
        }
        return null;
    }

    @Override
    public Void visitSupertypeCast(SupertypeCastExpression expression) {
        return null;
    }

    @Override
    public Void visitThis(ThisExpression expression) {
        this.javaWriter.loadObject(0);
        return null;
    }

    @Override
    public Void visitThrow(ThrowExpression expression) {
        expression.value.accept(this);
        this.javaWriter.aThrow();
        return null;
    }

    @Override
    public Void visitTryConvert(TryConvertExpression expression) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visitTryRethrowAsException(TryRethrowAsExceptionExpression expression) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visitTryRethrowAsResult(TryRethrowAsResultExpression expression) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visitVariantValue(VariantValueExpression expression) {
        JavaVariantOption tag = this.context.getJavaVariantOption(expression.option);
        String internalName = tag.variantOptionClass.internalName;
        this.javaWriter.newObject(internalName);
        this.javaWriter.dup();
        for (Expression argument : expression.arguments) {
            argument.accept(this);
        }
        StringBuilder builder = new StringBuilder("(");
        for (StoredType type : expression.option.getOption().types) {
            builder.append(this.context.getDescriptor(type));
        }
        builder.append(")V");
        this.javaWriter.invokeSpecial(internalName, "<init>", builder.toString());
        return null;
    }

    @Override
    public Void visitWrapOptional(WrapOptionalExpression expression) {
        expression.value.accept(this);
        expression.value.type.type.accept(expression.value.type, new JavaBoxingTypeVisitor(this.javaWriter));
        return null;
    }

    public JavaWriter getJavaWriter() {
        return this.javaWriter;
    }

    private boolean checkAndExecuteMethodInfo(DefinitionMemberRef member, StoredType resultType) {
        JavaMethod methodInfo = this.context.getJavaMethod(member);
        if (methodInfo == null) {
            return false;
        }
        if (methodInfo.kind == JavaMethod.Kind.STATIC) {
            this.getJavaWriter().invokeStatic(methodInfo);
        } else {
            this.getJavaWriter().invokeVirtual(methodInfo);
        }
        if (methodInfo.genericResult) {
            this.getJavaWriter().checkCast(this.context.getInternalName(resultType));
        }
        return true;
    }

    public void putField(FieldMemberRef field) {
        JavaField fieldInfo = this.context.getJavaField(field);
        if (field.isStatic()) {
            this.getJavaWriter().putStaticField(fieldInfo);
        } else {
            this.getJavaWriter().putField(fieldInfo);
        }
    }

    public void getField(FieldMemberRef field) {
        JavaField fieldInfo = this.context.getJavaField(field);
        if (field.isStatic()) {
            this.getJavaWriter().getStaticField(fieldInfo);
        } else {
            this.getJavaWriter().getField(fieldInfo);
        }
    }
}

