/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler.definitions;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.member.CallerMember;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.DestructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.InnerDefinitionMember;
import org.openzen.zenscript.codemodel.member.IteratorMember;
import org.openzen.zenscript.codemodel.member.MemberVisitor;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.member.StaticInitializerMember;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.CompilerUtils;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaExpansionMemberVisitor
implements MemberVisitor<Void> {
    private final ClassWriter writer;
    private final JavaBytecodeContext context;
    private final JavaClass toClass;
    private final HighLevelDefinition definition;
    private final JavaCompiledModule javaModule;

    public JavaExpansionMemberVisitor(JavaBytecodeContext context, ClassWriter writer, JavaClass toClass, HighLevelDefinition definition) {
        this.writer = writer;
        this.toClass = toClass;
        this.definition = definition;
        this.context = context;
        this.javaModule = context.getJavaModule(definition.module);
    }

    public void end() {
    }

    @Override
    public Void visitConst(ConstMember member) {
        JavaField field = this.context.getJavaField(member);
        this.writer.visitField(CompilerUtils.calcAccess(member.getEffectiveModifiers()), field.name, field.descriptor, field.signature, null).visitEnd();
        return null;
    }

    @Override
    public Void visitField(FieldMember member) {
        throw new IllegalStateException("Cannot add fields via expansions");
    }

    @Override
    public Void visitConstructor(ConstructorMember member) {
        throw new IllegalStateException("Cannot add constructors via expansions");
    }

    @Override
    public Void visitDestructor(DestructorMember member) {
        throw new IllegalStateException("Cannot add constructors via expansions");
    }

    @Override
    public Void visitMethod(MethodMember member) {
        boolean isStatic = member.isStatic();
        JavaMethod method = this.context.getJavaMethod(member);
        if (!method.compile) {
            return null;
        }
        CompilerUtils.tagMethodParameters(this.context, this.javaModule, member.header, member.isStatic());
        Label methodStart = new Label();
        Label methodEnd = new Label();
        JavaWriter methodWriter = new JavaWriter((ClassVisitor)this.writer, method, this.definition, this.context.getMethodSignature(member.header), null, new String[0]);
        return null;
    }

    @Override
    public Void visitGetter(GetterMember member) {
        throw new IllegalStateException("Cannot add getters via expansions");
    }

    @Override
    public Void visitSetter(SetterMember member) {
        throw new IllegalStateException("Cannot add setters via expansions");
    }

    @Override
    public Void visitOperator(OperatorMember member) {
        return null;
    }

    @Override
    public Void visitCaster(CasterMember member) {
        return null;
    }

    @Override
    public Void visitCustomIterator(IteratorMember member) {
        return null;
    }

    @Override
    public Void visitCaller(CallerMember member) {
        return null;
    }

    @Override
    public Void visitImplementation(ImplementationMember member) {
        return null;
    }

    @Override
    public Void visitInnerDefinition(InnerDefinitionMember member) {
        return null;
    }

    @Override
    public Void visitStaticInitializer(StaticInitializerMember member) {
        throw new IllegalStateException("Cannot add Static initializers via expansions");
    }
}

