/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.type;

import java.util.ArrayList;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;

public class ParsedStorageTag {
    public static final ParsedStorageTag NULL = new ParsedStorageTag("", null);
    public String name;
    public String[] arguments;

    public static ParsedStorageTag parse(ZSTokenParser parser) throws ParseException {
        if (parser.optional(ZSTokenType.T_BACKTICK) == null) {
            return NULL;
        }
        String name = ((ZSToken)parser.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
        ArrayList<String> arguments = new ArrayList<String>();
        while (parser.optional(ZSTokenType.T_COLON) != null) {
            arguments.add(((ZSToken)parser.next()).content);
        }
        return new ParsedStorageTag(name, arguments.toArray(new String[arguments.size()]));
    }

    public ParsedStorageTag(String name, String[] arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public StorageTag resolve(CodePosition position, TypeResolutionContext context) {
        if (this == NULL) {
            return null;
        }
        return context.getStorageTag(position, this.name, this.arguments);
    }
}

