/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Modifiers;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.JavaExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaSwitchKeyVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaParameterInfo;

public class CompilerUtils {
    private CompilerUtils() {
    }

    public static boolean isPrimitive(TypeID id) {
        return id instanceof BasicTypeID || id.isOptional() && id.withoutOptional() == BasicTypeID.USIZE;
    }

    public static boolean isLarge(StoredType type) {
        return type.type == BasicTypeID.DOUBLE || type.type == BasicTypeID.DOUBLE;
    }

    public static int calcAccess(int modifiers) {
        int out = 0;
        if (Modifiers.isStatic(modifiers)) {
            out |= 8;
        }
        if (Modifiers.isFinal(modifiers)) {
            out |= 0x10;
        }
        if (Modifiers.isPublic(modifiers)) {
            out |= 1;
        }
        if (Modifiers.isPrivate(modifiers)) {
            out |= 2;
        }
        if (Modifiers.isProtected(modifiers)) {
            out |= 4;
        }
        if (Modifiers.isAbstract(modifiers)) {
            out |= 0x400;
        }
        return out;
    }

    public static void tagMethodParameters(JavaBytecodeContext context, JavaCompiledModule module, FunctionHeader header, boolean isStatic) {
        for (int i = 0; i < header.parameters.length; ++i) {
            FunctionParameter parameter = header.parameters[i];
            String parameterType = context.getDescriptor(parameter.type);
            module.setParameterInfo(parameter, new JavaParameterInfo(isStatic ? i : i + 1, parameterType));
        }
    }

    public static void tagConstructorParameters(JavaBytecodeContext context, JavaCompiledModule module, FunctionHeader header, boolean isEnum) {
        for (int i = 0; i < header.parameters.length; ++i) {
            FunctionParameter parameter = header.parameters[i];
            String parameterType = context.getDescriptor(parameter.type);
            module.setParameterInfo(parameter, new JavaParameterInfo(isEnum ? i + 3 : i + 1, parameterType));
        }
    }

    public static void writeDefaultFieldInitializers(JavaBytecodeContext context, JavaWriter constructorWriter, HighLevelDefinition definition, boolean staticFields) {
        JavaExpressionVisitor expressionVisitor = new JavaExpressionVisitor(context, context.getJavaModule(definition.module), constructorWriter);
        for (IDefinitionMember definitionMember : definition.members) {
            FieldMember field;
            if (!(definitionMember instanceof FieldMember) || (field = (FieldMember)definitionMember).isStatic() != staticFields || field.initializer == null) continue;
            if (!staticFields) {
                constructorWriter.loadObject(0);
            }
            field.initializer.accept(expressionVisitor);
            if (staticFields) {
                constructorWriter.putStaticField(definition.name, field.name, context.getDescriptor(field.getType()));
                continue;
            }
            constructorWriter.putField(definition.name, field.name, context.getDescriptor(field.getType()));
        }
    }

    public static int getKeyForSwitch(SwitchValue expression) {
        return expression.accept(JavaSwitchKeyVisitor.INSTANCE);
    }
}

