/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaNativeTranslation;

public class JavaMethod {
    public final JavaClass cls;
    public final Kind kind;
    public final String name;
    public final boolean compile;
    public final JavaNativeTranslation translation;
    public final String descriptor;
    public final int modifiers;
    public final boolean genericResult;

    public static JavaMethod getConstructor(JavaClass cls, String descriptor, int modifiers) {
        return new JavaMethod(cls, Kind.CONSTRUCTOR, "<init>", true, descriptor, modifiers, false);
    }

    public static JavaMethod getNativeConstructor(JavaClass cls, String descriptor) {
        return new JavaMethod(cls, Kind.CONSTRUCTOR, "<init>", false, descriptor, 1, false);
    }

    public static JavaMethod getDestructor(JavaClass cls, int modifiers) {
        return new JavaMethod(cls, Kind.INSTANCE, "close", true, "()V", modifiers, false);
    }

    public static JavaMethod getStatic(JavaClass cls, String name, String descriptor, int modifiers) {
        return new JavaMethod(cls, Kind.STATIC, name, true, descriptor, modifiers | 8, false);
    }

    public static JavaMethod getNativeStatic(JavaClass cls, String name, String descriptor) {
        return new JavaMethod(cls, Kind.STATIC, name, false, descriptor, 9, false);
    }

    public static JavaMethod getVirtual(JavaClass cls, String name, String descriptor, int modifiers) {
        return new JavaMethod(cls, Kind.INSTANCE, name, true, descriptor, modifiers, false);
    }

    public static JavaMethod getNativeVirtual(JavaClass cls, String name, String descriptor) {
        return new JavaMethod(cls, Kind.INSTANCE, name, false, descriptor, 1, false);
    }

    public static JavaMethod getNativeExpansion(JavaClass cls, String name, String descriptor) {
        return new JavaMethod(cls, Kind.EXPANSION, name, false, descriptor, 9, false);
    }

    public JavaMethod(JavaClass cls, Kind kind, String name, boolean compile, String descriptor, int modifiers, boolean genericResult) {
        if (descriptor.contains("<")) {
            throw new IllegalArgumentException("Invalid descriptor!");
        }
        this.cls = cls;
        this.kind = kind;
        this.name = name;
        this.compile = compile;
        this.translation = null;
        this.descriptor = descriptor;
        this.modifiers = modifiers;
        this.genericResult = genericResult;
    }

    public JavaMethod(JavaNativeTranslation<?> translation) {
        this.cls = null;
        this.kind = Kind.COMPILED;
        this.name = null;
        this.compile = false;
        this.translation = translation;
        this.descriptor = "";
        this.modifiers = 0;
        this.genericResult = false;
    }

    public String getMapping(JavaClass definition) {
        if (this.cls == null) {
            return "!TODO";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append(this.descriptor);
        if (definition == null || !definition.internalName.equals(this.cls.internalName)) {
            result.append('@').append(this.cls.internalName);
        }
        return result.toString();
    }

    public static enum Kind {
        STATIC,
        STATICINIT,
        INSTANCE,
        EXPANSION,
        CONSTRUCTOR,
        COMPILED;

    }
}

