/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler.definitions;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.member.CallerMember;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.DestructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.InnerDefinitionMember;
import org.openzen.zenscript.codemodel.member.IteratorMember;
import org.openzen.zenscript.codemodel.member.MemberVisitor;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.member.StaticInitializerMember;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.CompilerUtils;
import org.openzen.zenscript.javabytecode.compiler.JavaStatementVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaExpansionMemberVisitor
implements MemberVisitor<Void> {
    private final ClassWriter writer;
    private final JavaBytecodeContext context;
    private final StoredType expandedClass;
    private final HighLevelDefinition definition;
    private final JavaCompiledModule javaModule;
    private final JavaStatementVisitor clinitStatementVisitor;

    public JavaExpansionMemberVisitor(JavaBytecodeContext context, ClassWriter writer, StoredType expandedClass, HighLevelDefinition definition) {
        this.writer = writer;
        this.expandedClass = expandedClass;
        this.definition = definition;
        this.context = context;
        this.javaModule = context.getJavaModule(definition.module);
        JavaWriter javaWriter = new JavaWriter(definition.position, (ClassVisitor)writer, new JavaMethod(context.getJavaClass(definition), JavaMethod.Kind.STATICINIT, "<clinit>", true, "()V", 0, false), definition, null, null, new String[0]);
        this.clinitStatementVisitor = new JavaStatementVisitor(context, this.javaModule, javaWriter);
        this.clinitStatementVisitor.start();
        CompilerUtils.writeDefaultFieldInitializers(context, javaWriter, definition, true);
    }

    public void end() {
        this.clinitStatementVisitor.end();
    }

    @Override
    public Void visitConst(ConstMember member) {
        JavaField field = this.context.getJavaField(member);
        this.writer.visitField(CompilerUtils.calcAccess(member.getEffectiveModifiers()), field.name, field.descriptor, field.signature, null).visitEnd();
        return null;
    }

    @Override
    public Void visitField(FieldMember member) {
        if (!member.isStatic()) {
            throw new IllegalStateException("Cannot add fields via expansions");
        }
        JavaField field = this.context.getJavaField(member);
        this.writer.visitField(CompilerUtils.calcAccess(member.getEffectiveModifiers()), field.name, field.descriptor, field.signature, null).visitEnd();
        return null;
    }

    @Override
    public Void visitConstructor(ConstructorMember member) {
        throw new IllegalStateException("Cannot add constructors via expansions");
    }

    @Override
    public Void visitDestructor(DestructorMember member) {
        throw new IllegalStateException("Cannot add constructors via expansions");
    }

    @Override
    public Void visitMethod(MethodMember member) {
        boolean isStatic = member.isStatic();
        JavaMethod method = this.context.getJavaMethod(member);
        if (!method.compile) {
            return null;
        }
        CompilerUtils.tagMethodParameters(this.context, this.javaModule, member.header, member.isStatic());
        String expandedClassDescriptor = this.context.getDescriptor(this.expandedClass);
        Label methodStart = new Label();
        Label methodEnd = new Label();
        String methodSignature = !isStatic ? "(" + expandedClassDescriptor + this.context.getMethodSignature(member.header).substring(1) : this.context.getMethodSignature(member.header);
        JavaWriter methodWriter = new JavaWriter(member.position, (ClassVisitor)this.writer, true, method, this.definition, true, methodSignature, methodSignature, null, new String[0]);
        methodWriter.label(methodStart);
        if (!isStatic) {
            methodWriter.nameVariable(0, "expandedObj", methodStart, methodEnd, Type.getType((String)expandedClassDescriptor));
            methodWriter.nameParameter(0, "expandedObj");
            for (FunctionParameter parameter : member.header.parameters) {
                methodWriter.nameParameter(0, parameter.name);
                methodWriter.nameVariable(this.javaModule.getParameterInfo((FunctionParameter)parameter).index, parameter.name, methodStart, methodEnd, this.context.getType(parameter.type));
            }
        } else {
            for (FunctionParameter parameter : member.header.parameters) {
                methodWriter.nameParameter(0, parameter.name);
                methodWriter.nameVariable(this.javaModule.getParameterInfo((FunctionParameter)parameter).index, parameter.name, methodStart, methodEnd, this.context.getType(parameter.type));
            }
        }
        JavaStatementVisitor statementVisitor = new JavaStatementVisitor(this.context, this.javaModule, methodWriter);
        statementVisitor.start();
        member.body.accept(statementVisitor);
        methodWriter.label(methodEnd);
        statementVisitor.end();
        return null;
    }

    @Override
    public Void visitGetter(GetterMember member) {
        return null;
    }

    @Override
    public Void visitSetter(SetterMember member) {
        return null;
    }

    @Override
    public Void visitOperator(OperatorMember member) {
        return null;
    }

    @Override
    public Void visitCaster(CasterMember member) {
        return null;
    }

    @Override
    public Void visitCustomIterator(IteratorMember member) {
        return null;
    }

    @Override
    public Void visitCaller(CallerMember member) {
        return null;
    }

    @Override
    public Void visitImplementation(ImplementationMember member) {
        return null;
    }

    @Override
    public Void visitInnerDefinition(InnerDefinitionMember member) {
        return null;
    }

    @Override
    public Void visitStaticInitializer(StaticInitializerMember member) {
        member.body.accept(this.clinitStatementVisitor);
        return null;
    }
}

