/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.definitions;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.VariantDefinition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.ParsedAnnotation;
import org.openzen.zenscript.parser.definitions.BaseParsedDefinition;
import org.openzen.zenscript.parser.definitions.ParsedTypeParameter;
import org.openzen.zenscript.parser.definitions.ParsedVariantOption;
import org.openzen.zenscript.parser.member.ParsedDefinitionMember;
import org.openzen.zenscript.parser.type.IParsedType;

public class ParsedVariant
extends BaseParsedDefinition {
    private final List<ParsedTypeParameter> typeParameters;
    private final List<ParsedVariantOption> variants = new ArrayList<ParsedVariantOption>();
    private final VariantDefinition compiled;

    public static ParsedVariant parseVariant(CompilingPackage pkg, CodePosition position, int modifiers, ParsedAnnotation[] annotations, ZSTokenParser tokens, HighLevelDefinition outerDefinition) throws ParseException {
        String name = ((ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
        List<ParsedTypeParameter> typeParameters = ParsedTypeParameter.parseAll(tokens);
        tokens.required(ZSTokenType.T_AOPEN, "{ expected");
        ParsedVariant result = new ParsedVariant(pkg, position, modifiers, annotations, name, typeParameters, outerDefinition);
        int ordinal = 0;
        while (!tokens.isNext(ZSTokenType.T_ACLOSE) && !tokens.isNext(ZSTokenType.T_SEMICOLON)) {
            CodePosition optionPosition = tokens.getPosition();
            String optionName = ((ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
            ArrayList<IParsedType> types = new ArrayList<IParsedType>();
            if (tokens.optional(ZSTokenType.T_BROPEN) != null) {
                types.add(IParsedType.parse(tokens));
                while (tokens.optional(ZSTokenType.T_COMMA) != null) {
                    types.add(IParsedType.parse(tokens));
                }
                tokens.required(ZSTokenType.T_BRCLOSE, ") expected");
            }
            result.addVariant(new ParsedVariantOption(optionPosition, optionName, ordinal++, types));
            if (tokens.optional(ZSTokenType.T_COMMA) != null) continue;
            break;
        }
        if (tokens.optional(ZSTokenType.T_SEMICOLON) != null) {
            try {
                while (tokens.optional(ZSTokenType.T_ACLOSE) == null) {
                    result.addMember(ParsedDefinitionMember.parse(tokens, result, null));
                }
            }
            catch (ParseException ex) {
                tokens.logError(ex);
                tokens.recoverUntilToken(ZSTokenType.T_ACLOSE);
            }
        } else {
            tokens.required(ZSTokenType.T_ACLOSE, "} expected");
        }
        return result;
    }

    public ParsedVariant(CompilingPackage pkg, CodePosition position, int modifiers, ParsedAnnotation[] annotations, String name, List<ParsedTypeParameter> typeParameters, HighLevelDefinition outerDefinition) {
        super(position, modifiers, pkg, annotations);
        this.typeParameters = typeParameters;
        this.compiled = new VariantDefinition(position, pkg.module, pkg.getPackage(), name, modifiers, outerDefinition);
        this.compiled.setTypeParameters(ParsedTypeParameter.getCompiled(typeParameters));
    }

    public void addVariant(ParsedVariantOption value) {
        this.variants.add(value);
    }

    @Override
    public HighLevelDefinition getCompiled() {
        return this.compiled;
    }

    @Override
    public void linkTypesLocal(TypeResolutionContext context) {
        ParsedTypeParameter.compile(context, this.compiled.typeParameters, this.typeParameters);
        for (ParsedVariantOption variant : this.variants) {
            this.compiled.options.add(variant.compile(this.compiled, context));
        }
        super.linkTypesLocal(context);
    }
}

