/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.ModuleSpace;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.PackageDefinitions;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.definition.ClassDefinition;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.InterfaceDefinition;
import org.openzen.zenscript.codemodel.definition.StructDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.expression.ExpressionSymbol;
import org.openzen.zenscript.codemodel.expression.StaticGetterExpression;
import org.openzen.zenscript.codemodel.generic.ParameterTypeBound;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.FunctionalMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;
import stdlib.Strings;

public class JavaNativeModule {
    public final Module module;
    private final ZSPackage pkg;
    private final String basePackage;
    private final GlobalTypeRegistry registry;
    private final PackageDefinitions definitions = new PackageDefinitions();
    private final JavaCompiledModule compiled;
    private final Map<Class<?>, HighLevelDefinition> definitionByClass = new HashMap();
    private final Map<Class<?>, TypeID> typeByClass = new HashMap();
    private final Map<Class<?>, TypeID> unsignedByClass = new HashMap();
    public final Map<String, ISymbol> globals = new HashMap<String, ISymbol>();

    public JavaNativeModule(ZSPackage pkg, String name, String basePackage, GlobalTypeRegistry registry, JavaNativeModule[] dependencies) {
        this.pkg = pkg;
        this.basePackage = basePackage;
        this.module = new Module(name);
        this.registry = registry;
        for (JavaNativeModule dependency : dependencies) {
            this.definitionByClass.putAll(dependency.definitionByClass);
        }
        this.compiled = new JavaCompiledModule(this.module, FunctionParameter.NONE);
        this.typeByClass.put(Void.TYPE, BasicTypeID.VOID);
        this.typeByClass.put(Boolean.TYPE, BasicTypeID.BOOL);
        this.typeByClass.put(Byte.TYPE, BasicTypeID.SBYTE);
        this.typeByClass.put(Short.TYPE, BasicTypeID.SHORT);
        this.typeByClass.put(Integer.TYPE, BasicTypeID.INT);
        this.typeByClass.put(Long.TYPE, BasicTypeID.LONG);
        this.typeByClass.put(Float.TYPE, BasicTypeID.FLOAT);
        this.typeByClass.put(Double.TYPE, BasicTypeID.DOUBLE);
        this.typeByClass.put(String.class, StringTypeID.INSTANCE);
        this.typeByClass.put(Boolean.class, registry.getOptional(BasicTypeID.BOOL));
        this.typeByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.typeByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.typeByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.typeByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
        this.typeByClass.put(Float.class, registry.getOptional(BasicTypeID.FLOAT));
        this.typeByClass.put(Double.class, registry.getOptional(BasicTypeID.DOUBLE));
        this.unsignedByClass.put(Byte.TYPE, BasicTypeID.BYTE);
        this.unsignedByClass.put(Short.TYPE, BasicTypeID.USHORT);
        this.unsignedByClass.put(Integer.TYPE, BasicTypeID.UINT);
        this.unsignedByClass.put(Long.TYPE, BasicTypeID.ULONG);
        this.unsignedByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.unsignedByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.unsignedByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.unsignedByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
    }

    public SemanticModule toSemantic(ModuleSpace space) {
        return new SemanticModule(this.module, SemanticModule.NONE, FunctionParameter.NONE, SemanticModule.State.NORMALIZED, space.rootPackage, this.pkg, this.definitions, Collections.emptyList(), space.registry, space.collectExpansions(), space.getAnnotations(), space.getStorageTypes());
    }

    public JavaCompiledModule getCompiled() {
        return this.compiled;
    }

    public HighLevelDefinition addClass(Class<?> cls) {
        if (this.definitionByClass.containsKey(cls)) {
            return this.definitionByClass.get(cls);
        }
        HighLevelDefinition result = this.convertClass(cls);
        this.definitionByClass.put(cls, result);
        return result;
    }

    public void addGlobals(Class<?> cls) {
        ZenCodeGlobals.Global global;
        ClassDefinition definition = new ClassDefinition(CodePosition.NATIVE, this.module, this.pkg, "__globals__", 1);
        JavaClass jcls = JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.CLASS);
        this.compiled.setClassInfo(definition, jcls);
        StoredType thisType = this.registry.getForMyDefinition(definition).stored();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(field.getModifiers())) continue;
            global = field.getAnnotation(ZenCodeGlobals.Global.class);
            StoredType type = this.loadStoredType(field.getAnnotatedType());
            String name = global.value().isEmpty() ? field.getName() : global.value();
            FieldMember fieldMember = new FieldMember(CodePosition.NATIVE, (HighLevelDefinition)definition, 129, name, thisType, type, this.registry, 1, 0, null);
            definition.addMember(fieldMember);
            JavaField javaField = new JavaField(jcls, name, JavaNativeModule.getDescriptor(field.getType()));
            this.compiled.setFieldInfo(fieldMember, javaField);
            this.compiled.setFieldInfo(fieldMember.autoGetter, javaField);
            this.globals.put(name, new ExpressionSymbol((position, scope) -> new StaticGetterExpression(CodePosition.BUILTIN, fieldMember.autoGetter.ref(thisType, GenericMapper.EMPTY))));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(((Method)accessibleObject).getModifiers())) continue;
            global = ((Method)accessibleObject).getAnnotation(ZenCodeGlobals.Global.class);
            String name = global.value().isEmpty() ? ((Method)accessibleObject).getName() : global.value();
            MethodMember methodMember = new MethodMember(CodePosition.NATIVE, definition, 129, name, this.getHeader((Method)accessibleObject), null);
            definition.addMember(methodMember);
            boolean isGenericResult = methodMember.header.getReturnType().isGeneric();
            this.compiled.setMethodInfo(methodMember, new JavaMethod(jcls, JavaMethod.Kind.STATIC, name, false, JavaNativeModule.getMethodDescriptor((Method)accessibleObject), ((Method)accessibleObject).getModifiers(), isGenericResult));
            this.globals.put(name, new ExpressionSymbol((position, scope) -> {
                TypeMembers members = scope.getTypeMembers(thisType);
                return new PartialStaticMemberGroupExpression((CodePosition)position, (TypeScope)scope, thisType.type, members.getGroup(name), StoredType.NONE);
            }));
        }
    }

    private ZSPackage getPackage(String className) {
        if (!className.contains(".")) {
            return this.pkg;
        }
        if (className.startsWith(".")) {
            className = className.substring(1);
        } else if (className.startsWith(this.basePackage + ".")) {
            className = className.substring(this.basePackage.length() + 1);
        } else {
            throw new IllegalArgumentException("Invalid class name: not in the given base package");
        }
        String[] classNameParts = Strings.split(className, '.');
        ZSPackage classPkg = this.pkg;
        for (int i = 0; i < classNameParts.length - 1; ++i) {
            classPkg = classPkg.getOrCreatePackage(classNameParts[i]);
        }
        return classPkg;
    }

    private <T> HighLevelDefinition convertClass(Class<T> cls) {
        FunctionalMember member;
        JavaClass javaClass;
        HighLevelDefinition definition;
        if ((cls.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("Class must be public");
        }
        ZenCodeType.Name name = cls.getDeclaredAnnotation(ZenCodeType.Name.class);
        String className = name == null ? cls.getName() : name.value();
        boolean isStruct = cls.getAnnotation(ZenCodeType.Struct.class) != null;
        ZSPackage classPkg = this.getPackage(className);
        className = className.contains(".") ? className.substring(className.lastIndexOf(46) + 1) : className;
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        for (int i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Class<T>> typeVariable = javaTypeParameters[i];
            TypeParameter parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            for (AnnotatedType bound : typeVariable.getAnnotatedBounds()) {
                TypeID type = this.loadType(bound);
                parameter.addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
        }
        String internalName = JavaNativeModule.getInternalName(cls);
        if (cls.isInterface()) {
            definition = new InterfaceDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.INTERFACE);
        } else if (cls.isEnum()) {
            definition = new EnumDefinition(CodePosition.NATIVE, this.module, this.pkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.ENUM);
        } else if (isStruct) {
            definition = new StructDefinition(CodePosition.NATIVE, this.module, this.pkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
        } else {
            definition = new ClassDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
        }
        definition.typeParameters = typeParameters;
        this.compiled.setClassInfo(definition, javaClass);
        StoredType thisType = new StoredType(this.registry.getForMyDefinition(definition), AutoStorageTag.INSTANCE);
        for (Field field : cls.getDeclaredFields()) {
            ZenCodeType.Field field2 = field.getAnnotation(ZenCodeType.Field.class);
            if (field2 == null || !JavaNativeModule.isPublic(field.getModifiers())) continue;
            String fieldName = field.getName();
            if (field2 != null && !field2.value().isEmpty()) {
                fieldName = field2.value();
            }
            StoredType fieldType = this.loadStoredType(field.getAnnotatedType());
            FieldMember member2 = new FieldMember(CodePosition.NATIVE, definition, 1, fieldName, thisType, fieldType, this.registry, 0, 0, null);
            definition.addMember(member2);
            this.compiled.setFieldInfo(member2, new JavaField(javaClass, field.getName(), JavaNativeModule.getDescriptor(field.getType())));
        }
        boolean hasConstructor = false;
        for (Constructor<?> constructor : cls.getConstructors()) {
            ZenCodeType.Constructor constructorAnnotation = constructor.getAnnotation(ZenCodeType.Constructor.class);
            if (constructorAnnotation == null) continue;
            member = this.asConstructor(definition, constructor);
            definition.addMember(member);
            this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, constructor));
            hasConstructor = true;
        }
        if (!hasConstructor) {
            ConstructorMember member3 = new ConstructorMember(CodePosition.BUILTIN, definition, 4, new FunctionHeader(BasicTypeID.VOID), BuiltinID.CLASS_DEFAULT_CONSTRUCTOR);
            definition.addMember(member3);
        }
        for (Executable executable : cls.getDeclaredMethods()) {
            ZenCodeType.Method methodAnnotation = ((Method)executable).getAnnotation(ZenCodeType.Method.class);
            if (methodAnnotation != null) {
                member = this.asMethod(definition, (Method)executable, methodAnnotation);
                definition.addMember(member);
                this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, (Method)executable, ((MethodMember)member).header.getReturnType()));
                continue;
            }
            ZenCodeType.Getter getter = ((Method)executable).getAnnotation(ZenCodeType.Getter.class);
            if (getter != null) {
                GetterMember member2 = this.asGetter(definition, (Method)executable, getter);
                definition.addMember(member2);
                this.compiled.setMethodInfo(member2, JavaNativeModule.getMethod(javaClass, (Method)executable, member2.getType()));
                continue;
            }
            ZenCodeType.Setter setter = ((Method)executable).getAnnotation(ZenCodeType.Setter.class);
            if (setter != null) {
                SetterMember member4 = this.asSetter(definition, (Method)executable, setter);
                definition.addMember(member4);
                this.compiled.setMethodInfo(member4, JavaNativeModule.getMethod(javaClass, (Method)executable, BasicTypeID.VOID.stored));
                continue;
            }
            ZenCodeType.Operator operator = ((Method)executable).getAnnotation(ZenCodeType.Operator.class);
            if (operator != null) {
                OperatorMember member5 = this.asOperator(definition, (Method)executable, operator);
                definition.addMember(member5);
                this.compiled.setMethodInfo(member5, JavaNativeModule.getMethod(javaClass, (Method)executable, member5.header.getReturnType()));
                continue;
            }
            ZenCodeType.Caster caster = ((Method)executable).getAnnotation(ZenCodeType.Caster.class);
            if (caster == null) continue;
            CasterMember member6 = this.asCaster(definition, (Method)executable, caster);
            definition.addMember(member6);
            this.compiled.setMethodInfo(member6, JavaNativeModule.getMethod(javaClass, (Method)executable, member6.toType));
        }
        return definition;
    }

    private boolean isGetterName(String name) {
        return name.startsWith("get") || name.startsWith("is") || name.startsWith("has");
    }

    private String translateGetterName(String name) {
        if (name.startsWith("get")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private String translateSetterName(String name) {
        if (name.startsWith("set")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private ConstructorMember asConstructor(HighLevelDefinition definition, Constructor method) {
        FunctionHeader header = this.getHeader(method);
        return new ConstructorMember(CodePosition.NATIVE, definition, 1, header, null);
    }

    private MethodMember asMethod(HighLevelDefinition definition, Method method, ZenCodeType.Method annotation) {
        String name = annotation != null && !annotation.value().isEmpty() ? annotation.value() : method.getName();
        FunctionHeader header = this.getHeader(method);
        return new MethodMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, header, null);
    }

    private OperatorMember asOperator(HighLevelDefinition definition, Method method, ZenCodeType.Operator annotation) {
        FunctionHeader header = this.getHeader(method);
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("operator method cannot be static");
        }
        return new OperatorMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), OperatorType.valueOf(annotation.value().toString()), header, null);
    }

    private GetterMember asGetter(HighLevelDefinition definition, Method method, ZenCodeType.Getter annotation) {
        StoredType type = this.loadStoredType(method.getAnnotatedReturnType());
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateGetterName(method.getName());
        }
        return new GetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private SetterMember asSetter(HighLevelDefinition definition, Method method, ZenCodeType.Setter annotation) {
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Illegal setter: must have exactly 1 parameter");
        }
        StoredType type = this.loadStoredType(method.getAnnotatedParameterTypes()[0]);
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateSetterName(method.getName());
        }
        return new SetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private CasterMember asCaster(HighLevelDefinition definition, Method method, ZenCodeType.Caster annotation) {
        boolean implicit = annotation != null && annotation.implicit();
        int modifiers = 1;
        if (implicit) {
            modifiers |= 0x200;
        }
        StoredType toType = this.loadStoredType(method.getAnnotatedReturnType());
        return new CasterMember(CodePosition.NATIVE, definition, modifiers, toType, null);
    }

    private FunctionHeader getHeader(Constructor constructor) {
        return this.getHeader(null, constructor.getAnnotatedParameterTypes(), constructor.getTypeParameters(), constructor.getAnnotatedExceptionTypes());
    }

    private FunctionHeader getHeader(Method method) {
        return this.getHeader(method.getAnnotatedReturnType(), method.getAnnotatedParameterTypes(), method.getTypeParameters(), method.getAnnotatedExceptionTypes());
    }

    private FunctionHeader getHeader(AnnotatedType javaReturnType, AnnotatedType[] parameterTypes, TypeVariable<Method>[] javaTypeParameters, AnnotatedType[] exceptionTypes) {
        StoredType returnType = javaReturnType == null ? BasicTypeID.VOID.stored : this.loadStoredType(javaReturnType);
        FunctionParameter[] parameters = new FunctionParameter[parameterTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new FunctionParameter(this.loadStoredType(parameterTypes[i]));
        }
        TypeParameter[] typeParameters = new TypeParameter[javaTypeParameters.length];
        for (int i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Method> javaTypeParameter = javaTypeParameters[i];
            typeParameters[i] = new TypeParameter(CodePosition.UNKNOWN, javaTypeParameter.getName());
            for (AnnotatedType bound : javaTypeParameter.getAnnotatedBounds()) {
                typeParameters[i].addBound(new ParameterTypeBound(CodePosition.NATIVE, this.loadType(bound)));
            }
        }
        if (exceptionTypes.length > 1) {
            throw new IllegalArgumentException("A method can only throw a single exception type!");
        }
        StoredType thrownType = exceptionTypes.length == 0 ? null : this.loadStoredType(exceptionTypes[0]);
        return new FunctionHeader(typeParameters, returnType, thrownType, AutoStorageTag.INSTANCE, parameters);
    }

    private StoredType loadStoredType(AnnotatedType annotatedType) {
        TypeID baseType = this.loadType(annotatedType);
        return baseType.stored();
    }

    private TypeID loadType(AnnotatedType annotatedType) {
        if (annotatedType.isAnnotationPresent(ZenCodeType.USize.class)) {
            return BasicTypeID.USIZE;
        }
        if (annotatedType.isAnnotationPresent(ZenCodeType.NullableUSize.class)) {
            return this.registry.getOptional(BasicTypeID.USIZE);
        }
        boolean nullable = annotatedType.isAnnotationPresent(ZenCodeType.Nullable.class);
        boolean unsigned = annotatedType.isAnnotationPresent(ZenCodeType.Unsigned.class);
        Type type = annotatedType.getType();
        return this.loadType(type, nullable, unsigned);
    }

    private TypeID loadType(Type type, boolean nullable, boolean unsigned) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (unsigned) {
                if (this.unsignedByClass.containsKey(classType)) {
                    return this.unsignedByClass.get(classType);
                }
                throw new IllegalArgumentException("This class cannot be used as unsigned: " + classType);
            }
            if (this.typeByClass.containsKey(classType)) {
                return this.typeByClass.get(classType);
            }
            HighLevelDefinition definition = this.addClass(classType);
            return this.registry.getForDefinition(definition, new StoredType[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            HighLevelDefinition definition = this.addClass(rawType);
            Type[] parameters = parameterizedType.getActualTypeArguments();
            StoredType[] codeParameters = new StoredType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                codeParameters[i] = this.loadType(parameters[i], false, false).stored();
            }
            return this.registry.getForDefinition(definition, codeParameters);
        }
        throw new IllegalArgumentException("Could not analyze type: " + type);
    }

    private int getMethodModifiers(Method method) {
        int result = 1;
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            result |= 0x80;
        }
        if (JavaNativeModule.isFinal(method.getModifiers())) {
            result |= 0x10;
        }
        return result;
    }

    private static boolean isPublic(int modifiers) {
        return (modifiers & 1) > 0;
    }

    private static boolean isStatic(int modifiers) {
        return (modifiers & 8) > 0;
    }

    private static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    private static String getInternalName(Class<?> cls) {
        return org.objectweb.asm.Type.getInternalName(cls);
    }

    private static String getDescriptor(Class<?> cls) {
        return org.objectweb.asm.Type.getDescriptor(cls);
    }

    private static String getMethodDescriptor(Constructor constructor) {
        return org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor);
    }

    private static String getMethodDescriptor(Method method) {
        return org.objectweb.asm.Type.getMethodDescriptor((Method)method);
    }

    private static JavaMethod getMethod(JavaClass cls, Constructor constructor) {
        return new JavaMethod(cls, JavaMethod.Kind.CONSTRUCTOR, "<init>", false, JavaNativeModule.getMethodDescriptor(constructor), constructor.getModifiers(), false);
    }

    private static JavaMethod getMethod(JavaClass cls, Method method, StoredType result) {
        JavaMethod.Kind kind = method.getName().equals("<init>") ? JavaMethod.Kind.CONSTRUCTOR : (method.getName().equals("<clinit>") ? JavaMethod.Kind.STATICINIT : (JavaNativeModule.isStatic(method.getModifiers()) ? JavaMethod.Kind.STATIC : JavaMethod.Kind.INSTANCE));
        return new JavaMethod(cls, kind, method.getName(), false, JavaNativeModule.getMethodDescriptor(method), method.getModifiers(), result.isGeneric());
    }
}

