/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.List;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;

public class GenericName {
    public final String name;
    public final StoredType[] arguments;

    public GenericName(String name) {
        this(name, StoredType.NONE);
    }

    public GenericName(String name, StoredType[] arguments) {
        if (arguments == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        this.name = name;
        this.arguments = arguments;
    }

    public int getNumberOfArguments() {
        return this.arguments.length;
    }

    public boolean hasArguments() {
        return this.arguments.length > 0;
    }

    public boolean hasNoArguments() {
        return this.arguments.length == 0;
    }

    public static TypeID getInnerType(GlobalTypeRegistry registry, DefinitionTypeID type, List<GenericName> name, int index) {
        while (index < name.size()) {
            GenericName innerName;
            if ((type = type.getInnerType(innerName = name.get(index++), registry)) != null) continue;
            return null;
        }
        return type;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name);
        if (this.hasArguments()) {
            result.append("<");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.arguments[i].toString());
            }
            result.append(">");
        }
        return result.toString();
    }
}

