/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;

public class GlobalTypeRegistry {
    private final Map<ArrayTypeID, ArrayTypeID> arrayTypes = new HashMap<ArrayTypeID, ArrayTypeID>();
    private final Map<AssocTypeID, AssocTypeID> assocTypes = new HashMap<AssocTypeID, AssocTypeID>();
    private final Map<GenericMapTypeID, GenericMapTypeID> genericMapTypes = new HashMap<GenericMapTypeID, GenericMapTypeID>();
    private final Map<IteratorTypeID, IteratorTypeID> iteratorTypes = new HashMap<IteratorTypeID, IteratorTypeID>();
    private final Map<FunctionTypeID, FunctionTypeID> functionTypes = new HashMap<FunctionTypeID, FunctionTypeID>();
    private final Map<RangeTypeID, RangeTypeID> rangeTypes = new HashMap<RangeTypeID, RangeTypeID>();
    private final Map<DefinitionTypeID, DefinitionTypeID> definitionTypes = new HashMap<DefinitionTypeID, DefinitionTypeID>();
    private final Map<GenericTypeID, GenericTypeID> genericTypes = new HashMap<GenericTypeID, GenericTypeID>();
    private final Map<OptionalTypeID, OptionalTypeID> optionalTypes = new HashMap<OptionalTypeID, OptionalTypeID>();
    public final ZSPackage stdlib;

    public GlobalTypeRegistry(ZSPackage stdlib) {
        this.stdlib = stdlib;
        this.arrayTypes.put(ArrayTypeID.INT, ArrayTypeID.INT);
        this.arrayTypes.put(ArrayTypeID.CHAR, ArrayTypeID.CHAR);
        this.rangeTypes.put(RangeTypeID.INT, RangeTypeID.INT);
        this.rangeTypes.put(RangeTypeID.USIZE, RangeTypeID.USIZE);
    }

    public ArrayTypeID getArray(StoredType baseType, int dimension) {
        ArrayTypeID id = new ArrayTypeID(this, baseType, dimension);
        return this.internalize(this.arrayTypes, id);
    }

    public AssocTypeID getAssociative(StoredType keyType, StoredType valueType) {
        AssocTypeID id = new AssocTypeID(this, keyType, valueType);
        return this.internalize(this.assocTypes, id);
    }

    public GenericMapTypeID getGenericMap(StoredType valueType, TypeParameter key) {
        GenericMapTypeID id = new GenericMapTypeID(this, valueType, key);
        return this.internalize(this.genericMapTypes, id);
    }

    public IteratorTypeID getIterator(StoredType[] loopTypes) {
        IteratorTypeID id = new IteratorTypeID(this, loopTypes);
        return this.internalize(this.iteratorTypes, id);
    }

    public FunctionTypeID getFunction(FunctionHeader header) {
        FunctionTypeID id = new FunctionTypeID(this, header);
        return this.internalize(this.functionTypes, id);
    }

    public RangeTypeID getRange(StoredType type) {
        RangeTypeID id = new RangeTypeID(this, type);
        return this.internalize(this.rangeTypes, id);
    }

    public GenericTypeID getGeneric(TypeParameter parameter) {
        GenericTypeID id = new GenericTypeID(parameter);
        return this.internalize(this.genericTypes, id);
    }

    public DefinitionTypeID getForMyDefinition(HighLevelDefinition definition) {
        StoredType[] typeArguments = StoredType.NONE;
        if (definition.getNumberOfGenericParameters() > 0) {
            typeArguments = new StoredType[definition.getNumberOfGenericParameters()];
            for (int i = 0; i < definition.typeParameters.length; ++i) {
                typeArguments[i] = new StoredType(this.getGeneric(definition.typeParameters[i]), definition.typeParameters[i].storage);
            }
        }
        DefinitionTypeID outer = null;
        if (definition.outerDefinition != null) {
            outer = this.getForMyDefinition(definition.outerDefinition);
        }
        return this.getForDefinition(definition, typeArguments, outer);
    }

    public DefinitionTypeID getForDefinition(HighLevelDefinition definition, StoredType ... typeArguments) {
        return this.getForDefinition(definition, typeArguments, (DefinitionTypeID)null);
    }

    public DefinitionTypeID getForDefinition(HighLevelDefinition definition, StoredType[] typeArguments, DefinitionTypeID outer) {
        DefinitionTypeID id = new DefinitionTypeID(this, definition, typeArguments, definition.isStatic() ? null : outer);
        return this.internalize(this.definitionTypes, id);
    }

    public TypeID getOptional(TypeID original) {
        return this.internalize(this.optionalTypes, new OptionalTypeID(this, original));
    }

    private <T> T internalize(Map<T, T> identityMap, T id) {
        if (identityMap.containsKey(id)) {
            return identityMap.get(id);
        }
        identityMap.put(id, id);
        return id;
    }
}

