/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.storage;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.type.storage.BorrowStorageTag;
import org.openzen.zenscript.codemodel.type.storage.InvalidStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageType;

public class BorrowStorageType
implements StorageType {
    public static final BorrowStorageType INSTANCE = new BorrowStorageType();

    private BorrowStorageType() {
    }

    @Override
    public String getName() {
        return "borrow";
    }

    @Override
    public StorageTag instance(CodePosition position, String[] arguments) {
        if (arguments.length > 0) {
            if (arguments.length == 1 && arguments[0].equals("this")) {
                return BorrowStorageTag.THIS;
            }
            return new InvalidStorageTag(position, CompileExceptionCode.INVALID_STORAGE_TYPE_ARGUMENTS, "borrow storage type doesn't take arguments");
        }
        return BorrowStorageTag.INVOCATION;
    }
}

