/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.Collections;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.ConstantByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantCharExpression;
import org.openzen.zenscript.codemodel.expression.ConstantIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantLongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantSByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantULongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUSizeExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.expression.switchvalue.IntSwitchValue;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionInt
extends ParsedExpression {
    public final boolean negative;
    public final long value;
    public final String suffix;

    public static ParsedExpressionInt parsePrefixed(CodePosition position, String value) {
        boolean negative = value.startsWith("-");
        if (negative) {
            value = value.substring(1);
        }
        String suffix = "";
        if (value.endsWith("u") || value.endsWith("l") || value.endsWith("U") || value.endsWith("L")) {
            suffix = value.substring(value.length() - 1);
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("ul") || value.endsWith("UL")) {
            suffix = value.substring(value.length() - 2);
            value = value.substring(0, value.length() - 2);
        }
        value = value.toLowerCase();
        long parsed = 0L;
        if (value.startsWith("0x")) {
            for (char c : value.substring(2).toCharArray()) {
                if (c >= '0' && c <= '9') {
                    parsed = parsed * 16L + (long)(c - 48);
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    parsed = parsed * 16L + 10L + (long)(c - 97);
                    continue;
                }
                if (c == '_') continue;
                throw new NumberFormatException("Invalid number: " + value);
            }
        } else if (value.startsWith("0b")) {
            for (char c : value.substring(2).toCharArray()) {
                if (c == '0') {
                    parsed *= 2L;
                    continue;
                }
                if (c == '1') {
                    parsed = parsed * 2L + 1L;
                    continue;
                }
                if (c == '_') continue;
                throw new NumberFormatException("Invalid number: " + value);
            }
        } else if (value.startsWith("0o")) {
            for (char c : value.substring(2).toCharArray()) {
                if (c >= '0' && c <= '7') {
                    parsed = parsed * 8L + (long)c - 48L;
                    continue;
                }
                if (c == '_') continue;
                throw new NumberFormatException("Invalid number: " + value);
            }
        } else {
            throw new NumberFormatException("Invalid number: " + value);
        }
        return new ParsedExpressionInt(position, negative, negative ? -parsed : parsed, suffix);
    }

    public ParsedExpressionInt(CodePosition position, String value) {
        super(position);
        int split = value.length();
        while (ParsedExpressionInt.isLetter(value.charAt(split - 1))) {
            --split;
        }
        this.negative = value.charAt(0) == '-';
        this.value = Long.parseLong(value.substring(0, split));
        this.suffix = value.substring(split);
    }

    private ParsedExpressionInt(CodePosition position, boolean negative, long value, String suffix) {
        super(position);
        this.negative = negative;
        this.value = value;
        this.suffix = suffix;
    }

    @Override
    public Expression compile(ExpressionScope scope) throws CompileException {
        if (this.suffix.equals("L") || this.suffix.equals("l")) {
            return new ConstantLongExpression(this.position, this.value);
        }
        if (this.suffix.equals("UL") || this.suffix.equals("ul")) {
            return new ConstantULongExpression(this.position, this.value);
        }
        if (this.suffix.equals("U") || this.suffix.equals("u")) {
            return new ConstantUIntExpression(this.position, (int)this.value);
        }
        for (StoredType hint : scope.hints) {
            TypeMembers members;
            FunctionalMemberRef method;
            if (this.suffix.isEmpty() && hint.type instanceof BasicTypeID) {
                switch ((BasicTypeID)hint.type) {
                    case SBYTE: {
                        return new ConstantSByteExpression(this.position, (byte)this.value);
                    }
                    case BYTE: {
                        if (this.negative) break;
                        return new ConstantByteExpression(this.position, (int)(this.value & 0xFFL));
                    }
                    case SHORT: {
                        return new ConstantShortExpression(this.position, (short)this.value);
                    }
                    case USHORT: {
                        if (this.negative) break;
                        return new ConstantUShortExpression(this.position, (int)(this.value & 0xFFFFL));
                    }
                    case INT: {
                        return new ConstantIntExpression(this.position, (int)this.value);
                    }
                    case UINT: {
                        if (this.negative) break;
                        return new ConstantUIntExpression(this.position, (int)this.value);
                    }
                    case LONG: {
                        return new ConstantLongExpression(this.position, this.value);
                    }
                    case ULONG: {
                        if (this.negative) break;
                        return new ConstantULongExpression(this.position, this.value);
                    }
                    case USIZE: {
                        if (this.negative) break;
                        return new ConstantUSizeExpression(this.position, this.value);
                    }
                    case CHAR: {
                        if (this.negative) break;
                        return new ConstantCharExpression(this.position, (char)this.value);
                    }
                }
                continue;
            }
            if (this.suffix.isEmpty() || (method = (members = scope.getTypeMembers(hint)).getOrCreateGroup(this.suffix, true).getStaticMethod(1, hint)) == null) continue;
            try {
                ParsedCallArguments parsedArguments = new ParsedCallArguments(Collections.emptyList(), Collections.singletonList(new ParsedExpressionInt(this.position, this.negative, this.value, "")));
                CallArguments arguments = parsedArguments.compileCall(this.position, scope, StoredType.NONE, method.getHeader());
                method.callStatic(this.position, hint.type, method.getHeader(), arguments, scope);
            }
            catch (CompileException ex) {
                return new InvalidExpression(hint, ex);
            }
        }
        if (this.suffix.isEmpty()) {
            if (this.value <= Integer.MAX_VALUE && this.value >= Integer.MIN_VALUE) {
                return new ConstantIntExpression(this.position, (int)this.value);
            }
            return new ConstantLongExpression(this.position, this.value);
        }
        throw new CompileException(this.position, CompileExceptionCode.INVALID_SUFFIX, "Invalid suffix: " + this.suffix);
    }

    @Override
    public SwitchValue compileToSwitchValue(StoredType type, ExpressionScope scope) throws CompileException {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            throw new CompileException(this.position, CompileExceptionCode.INVALID_SWITCH_CASE, "value is too large for a switch case");
        }
        return new IntSwitchValue((int)this.value);
    }

    @Override
    public boolean hasStrongType() {
        return false;
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }
}

