/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.ConcatMap;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.statement.StatementTransformer;
import org.openzen.zenscript.codemodel.statement.StatementVisitor;
import org.openzen.zenscript.codemodel.statement.StatementVisitorWithContext;
import org.openzen.zenscript.codemodel.statement.SwitchCase;

public class SwitchStatement
extends LoopStatement {
    public final Expression value;
    public final List<SwitchCase> cases = new ArrayList<SwitchCase>();

    public SwitchStatement(CodePosition position, String label, Expression value) {
        super(position, label, null);
        this.value = value;
    }

    @Override
    public <T> T accept(StatementVisitor<T> visitor) {
        return visitor.visitSwitch(this);
    }

    @Override
    public <C, R> R accept(C context, StatementVisitorWithContext<C, R> visitor) {
        return visitor.visitSwitch(context, this);
    }

    @Override
    public void forEachStatement(Consumer<Statement> consumer) {
        consumer.accept(this);
        for (SwitchCase switchCase : this.cases) {
            for (Statement statement : switchCase.statements) {
                statement.forEachStatement(consumer);
            }
        }
    }

    @Override
    public Statement transform(StatementTransformer transformer, ConcatMap<LoopStatement, LoopStatement> modified) {
        Expression tValue = this.value.transform(transformer);
        SwitchStatement result = new SwitchStatement(this.position, this.label, tValue);
        ConcatMap<LoopStatement, LoopStatement> tModified = modified.concat(this, result);
        for (SwitchCase case_ : this.cases) {
            result.cases.add(case_.transform(transformer, tModified));
        }
        return result;
    }

    @Override
    public Statement transform(ExpressionTransformer transformer, ConcatMap<LoopStatement, LoopStatement> modified) {
        Expression tValue = this.value.transform(transformer);
        SwitchStatement result = new SwitchStatement(this.position, this.label, tValue);
        ConcatMap<LoopStatement, LoopStatement> tModified = modified.concat(this, result);
        for (SwitchCase case_ : this.cases) {
            result.cases.add(case_.transform(transformer, tModified));
        }
        return result;
    }

    @Override
    public Statement normalize(TypeScope scope, ConcatMap<LoopStatement, LoopStatement> modified) {
        SwitchStatement result = new SwitchStatement(this.position, this.label, this.value.normalize(scope));
        ConcatMap<LoopStatement, LoopStatement> tModified = modified.concat(this, result);
        for (SwitchCase case_ : this.cases) {
            result.cases.add(case_.normalize(scope, tModified));
        }
        return result;
    }
}

