/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class OptionalTypeID
implements TypeID {
    public final TypeID baseType;
    private final TypeID normalized;

    public OptionalTypeID(GlobalTypeRegistry registry, TypeID baseType) {
        this.baseType = baseType;
        this.normalized = baseType.getNormalized() == baseType ? this : registry.getOptional(baseType.getNormalized());
    }

    @Override
    public TypeID getNormalized() {
        return this.normalized;
    }

    @Override
    public StoredType instance(GenericMapper mapper, StorageTag storage) {
        StoredType base = this.baseType.instance(mapper, storage);
        return mapper.registry.getOptional(base.type).stored(StorageTag.union(mapper.position, base.getSpecifiedStorage(), storage));
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitOptional(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitOptional(context, this);
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public boolean isValueType() {
        return this.baseType.isValueType();
    }

    @Override
    public boolean isDestructible() {
        return this.baseType.isDestructible();
    }

    @Override
    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return this.baseType.isDestructible(scanning);
    }

    @Override
    public TypeID withoutOptional() {
        return this.baseType;
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.baseType.hasInferenceBlockingTypeParameters(parameters);
    }

    @Override
    public boolean hasDefaultValue() {
        return this.isOptional() || this.baseType.hasDefaultValue();
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        this.baseType.extractTypeParameters(typeParameters);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.baseType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionalTypeID other = (OptionalTypeID)obj;
        return this.baseType == other.baseType;
    }

    public String toString() {
        return this.baseType.toString() + "?";
    }

    @Override
    public String toString(StorageTag storage) {
        return this.baseType.toString(storage) + '?';
    }
}

