/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.statement.VariableID;
import org.openzen.zenscript.javabytecode.JavaLocalVariableInfo;
import org.openzen.zenscript.javabytecode.compiler.JavaSwitchLabel;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaParameterInfo;

public class JavaWriter {
    private static final JavaMethod STRING_CONCAT = JavaMethod.getNativeStatic(JavaClass.STRING, "concat", "(Ljava/lang/String;)Ljava/lang/String;");
    public final JavaMethod method;
    public final HighLevelDefinition forDefinition;
    private final CodePosition position;
    private final LocalVariablesSorter visitor;
    private final List<JavaLocalVariableInfo> localVariableInfos = new ArrayList<JavaLocalVariableInfo>();
    public final ClassVisitor clazzVisitor;
    private boolean debug = false;
    private boolean nameVariables = true;
    private int labelIndex = 1;
    private Map<Label, String> labelNames = new HashMap<Label, String>();
    private final Map<VariableID, JavaLocalVariableInfo> localVariables = new HashMap<VariableID, JavaLocalVariableInfo>();

    public JavaWriter(CodePosition position, ClassVisitor visitor, boolean nameVariables, JavaMethod method, HighLevelDefinition forDefinition, String signature, String[] exceptions, String ... annotations) {
        this(position, visitor, nameVariables, method, forDefinition, false, signature, method.descriptor, exceptions, annotations);
    }

    public JavaWriter(CodePosition position, ClassVisitor visitor, boolean nameVariables, JavaMethod method, HighLevelDefinition forDefinition, boolean isExtension, String signature, String descriptor, String[] exceptions, String ... annotations) {
        this.clazzVisitor = visitor;
        this.method = method;
        this.forDefinition = forDefinition;
        this.position = position;
        MethodVisitor methodVisitor = visitor.visitMethod(isExtension ? method.modifiers | 8 : method.modifiers, method.name, descriptor, signature, exceptions);
        for (String annotation : annotations) {
            methodVisitor.visitAnnotation(annotation, true).visitEnd();
        }
        this.visitor = new LocalVariablesSorter(isExtension ? method.modifiers | 8 : method.modifiers, descriptor, methodVisitor);
        this.nameVariables = nameVariables;
    }

    public JavaWriter(CodePosition position, ClassVisitor visitor, JavaMethod method, HighLevelDefinition forDefinition, String signature, String[] exceptions, String ... annotations) {
        this(position, visitor, true, method, forDefinition, signature, exceptions, annotations);
    }

    public void setLocalVariable(VariableID variable, JavaLocalVariableInfo info) {
        this.localVariables.put(variable, info);
    }

    public JavaLocalVariableInfo getLocalVariable(VariableID variable) {
        JavaLocalVariableInfo result = this.localVariables.get(variable);
        if (result == null) {
            throw new IllegalStateException("Local variable unknown");
        }
        return result;
    }

    public void enableDebug() {
        this.debug = true;
    }

    public LocalVariablesSorter getVisitor() {
        return this.visitor;
    }

    public void start() {
        if (this.debug) {
            System.out.println("--start--");
        }
        this.visitor.visitCode();
    }

    public void end() {
        if (this.debug) {
            System.out.println("--end--");
        }
        this.visitor.visitMaxs(0, 0);
        if (this.nameVariables) {
            for (JavaLocalVariableInfo info : this.localVariableInfos) {
                this.nameVariable(info.local, info.name, info.start, info.end, info.type);
            }
        }
        this.visitor.visitEnd();
    }

    public void label(Label label) {
        if (this.debug) {
            System.out.println("Label " + this.getLabelName(label));
        }
        this.visitor.visitLabel(label);
    }

    public int local(Type type) {
        return this.visitor.newLocal(type);
    }

    public int local(Class cls) {
        return this.visitor.newLocal(Type.getType((Class)cls));
    }

    public void iConst0() {
        if (this.debug) {
            System.out.println("iconst0");
        }
        this.visitor.visitInsn(3);
    }

    public void iConst1() {
        if (this.debug) {
            System.out.println("iconst1");
        }
        this.visitor.visitInsn(4);
    }

    public void biPush(byte value) {
        if (this.debug) {
            System.out.println("bipush");
        }
        this.visitor.visitIntInsn(16, (int)value);
    }

    public void siPush(short value) {
        if (this.debug) {
            System.out.println("sipush");
        }
        this.visitor.visitIntInsn(17, (int)value);
    }

    public void aConstNull() {
        if (this.debug) {
            System.out.println("aConstNull");
        }
        this.visitor.visitInsn(1);
    }

    public void constant(Object value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (this.debug) {
            System.out.println("ldc " + value);
        }
        this.visitor.visitLdcInsn(value);
    }

    public void constantClass(JavaClass cls) {
        this.visitor.visitLdcInsn((Object)Type.getType((String)cls.internalName));
    }

    public void pop() {
        if (this.debug) {
            System.out.println("pop");
        }
        this.visitor.visitInsn(87);
    }

    public void pop(boolean large) {
        if (this.debug) {
            System.out.println("pop");
        }
        this.visitor.visitInsn(large ? 88 : 87);
    }

    public void dup() {
        if (this.debug) {
            System.out.println("dup");
        }
        this.visitor.visitInsn(89);
    }

    public void dup(Type type) {
        if (this.debug) {
            System.out.println("dup");
        }
        this.visitor.visitInsn(type.getSize() == 2 ? 92 : 89);
    }

    public void dup(boolean large) {
        if (this.debug) {
            System.out.println("dup");
        }
        this.visitor.visitInsn(large ? 92 : 89);
    }

    public void dup2() {
        if (this.debug) {
            System.out.println("dup2");
        }
        this.visitor.visitInsn(92);
    }

    public void dupX1() {
        if (this.debug) {
            System.out.println("dupx1");
        }
        this.visitor.visitInsn(90);
    }

    public void dupX1(boolean tosLarge, boolean large) {
        if (this.debug) {
            System.out.println("dupx1");
        }
        if (tosLarge) {
            this.visitor.visitInsn(large ? 94 : 91);
        } else {
            this.visitor.visitInsn(large ? 93 : 90);
        }
    }

    public void dupX2() {
        if (this.debug) {
            System.out.println("dupx2");
        }
        this.visitor.visitInsn(91);
    }

    public void dup2X1() {
        if (this.debug) {
            System.out.println("dup2_x1");
        }
        this.visitor.visitInsn(93);
    }

    public void dup2X2() {
        if (this.debug) {
            System.out.println("dup2_x2");
        }
        this.visitor.visitInsn(94);
    }

    public void store(Type type, int local) {
        if (this.debug) {
            System.out.println("store " + local);
        }
        this.visitor.visitVarInsn(type.getOpcode(54), local);
    }

    public void load(Type type, int local) {
        if (this.debug) {
            System.out.println("load " + local);
        }
        this.visitor.visitVarInsn(type.getOpcode(21), local);
    }

    public void load(JavaParameterInfo parameter) {
        if (this.debug) {
            System.out.println("load " + parameter.index);
        }
        this.visitor.visitVarInsn(Type.getType((String)parameter.typeDescriptor).getOpcode(21), parameter.index);
    }

    public void load(JavaLocalVariableInfo localVariable) {
        if (this.debug) {
            System.out.println("load " + localVariable.local);
        }
        this.visitor.visitVarInsn(localVariable.type.getOpcode(21), localVariable.local);
    }

    public void store(JavaParameterInfo parameter) {
        if (this.debug) {
            System.out.println("store " + parameter.index);
        }
        this.visitor.visitVarInsn(Type.getType((String)parameter.typeDescriptor).getOpcode(54), parameter.index);
    }

    public void store(JavaLocalVariableInfo localVariable) {
        if (this.debug) {
            System.out.println("store " + localVariable.local);
        }
        this.visitor.visitVarInsn(localVariable.type.getOpcode(54), localVariable.local);
    }

    public void storeInt(int local) {
        if (this.debug) {
            System.out.println("storeInt " + local);
        }
        this.visitor.visitVarInsn(54, local);
    }

    public void loadInt(int local) {
        if (this.debug) {
            System.out.println("loadInt " + local);
        }
        this.visitor.visitVarInsn(21, local);
    }

    public void storeObject(int local) {
        if (this.debug) {
            System.out.println("storeObject " + local);
        }
        this.visitor.visitVarInsn(58, local);
    }

    public void loadObject(int local) {
        if (this.debug) {
            System.out.println("loadObject " + local);
        }
        this.visitor.visitVarInsn(25, local);
    }

    public void arrayLength() {
        if (this.debug) {
            System.out.println("arrayLength");
        }
        this.visitor.visitInsn(190);
    }

    public void arrayLoad(Type type) {
        if (this.debug) {
            System.out.println("arrayLoad");
        }
        this.visitor.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        if (this.debug) {
            System.out.println("arrayStore");
        }
        this.visitor.visitInsn(type.getOpcode(79));
    }

    public void newArray(Type componentType) {
        int sort;
        if (this.debug) {
            System.out.println("newArray");
        }
        if ((sort = componentType.getSort()) == 11) {
            throw new RuntimeException("Unsupported array type: " + componentType);
        }
        if (sort == 10 || sort == 9) {
            this.visitor.visitTypeInsn(189, componentType.getInternalName());
        } else {
            int type;
            switch (sort) {
                case 1: {
                    type = 4;
                    break;
                }
                case 3: {
                    type = 8;
                    break;
                }
                case 4: {
                    type = 9;
                    break;
                }
                case 5: {
                    type = 10;
                    break;
                }
                case 7: {
                    type = 11;
                    break;
                }
                case 6: {
                    type = 6;
                    break;
                }
                case 8: {
                    type = 7;
                    break;
                }
                case 2: {
                    type = 5;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported array type: " + componentType);
                }
            }
            this.visitor.visitIntInsn(188, type);
        }
    }

    public void checkCast(String internalName) {
        if (this.debug) {
            System.out.println("checkCast " + internalName);
        }
        this.visitor.visitTypeInsn(192, internalName);
    }

    public void checkCast(Type type) {
        if (this.debug) {
            System.out.println("checkCast " + type.getDescriptor());
        }
        this.visitor.visitTypeInsn(192, type.getDescriptor());
    }

    public void iNeg() {
        if (this.debug) {
            System.out.println("iNeg");
        }
        this.visitor.visitInsn(116);
    }

    public void iAdd() {
        if (this.debug) {
            System.out.println("iAdd");
        }
        this.visitor.visitInsn(96);
    }

    public void iSub() {
        if (this.debug) {
            System.out.println("iSub");
        }
        this.visitor.visitInsn(100);
    }

    public void iMul() {
        if (this.debug) {
            System.out.println("iMul");
        }
        this.visitor.visitInsn(104);
    }

    public void iDiv() {
        if (this.debug) {
            System.out.println("iDiv");
        }
        this.visitor.visitInsn(108);
    }

    public void iRem() {
        if (this.debug) {
            System.out.println("iRem");
        }
        this.visitor.visitInsn(112);
    }

    public void iAnd() {
        if (this.debug) {
            System.out.println("iAnd");
        }
        this.visitor.visitInsn(126);
    }

    public void iOr() {
        if (this.debug) {
            System.out.println("iOr");
        }
        this.visitor.visitInsn(128);
    }

    public void iXor() {
        if (this.debug) {
            System.out.println("iXor");
        }
        this.visitor.visitInsn(130);
    }

    public void iNot() {
        if (this.debug) {
            System.out.println("iNot");
        }
        this.visitor.visitInsn(2);
        this.visitor.visitInsn(130);
    }

    public void iXorVs1() {
        if (this.debug) {
            System.out.println("iXor against '1'");
        }
        this.visitor.visitInsn(4);
        this.visitor.visitInsn(130);
    }

    public void iShr() {
        if (this.debug) {
            System.out.println("iShr");
        }
        this.visitor.visitInsn(122);
    }

    public void iUShr() {
        if (this.debug) {
            System.out.println("iUShr");
        }
        this.visitor.visitInsn(124);
    }

    public void iShl() {
        if (this.debug) {
            System.out.println("iShl");
        }
        this.visitor.visitInsn(120);
    }

    public void lNeg() {
        if (this.debug) {
            System.out.println("lNeg");
        }
        this.visitor.visitInsn(117);
    }

    public void lAdd() {
        if (this.debug) {
            System.out.println("lAdd");
        }
        this.visitor.visitInsn(97);
    }

    public void lSub() {
        if (this.debug) {
            System.out.println("lSub");
        }
        this.visitor.visitInsn(101);
    }

    public void lMul() {
        if (this.debug) {
            System.out.println("lMul");
        }
        this.visitor.visitInsn(105);
    }

    public void lDiv() {
        if (this.debug) {
            System.out.println("lDiv");
        }
        this.visitor.visitInsn(109);
    }

    public void lRem() {
        if (this.debug) {
            System.out.println("lRem");
        }
        this.visitor.visitInsn(113);
    }

    public void lAnd() {
        if (this.debug) {
            System.out.println("lAnd");
        }
        this.visitor.visitInsn(127);
    }

    public void lOr() {
        if (this.debug) {
            System.out.println("lOr");
        }
        this.visitor.visitInsn(129);
    }

    public void lXor() {
        if (this.debug) {
            System.out.println("lXor");
        }
        this.visitor.visitInsn(131);
    }

    public void lNot() {
        if (this.debug) {
            System.out.println("lNot");
        }
        this.constant(-1L);
        this.lXor();
    }

    public void lShr() {
        if (this.debug) {
            System.out.println("lShr");
        }
        this.visitor.visitInsn(123);
    }

    public void lUShr() {
        if (this.debug) {
            System.out.println("lUShr");
        }
        this.visitor.visitInsn(125);
    }

    public void lShl() {
        if (this.debug) {
            System.out.println("lShl");
        }
        this.visitor.visitInsn(121);
    }

    public void fNeg() {
        if (this.debug) {
            System.out.println("fNeg");
        }
        this.visitor.visitInsn(118);
    }

    public void fAdd() {
        if (this.debug) {
            System.out.println("fAdd");
        }
        this.visitor.visitInsn(98);
    }

    public void fSub() {
        if (this.debug) {
            System.out.println("fSub");
        }
        this.visitor.visitInsn(102);
    }

    public void fMul() {
        if (this.debug) {
            System.out.println("fMul");
        }
        this.visitor.visitInsn(106);
    }

    public void fDiv() {
        if (this.debug) {
            System.out.println("fDiv");
        }
        this.visitor.visitInsn(110);
    }

    public void fRem() {
        if (this.debug) {
            System.out.println("fRem");
        }
        this.visitor.visitInsn(114);
    }

    public void dNeg() {
        if (this.debug) {
            System.out.println("dNeg");
        }
        this.visitor.visitInsn(119);
    }

    public void dAdd() {
        if (this.debug) {
            System.out.println("dAdd");
        }
        this.visitor.visitInsn(99);
    }

    public void dSub() {
        if (this.debug) {
            System.out.println("dSub");
        }
        this.visitor.visitInsn(103);
    }

    public void dMul() {
        if (this.debug) {
            System.out.println("dMul");
        }
        this.visitor.visitInsn(107);
    }

    public void dDiv() {
        if (this.debug) {
            System.out.println("dDiv");
        }
        this.visitor.visitInsn(111);
    }

    public void dRem() {
        if (this.debug) {
            System.out.println("dRem");
        }
        this.visitor.visitInsn(115);
    }

    public void iinc(int local) {
        this.iinc(local, 1);
    }

    public void idec(int local) {
        this.iinc(local, -1);
    }

    public void iinc(int local, int increment) {
        if (this.debug) {
            System.out.println("iinc " + local + " + " + increment);
        }
        this.visitor.visitIincInsn(local, increment);
    }

    public void i2b() {
        if (this.debug) {
            System.out.println("i2b");
        }
        this.visitor.visitInsn(145);
    }

    public void i2s() {
        if (this.debug) {
            System.out.println("i2s");
        }
        this.visitor.visitInsn(147);
    }

    public void i2l() {
        if (this.debug) {
            System.out.println("i2l");
        }
        this.visitor.visitInsn(133);
    }

    public void i2f() {
        if (this.debug) {
            System.out.println("i2f");
        }
        this.visitor.visitInsn(134);
    }

    public void i2d() {
        if (this.debug) {
            System.out.println("i2d");
        }
        this.visitor.visitInsn(135);
    }

    public void l2i() {
        if (this.debug) {
            System.out.println("l2i");
        }
        this.visitor.visitInsn(136);
    }

    public void l2f() {
        if (this.debug) {
            System.out.println("l2f");
        }
        this.visitor.visitInsn(137);
    }

    public void l2d() {
        if (this.debug) {
            System.out.println("l2d");
        }
        this.visitor.visitInsn(138);
    }

    public void f2i() {
        if (this.debug) {
            System.out.println("f2i");
        }
        this.visitor.visitInsn(139);
    }

    public void f2l() {
        if (this.debug) {
            System.out.println("f2l");
        }
        this.visitor.visitInsn(140);
    }

    public void f2d() {
        if (this.debug) {
            System.out.println("f2d");
        }
        this.visitor.visitInsn(141);
    }

    public void d2i() {
        if (this.debug) {
            System.out.println("d2i");
        }
        this.visitor.visitInsn(142);
    }

    public void d2l() {
        if (this.debug) {
            System.out.println("d2l");
        }
        this.visitor.visitInsn(143);
    }

    public void d2f() {
        if (this.debug) {
            System.out.println("d2f");
        }
        this.visitor.visitInsn(144);
    }

    public void lCmp() {
        if (this.debug) {
            System.out.println("lCmp");
        }
        this.visitor.visitInsn(148);
    }

    public void fCmp() {
        if (this.debug) {
            System.out.println("fCmp");
        }
        this.visitor.visitInsn(149);
    }

    public void dCmp() {
        if (this.debug) {
            System.out.println("dCmp");
        }
        this.visitor.visitInsn(151);
    }

    public void instanceOf(String descriptor) {
        if (this.debug) {
            System.out.println("instanceOf " + descriptor);
        }
        this.visitor.visitTypeInsn(193, descriptor);
    }

    public void instanceOf(Type type) {
        if (this.debug) {
            System.out.println("instanceOf " + type.getDescriptor());
        }
        this.visitor.visitTypeInsn(193, type.getDescriptor());
    }

    public void invokeStatic(JavaMethod method) {
        this.visitor.visitMethodInsn(184, method.cls.internalName, method.name, method.descriptor, false);
    }

    public void invokeSpecial(String ownerInternalName, String name, String descriptor) {
        if (this.debug) {
            System.out.println("invokeSpecial " + ownerInternalName + '.' + name + descriptor);
        }
        this.visitor.visitMethodInsn(183, ownerInternalName, name, descriptor, false);
    }

    public void invokeSpecial(Class owner, String name, String descriptor) {
        this.invokeSpecial(Type.getInternalName((Class)owner), name, descriptor);
    }

    public void invokeSpecial(JavaMethod method) {
        this.invokeSpecial(method.cls.internalName, method.name, method.descriptor);
    }

    public void invokeVirtual(JavaMethod method) {
        if (this.debug) {
            System.out.println("invokeVirtual " + method.cls.internalName + '.' + method.name + method.descriptor);
        }
        this.visitor.visitMethodInsn(182, method.cls.internalName, method.name, method.descriptor, false);
    }

    public void invokeInterface(JavaMethod method) {
        if (this.debug) {
            System.out.println("invokeInterface " + method.cls.internalName + '.' + method.name + method.descriptor);
        }
        this.visitor.visitMethodInsn(185, method.cls.internalName, method.name, method.descriptor, true);
    }

    public void newObject(String internalName) {
        if (this.debug) {
            System.out.println("newObject " + internalName);
        }
        this.visitor.visitTypeInsn(187, internalName);
    }

    public void newObject(JavaClass cls) {
        if (this.debug) {
            System.out.println("newObject " + cls.internalName);
        }
        this.visitor.visitTypeInsn(187, cls.internalName);
    }

    public void goTo(Label lbl) {
        if (this.debug) {
            System.out.println("goTo " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(167, lbl);
    }

    public void ifEQ(Label lbl) {
        if (this.debug) {
            System.out.println("ifEQ " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(153, lbl);
    }

    public void ifNE(Label lbl) {
        if (this.debug) {
            System.out.println("ifNE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(154, lbl);
    }

    public void ifLT(Label lbl) {
        if (this.debug) {
            System.out.println("ifLT " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(155, lbl);
    }

    public void ifGT(Label lbl) {
        if (this.debug) {
            System.out.println("ifGT " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(157, lbl);
    }

    public void ifGE(Label lbl) {
        if (this.debug) {
            System.out.println("ifGE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(156, lbl);
    }

    public void ifLE(Label lbl) {
        if (this.debug) {
            System.out.println("ifLE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(158, lbl);
    }

    public void ifICmpLE(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpLE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(164, lbl);
    }

    public void ifICmpGE(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpGE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(162, lbl);
    }

    public void ifICmpEQ(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpEQ " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(159, lbl);
    }

    public void ifICmpNE(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpNE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(160, lbl);
    }

    public void ifICmpGT(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpGT " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(163, lbl);
    }

    public void ifICmpLT(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpLT " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(161, lbl);
    }

    public void ifACmpEq(Label lbl) {
        if (this.debug) {
            System.out.println("ifICmpEQ " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(165, lbl);
    }

    public void ifACmpNe(Label lbl) {
        if (this.debug) {
            System.out.println("ifACmpNE " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(166, lbl);
    }

    public void ifNull(Label lbl) {
        if (this.debug) {
            System.out.println("ifNull " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(198, lbl);
    }

    public void ifNonNull(Label lbl) {
        if (this.debug) {
            System.out.println("ifNonNull " + this.getLabelName(lbl));
        }
        this.visitor.visitJumpInsn(199, lbl);
    }

    public void ret() {
        if (this.debug) {
            System.out.println("ret");
        }
        this.visitor.visitInsn(177);
    }

    public void returnType(Type type) {
        if (this.debug) {
            System.out.println("return " + type.getDescriptor());
        }
        this.visitor.visitInsn(type.getOpcode(172));
    }

    public void returnInt() {
        if (this.debug) {
            System.out.println("ireturn");
        }
        this.visitor.visitInsn(172);
    }

    public void returnObject() {
        if (this.debug) {
            System.out.println("areturn");
        }
        this.visitor.visitInsn(176);
    }

    public void getField(String owner, String name, String descriptor) {
        if (this.debug) {
            System.out.println("getField " + owner + '.' + name + ":" + descriptor);
        }
        this.visitor.visitFieldInsn(180, owner, name, descriptor);
    }

    public void getField(JavaField field) {
        if (this.debug) {
            System.out.println("getField " + field.cls.internalName + '.' + field.name + ":" + field.descriptor);
        }
        this.visitor.visitFieldInsn(180, field.cls.internalName, field.name, field.descriptor);
    }

    public void putField(String owner, String name, String descriptor) {
        if (this.debug) {
            System.out.println("putField " + owner + '.' + name + ":" + descriptor);
        }
        this.visitor.visitFieldInsn(181, owner, name, descriptor);
    }

    public void putField(JavaField field) {
        if (this.debug) {
            System.out.println("putField " + field.cls.internalName + '.' + field.name + ":" + field.descriptor);
        }
        this.visitor.visitFieldInsn(181, field.cls.internalName, field.name, field.descriptor);
    }

    public void getStaticField(String owner, String name, String descriptor) {
        if (this.debug) {
            System.out.println("getStatic " + owner + '.' + name + ":" + descriptor);
        }
        this.visitor.visitFieldInsn(178, owner, name, descriptor);
    }

    public void getStaticField(JavaField field) {
        if (this.debug) {
            System.out.println("getStaticField " + field.cls.internalName + '.' + field.name + ":" + field.descriptor);
        }
        this.visitor.visitFieldInsn(178, field.cls.internalName, field.name, field.descriptor);
    }

    public void putStaticField(String owner, String name, String descriptor) {
        if (this.debug) {
            System.out.println("putStatic " + owner + '.' + name + ":" + descriptor);
        }
        this.visitor.visitFieldInsn(179, owner, name, descriptor);
    }

    public void putStaticField(JavaField field) {
        if (this.debug) {
            System.out.println("putStaticField " + field.cls.internalName + '.' + field.name + ":" + field.descriptor);
        }
        this.visitor.visitFieldInsn(179, field.cls.internalName, field.name, field.descriptor);
    }

    public void aThrow() {
        this.visitor.visitInsn(191);
    }

    public void position(CodePosition position) {
        Label label = new Label();
        this.visitor.visitLabel(label);
        this.visitor.visitLineNumber(position.fromLine, label);
    }

    public void swap() {
        if (this.debug) {
            System.out.println("swap");
        }
        this.visitor.visitInsn(95);
    }

    private String getLabelName(Label lbl) {
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if (!this.labelNames.containsKey(lbl)) {
            this.labelNames.put(lbl, "L" + this.labelIndex++);
        }
        return this.labelNames.get(lbl);
    }

    public String createLabelName() {
        return "L" + this.labelIndex++;
    }

    public void putNamedLabel(Label lbl, String name) {
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        this.labelNames.put(lbl, name);
    }

    public void stringAdd() {
        this.invokeVirtual(STRING_CONCAT);
    }

    public Label getNamedLabel(String label) {
        for (Map.Entry<Label, String> entry : this.labelNames.entrySet()) {
            if (!entry.getValue().matches(label)) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Label " + label + " not found!");
    }

    public void tryCatch(Label start, Label end, Label handler, String type) {
        if (this.debug) {
            System.out.println("TryCatch " + this.getLabelName(start) + ", " + this.getLabelName(end) + ", " + this.getLabelName(handler) + ", TYPE: " + type);
        }
        this.visitor.visitTryCatchBlock(start, end, handler, type);
    }

    public void nameVariable(int local, String name, Label start, Label end, Type type) {
        if (this.nameVariables && name != null && type != null && end != null && end != start) {
            this.visitor.visitLocalVariable(name, type.getDescriptor(), null, start, end, local);
        }
    }

    public void nameParameter(int modifier, String name) {
        if (this.nameVariables) {
            this.visitor.visitParameter(name, modifier);
        }
    }

    public void lookupSwitch(Label defaultLabel, JavaSwitchLabel[] switchLabels) {
        int i;
        int[] keys = new int[switchLabels.length];
        Label[] labels = new Label[switchLabels.length];
        for (i = 0; i < switchLabels.length; ++i) {
            keys[i] = switchLabels[i].key;
            labels[i] = switchLabels[i].label;
        }
        if (this.debug) {
            System.out.println("lookupSwitch");
            for (i = 0; i < switchLabels.length; ++i) {
                System.out.println("  " + keys[i] + " -> " + this.getLabelName(labels[i]));
            }
            System.out.println("  default -> " + this.getLabelName(defaultLabel));
        }
        this.visitor.visitLookupSwitchInsn(defaultLabel, keys, labels);
    }

    public void addVariableInfo(JavaLocalVariableInfo info) {
        this.localVariableInfos.add(info);
    }
}

