/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.FileSourceFile;
import org.openzen.zencode.shared.LiteralSourceFile;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ModuleSpace;
import org.openzen.zenscript.codemodel.PackageDefinitions;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.WhitespacePostComment;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.FileResolutionContext;
import org.openzen.zenscript.codemodel.context.ModuleTypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.scope.FileScope;
import org.openzen.zenscript.codemodel.scope.GlobalScriptScope;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.ParsedAnnotation;
import org.openzen.zenscript.parser.ParsedDefinition;
import org.openzen.zenscript.parser.ParsedImport;
import org.openzen.zenscript.parser.PrecompilationState;
import org.openzen.zenscript.parser.statements.ParsedStatement;

public class ParsedFile {
    public final SourceFile file;
    private final List<ParsedImport> imports = new ArrayList<ParsedImport>();
    private final List<ParsedDefinition> definitions = new ArrayList<ParsedDefinition>();
    private final List<ParsedStatement> statements = new ArrayList<ParsedStatement>();
    private WhitespacePostComment postComment = null;
    private final List<ParseException> errors = new ArrayList<ParseException>();

    public static SemanticModule compileSyntaxToSemantic(SemanticModule[] dependencies, CompilingPackage pkg, ParsedFile[] files, ModuleSpace registry, FunctionParameter[] parameters, Consumer<CompileException> exceptionLogger) {
        PackageDefinitions definitions = new PackageDefinitions();
        for (ParsedFile file : files) {
            file.listDefinitions(definitions);
        }
        ZSPackage rootPackage = registry.collectPackages();
        List<ExpansionDefinition> expansions = registry.collectExpansions();
        definitions.registerExpansionsTo(expansions);
        Map<String, ISymbol> globals = registry.collectGlobals();
        boolean failed = false;
        ModuleTypeResolutionContext moduleContext = new ModuleTypeResolutionContext(registry.registry, registry.getAnnotations(), registry.getStorageTypes(), rootPackage, pkg, globals);
        for (ParsedFile file : files) {
            file.registerTypes(moduleContext, rootPackage, pkg);
        }
        for (ParsedFile file : files) {
            file.compileTypes(moduleContext, rootPackage, pkg);
        }
        if (failed) {
            return new SemanticModule(pkg.module, dependencies, parameters, SemanticModule.State.INVALID, rootPackage, pkg.getPackage(), definitions, Collections.emptyList(), registry.registry, expansions, registry.getAnnotations(), registry.getStorageTypes());
        }
        PrecompilationState precompiler = new PrecompilationState();
        for (ParsedFile file : files) {
            file.registerMembers(moduleContext, precompiler, rootPackage, pkg, expansions, globals);
        }
        ArrayList<ScriptBlock> scripts = new ArrayList<ScriptBlock>();
        FunctionHeader scriptHeader = new FunctionHeader(BasicTypeID.VOID, parameters);
        for (ParsedFile file : files) {
            file.compileCode(moduleContext, precompiler, rootPackage, pkg, expansions, scripts, globals, scriptHeader, exceptionLogger);
        }
        return new SemanticModule(pkg.module, dependencies, parameters, SemanticModule.State.ASSEMBLED, rootPackage, pkg.getPackage(), definitions, scripts, registry.registry, expansions, registry.getAnnotations(), registry.getStorageTypes());
    }

    public static ParsedFile parse(CompilingPackage compilingPackage, BracketExpressionParser bracketParser, File file) throws ParseException {
        return ParsedFile.parse(compilingPackage, bracketParser, new FileSourceFile(file.getName(), file));
    }

    public static ParsedFile parse(CompilingPackage compilingPackage, BracketExpressionParser bracketParser, String filename, String content) throws ParseException {
        return ParsedFile.parse(compilingPackage, bracketParser, new LiteralSourceFile(filename, content));
    }

    public static ParsedFile parse(CompilingPackage compilingPackage, BracketExpressionParser bracketParser, SourceFile file) throws ParseException {
        try {
            ZSTokenParser tokens = ZSTokenParser.create(file, bracketParser, 4);
            return ParsedFile.parse(compilingPackage, tokens);
        }
        catch (IOException ex) {
            throw new ParseException(new CodePosition(file, 0, 0, 0, 0), ex.getMessage());
        }
    }

    public static ParsedFile parse(CompilingPackage compilingPackage, ZSTokenParser tokens) throws ParseException {
        ParsedFile result = new ParsedFile(tokens.getFile());
        while (true) {
            CodePosition position = tokens.getPosition();
            ParsedAnnotation[] annotations = ParsedAnnotation.parseAnnotations(tokens);
            int modifiers = 0;
            block12: while (true) {
                switch (((ZSToken)tokens.peek()).type) {
                    case K_PUBLIC: {
                        modifiers |= 1;
                        break;
                    }
                    case K_PRIVATE: {
                        modifiers |= 4;
                        break;
                    }
                    case K_INTERNAL: {
                        modifiers |= 2;
                        break;
                    }
                    case K_EXTERN: {
                        modifiers |= 0x800;
                        break;
                    }
                    case K_ABSTRACT: {
                        modifiers |= 8;
                        break;
                    }
                    case K_FINAL: {
                        modifiers |= 0x10;
                        break;
                    }
                    case K_PROTECTED: {
                        modifiers |= 0x100;
                        break;
                    }
                    case K_IMPLICIT: {
                        modifiers |= 0x200;
                        break;
                    }
                    case K_VIRTUAL: {
                        modifiers |= 0x400;
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                tokens.next();
            }
            if (tokens.optional(ZSTokenType.K_IMPORT) != null) {
                result.imports.add(ParsedImport.parse(position, tokens));
                continue;
            }
            if (tokens.optional(ZSTokenType.EOF) != null) break;
            ParsedDefinition definition = ParsedDefinition.parse(compilingPackage, position, modifiers, annotations, tokens, null);
            if (definition == null) {
                result.statements.add(ParsedStatement.parse(tokens, annotations));
                continue;
            }
            result.definitions.add(definition);
        }
        result.postComment = WhitespacePostComment.fromWhitespace(tokens.getLastWhitespace());
        result.errors.addAll(tokens.getErrors());
        return result;
    }

    public ParsedFile(SourceFile file) {
        this.file = file;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ParseException> getErrors() {
        return this.errors;
    }

    public void listDefinitions(PackageDefinitions definitions) {
        for (ParsedDefinition definition : this.definitions) {
            definitions.add(definition.getCompiled());
        }
    }

    public void registerTypes(ModuleTypeResolutionContext moduleContext, ZSPackage rootPackage, CompilingPackage modulePackage) {
        FileResolutionContext context = new FileResolutionContext(moduleContext, rootPackage, modulePackage);
        this.loadImports(context, rootPackage, modulePackage);
        for (ParsedDefinition definition : this.definitions) {
            if (definition.getName() == null) continue;
            definition.pkg.addType(definition.getName(), definition.getCompiling(context));
        }
    }

    public void compileTypes(ModuleTypeResolutionContext moduleContext, ZSPackage rootPackage, CompilingPackage modulePackage) {
        FileResolutionContext context = new FileResolutionContext(moduleContext, rootPackage, modulePackage);
        this.loadImports(context, rootPackage, modulePackage);
        for (ParsedDefinition definition : this.definitions) {
            if (definition.getName() == null) continue;
            modulePackage.addType(definition.getName(), definition.getCompiling(context));
        }
        for (ParsedDefinition definition : this.definitions) {
            definition.getCompiling(context).load();
        }
    }

    public void registerMembers(ModuleTypeResolutionContext moduleContext, PrecompilationState precompiler, ZSPackage rootPackage, CompilingPackage modulePackage, List<ExpansionDefinition> expansions, Map<String, ISymbol> globals) {
        FileResolutionContext context = new FileResolutionContext(moduleContext, rootPackage, modulePackage);
        this.loadImports(context, rootPackage, modulePackage);
        FileScope scope = new FileScope(context, expansions, globals, precompiler);
        for (ParsedDefinition definition : this.definitions) {
            definition.registerMembers(scope, precompiler);
        }
    }

    public void compileCode(ModuleTypeResolutionContext moduleContext, PrecompilationState precompiler, ZSPackage rootPackage, CompilingPackage modulePackage, List<ExpansionDefinition> expansions, List<ScriptBlock> scripts, Map<String, ISymbol> globals, FunctionHeader scriptHeader, Consumer<CompileException> exceptionLogger) {
        FileResolutionContext context = new FileResolutionContext(moduleContext, rootPackage, modulePackage);
        this.loadImports(context, rootPackage, modulePackage);
        FileScope scope = new FileScope(context, expansions, globals, precompiler);
        for (ParsedDefinition definition : this.definitions) {
            try {
                definition.compile(scope);
            }
            catch (CompileException ex) {
                exceptionLogger.accept(ex);
            }
        }
        if (!this.statements.isEmpty() || this.postComment != null) {
            GlobalScriptScope statementScope = new GlobalScriptScope(scope, scriptHeader);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            for (ParsedStatement statement : this.statements) {
                statements.add(statement.compile(statementScope));
            }
            ScriptBlock block = new ScriptBlock(this.file, modulePackage.module, modulePackage.getPackage(), scriptHeader, statements);
            block.setTag(WhitespacePostComment.class, this.postComment);
            scripts.add(block);
        }
    }

    private void loadImports(FileResolutionContext context, ZSPackage rootPackage, CompilingPackage modulePackage) {
        for (ParsedImport importEntry : this.imports) {
            HighLevelDefinition definition = importEntry.isRelative() ? modulePackage.getImport(context, importEntry.getPath()) : rootPackage.getImport(importEntry.getPath(), 0);
            if (definition == null) continue;
            context.addImport(importEntry.getName(), definition);
        }
    }
}

