/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler.definitions;

import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Modifiers;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.member.CallerMember;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.DestructorMember;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.InnerDefinitionMember;
import org.openzen.zenscript.codemodel.member.IteratorMember;
import org.openzen.zenscript.codemodel.member.MemberVisitor;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.member.StaticInitializerMember;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.CompilerUtils;
import org.openzen.zenscript.javabytecode.compiler.JavaStatementVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaMemberVisitor
implements MemberVisitor<Void> {
    private final ClassWriter writer;
    private final JavaBytecodeContext context;
    private final JavaClass toClass;
    private final HighLevelDefinition definition;
    private final JavaStatementVisitor clinitStatementVisitor;
    private EnumDefinition enumDefinition = null;
    private final JavaCompiledModule javaModule;

    public JavaMemberVisitor(JavaBytecodeContext context, ClassWriter writer, JavaClass toClass, HighLevelDefinition definition) {
        this.writer = writer;
        this.toClass = toClass;
        this.definition = definition;
        this.context = context;
        this.javaModule = context.getJavaModule(definition.module);
        JavaWriter javaWriter = new JavaWriter(definition.position, (ClassVisitor)writer, new JavaMethod(toClass, JavaMethod.Kind.STATICINIT, "<clinit>", true, "()V", 0, false), definition, null, null, new String[0]);
        this.clinitStatementVisitor = new JavaStatementVisitor(context, this.javaModule, javaWriter);
        this.clinitStatementVisitor.start();
        CompilerUtils.writeDefaultFieldInitializers(context, javaWriter, definition, true);
    }

    @Override
    public Void visitConst(ConstMember member) {
        JavaField field = this.context.getJavaField(member);
        this.writer.visitField(CompilerUtils.calcAccess(member.getEffectiveModifiers()), field.name, field.descriptor, field.signature, null).visitEnd();
        return null;
    }

    @Override
    public Void visitField(FieldMember member) {
        JavaField field = this.context.getJavaField(member);
        this.writer.visitField(CompilerUtils.calcAccess(member.getEffectiveModifiers()), field.name, field.descriptor, field.signature, null).visitEnd();
        return null;
    }

    @Override
    public Void visitConstructor(ConstructorMember member) {
        boolean isEnum = this.definition instanceof EnumDefinition;
        JavaMethod method = this.context.getJavaMethod(member);
        Label constructorStart = new Label();
        Label constructorEnd = new Label();
        JavaWriter constructorWriter = new JavaWriter(member.position, (ClassVisitor)this.writer, method, this.definition, this.context.getMethodSignature(member.header), null, new String[0]);
        constructorWriter.label(constructorStart);
        CompilerUtils.tagConstructorParameters(this.context, this.javaModule, member.definition, member.header, isEnum);
        for (FunctionParameter parameter : member.header.parameters) {
            constructorWriter.nameVariable(this.javaModule.getParameterInfo((FunctionParameter)parameter).index, parameter.name, constructorStart, constructorEnd, this.context.getType(parameter.type));
        }
        JavaStatementVisitor statementVisitor = new JavaStatementVisitor(this.context, this.javaModule, constructorWriter);
        statementVisitor.start();
        if (!member.isConstructorForwarded()) {
            if (isEnum) {
                System.out.println("Writing enum constructor");
                constructorWriter.getVisitor().newLocal(Type.getType(String.class));
                constructorWriter.getVisitor().newLocal(Type.getType(Integer.TYPE));
                constructorWriter.loadObject(0);
                constructorWriter.loadObject(1);
                constructorWriter.loadInt(2);
                constructorWriter.invokeSpecial(Type.getInternalName(Enum.class), "<init>", "(Ljava/lang/String;I)V");
            } else if (this.definition.getSuperType() == null) {
                System.out.println("Writing regular constructor");
                constructorWriter.loadObject(0);
                constructorWriter.invokeSpecial(Type.getInternalName(Object.class), "<init>", "()V");
            }
        }
        if (member.body != null) {
            member.body.accept(statementVisitor);
        }
        constructorWriter.label(constructorEnd);
        statementVisitor.end();
        return null;
    }

    @Override
    public Void visitDestructor(DestructorMember member) {
        int modifiers = 1;
        if (member.body == null) {
            modifiers |= 0x400;
        }
        JavaMethod method = JavaMethod.getVirtual(this.toClass, "close", "()V", modifiers);
        if (member.body == null) {
            return null;
        }
        Label constructorStart = new Label();
        Label constructorEnd = new Label();
        JavaWriter destructorWriter = new JavaWriter(member.position, (ClassVisitor)this.writer, method, this.definition, null, null, new String[0]);
        destructorWriter.label(constructorStart);
        JavaStatementVisitor statementVisitor = new JavaStatementVisitor(this.context, this.javaModule, destructorWriter);
        statementVisitor.start();
        member.body.accept(statementVisitor);
        destructorWriter.label(constructorEnd);
        statementVisitor.end();
        return null;
    }

    @Override
    public Void visitMethod(MethodMember member) {
        CompilerUtils.tagMethodParameters(this.context, this.javaModule, member.header, member.isStatic());
        boolean isAbstract = member.body == null || Modifiers.isAbstract(member.getEffectiveModifiers());
        JavaMethod method = this.context.getJavaMethod(member);
        Label methodStart = new Label();
        Label methodEnd = new Label();
        JavaWriter methodWriter = new JavaWriter(member.position, (ClassVisitor)this.writer, method, this.definition, this.context.getMethodSignature(member.header), null, new String[0]);
        JavaStatementVisitor statementVisitor = new JavaStatementVisitor(this.context, this.javaModule, methodWriter);
        if (!isAbstract) {
            statementVisitor.start();
            member.body.accept(statementVisitor);
            methodWriter.label(methodEnd);
            statementVisitor.end();
        }
        return null;
    }

    @Override
    public Void visitGetter(GetterMember member) {
        return null;
    }

    @Override
    public Void visitSetter(SetterMember member) {
        return null;
    }

    @Override
    public Void visitOperator(OperatorMember member) {
        return null;
    }

    @Override
    public Void visitCaster(CasterMember member) {
        return null;
    }

    @Override
    public Void visitCustomIterator(IteratorMember member) {
        return null;
    }

    @Override
    public Void visitCaller(CallerMember member) {
        return null;
    }

    @Override
    public Void visitImplementation(ImplementationMember member) {
        return null;
    }

    @Override
    public Void visitInnerDefinition(InnerDefinitionMember member) {
        return null;
    }

    @Override
    public Void visitStaticInitializer(StaticInitializerMember member) {
        member.body.accept(this.clinitStatementVisitor);
        return null;
    }

    public void end() {
        if (this.enumDefinition != null) {
            for (EnumConstantMember constant : this.enumDefinition.enumConstants) {
                this.writer.visitField(16409, constant.name, "L" + this.definition.name + ";", null, null).visitEnd();
                String internalName = this.context.getInternalName(constant.constructor.type);
                JavaWriter clinitWriter = this.clinitStatementVisitor.getJavaWriter();
                clinitWriter.newObject(internalName);
                clinitWriter.dup();
                clinitWriter.constant(constant.name);
                clinitWriter.constant(constant.ordinal);
                for (Expression argument : constant.constructor.arguments.arguments) {
                    argument.accept(this.clinitStatementVisitor.expressionVisitor);
                }
                clinitWriter.invokeSpecial(internalName, "<init>", this.context.getEnumConstructorDescriptor(constant.constructor.constructor.getHeader()));
                clinitWriter.putStaticField(internalName, constant.name, "L" + internalName + ";");
                this.enumDefinition = (EnumDefinition)constant.definition;
            }
            JavaWriter clinitWriter = this.clinitStatementVisitor.getJavaWriter();
            List<EnumConstantMember> enumConstants = this.enumDefinition.enumConstants;
            clinitWriter.constant(enumConstants.size());
            clinitWriter.newArray(Type.getType((String)("L" + this.definition.name + ";")));
            for (EnumConstantMember enumConstant : enumConstants) {
                clinitWriter.dup();
                clinitWriter.constant(enumConstant.ordinal);
                clinitWriter.getStaticField(this.definition.name, enumConstant.name, "L" + this.definition.name + ";");
                clinitWriter.arrayStore(Type.getType((String)("L" + this.definition.name + ";")));
            }
            clinitWriter.putStaticField(this.definition.name, "$VALUES", "[L" + this.definition.name + ";");
        }
        this.clinitStatementVisitor.end();
    }
}

