/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.CallStaticExpression;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class SimpleBracketSubParser
implements BracketExpressionParser {
    private final FunctionalMemberRef method;
    private final TypeID targetType;

    public SimpleBracketSubParser(GlobalTypeRegistry registry, FunctionalMemberRef method) {
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Method must be static");
        }
        if (method.getHeader().getNumberOfTypeParameters() > 0) {
            throw new IllegalArgumentException("Method cannot have type parameters");
        }
        this.method = method;
        this.targetType = registry.getForDefinition(method.getTarget().definition, new StoredType[0]);
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        StringBuilder string = new StringBuilder();
        while (tokens.optional(ZSTokenType.T_GREATER) == null) {
            string.append(((ZSToken)tokens.next()).content);
            string.append(tokens.getLastWhitespace());
        }
        return new StaticMethodCallExpression(position, string.toString());
    }

    private class StaticMethodCallExpression
    extends ParsedExpression {
        private final String value;

        public StaticMethodCallExpression(CodePosition position, String value) {
            super(position);
            this.value = value;
        }

        @Override
        public IPartialExpression compile(ExpressionScope scope) {
            return new CallStaticExpression(this.position, SimpleBracketSubParser.this.targetType, SimpleBracketSubParser.this.method, SimpleBracketSubParser.this.method.getHeader(), new CallArguments(new ConstantStringExpression(this.position, this.value)));
        }

        @Override
        public boolean hasStrongType() {
            return true;
        }
    }
}

