/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.member.TypeMemberBuilder;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;

public class LocalMemberCache {
    private final GlobalTypeRegistry registry;
    private final Map<StoredType, TypeMembers> types = new HashMap<StoredType, TypeMembers>();
    private final List<ExpansionDefinition> expansions = new ArrayList<ExpansionDefinition>();

    public LocalMemberCache(GlobalTypeRegistry registry, List<ExpansionDefinition> expansions) {
        this.registry = registry;
        this.expansions.addAll(expansions);
    }

    public GlobalTypeRegistry getRegistry() {
        return this.registry;
    }

    public TypeMembers get(StoredType type) {
        if (this.types.containsKey(type = type.getNormalized())) {
            return this.types.get(type);
        }
        TypeMembers members = new TypeMembers(this, type);
        this.registerMembers(members);
        this.types.put(type, members);
        return members;
    }

    private void registerMembers(TypeMembers members) {
        members.type.type.accept(null, new TypeMemberBuilder(this.registry, members, this));
    }

    public List<ExpansionDefinition> getExpansions() {
        return this.expansions;
    }
}

