/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.storage;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.type.storage.InvalidStorageTag;
import org.openzen.zenscript.codemodel.type.storage.MutableStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageType;

public class MutableStorageType
implements StorageType {
    public static final MutableStorageType INSTANCE = new MutableStorageType();

    private MutableStorageType() {
    }

    @Override
    public String getName() {
        return "mutable";
    }

    @Override
    public StorageTag instance(CodePosition position, String[] arguments) {
        if (arguments.length > 0) {
            if (arguments.length == 1 && arguments[0].equals("this")) {
                return MutableStorageTag.THIS;
            }
            return new InvalidStorageTag(position, CompileExceptionCode.INVALID_STORAGE_TYPE_ARGUMENTS, "mutable storage type doesn't take arguments");
        }
        return MutableStorageTag.INVOCATION;
    }
}

