/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.statement.VarStatement;
import org.openzen.zenscript.codemodel.statement.VariableID;
import org.openzen.zenscript.javabytecode.JavaLocalVariableInfo;
import org.openzen.zenscript.javabytecode.compiler.JavaStatementVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaMethod;

public class JavaForeachWriter {
    private final JavaWriter javaWriter;
    private final VarStatement[] variables;
    private final Statement content;
    private final Label startLabel;
    private final Label endLabel;
    private final JavaStatementVisitor statementVisitor;

    public JavaForeachWriter(JavaStatementVisitor statementVisitor, VarStatement[] variables, Statement content, Label start, Label end) {
        this.statementVisitor = statementVisitor;
        this.javaWriter = statementVisitor.getJavaWriter();
        this.variables = variables;
        this.content = content;
        this.startLabel = start;
        this.endLabel = end;
    }

    public void visitIntRange() {
        this.javaWriter.dup();
        this.javaWriter.getField("zsynthetic/IntRange", "to", "I");
        this.javaWriter.swap();
        this.javaWriter.getField("zsynthetic/IntRange", "from", "I");
        int z = this.javaWriter.getLocalVariable((VariableID)this.variables[0].variable).local;
        this.javaWriter.storeInt(z);
        this.javaWriter.label(this.startLabel);
        this.javaWriter.dup();
        this.javaWriter.loadInt(z);
        this.javaWriter.ifICmpLE(this.endLabel);
        this.content.accept(this.statementVisitor);
        this.javaWriter.iinc(z);
    }

    public void visitArrayValueIterator() {
        this.handleArray(this.javaWriter.local(Integer.TYPE), this.javaWriter.getLocalVariable(this.variables[0].variable));
    }

    public void visitArrayKeyValueIterator() {
        this.handleArray(this.javaWriter.getLocalVariable((VariableID)this.variables[0].variable).local, this.javaWriter.getLocalVariable(this.variables[1].variable));
    }

    public void visitStringCharacterIterator() {
        this.javaWriter.invokeSpecial("java/lang/String", "toCharArray()", "()[C");
        this.handleArray(this.javaWriter.local(Integer.TYPE), this.javaWriter.getLocalVariable(this.variables[0].variable));
    }

    private void handleArray(int z, JavaLocalVariableInfo arrayTypeInfo) {
        this.javaWriter.iConst0();
        this.javaWriter.storeInt(z);
        this.javaWriter.label(this.startLabel);
        this.javaWriter.dup();
        this.javaWriter.dup();
        this.javaWriter.arrayLength();
        this.javaWriter.loadInt(z);
        this.javaWriter.ifICmpLE(this.endLabel);
        this.javaWriter.loadInt(z);
        this.javaWriter.arrayLoad(arrayTypeInfo.type);
        this.javaWriter.store(arrayTypeInfo.type, arrayTypeInfo.local);
        this.content.accept(this.statementVisitor);
        this.javaWriter.iinc(z);
    }

    public void visitCustomIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visitAssocKeyIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void visitAssocKeyValueIterator() {
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.MAP, "entrySet", "()Ljava/util/Set;", 0));
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.COLLECTION, "iterator", "()Ljava/util/Iterator;", 0));
        this.javaWriter.label(this.startLabel);
        this.javaWriter.dup();
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.ITERATOR, "hasNext", "()Z", 0));
        this.javaWriter.ifEQ(this.endLabel);
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.ITERATOR, "next", "()Ljava/lang/Object;", 0));
        this.javaWriter.checkCast(Type.getType(Map.Entry.class));
        this.javaWriter.dup(false);
        JavaLocalVariableInfo keyVariable = this.javaWriter.getLocalVariable(this.variables[0].variable);
        JavaLocalVariableInfo valueVariable = this.javaWriter.getLocalVariable(this.variables[1].variable);
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.fromInternalName("java/util/Map$Entry", JavaClass.Kind.INTERFACE), "getKey", "()Ljava/lang/Object;", 0));
        this.javaWriter.store(keyVariable.type, keyVariable.local);
        this.javaWriter.invokeInterface(JavaMethod.getVirtual(JavaClass.fromInternalName("java/util/Map$Entry", JavaClass.Kind.INTERFACE), "getValue", "()Ljava/lang/Object;", 0));
        this.javaWriter.store(valueVariable.type, valueVariable.local);
        this.content.accept(this.statementVisitor);
    }
}

