/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.type;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.parser.type.IParsedType;
import org.openzen.zenscript.parser.type.ParsedStorageTag;

public class ParsedTypeAssociative
implements IParsedType {
    private final CodePosition position;
    public final IParsedType key;
    public final IParsedType value;
    private final ParsedStorageTag storage;

    public ParsedTypeAssociative(CodePosition position, IParsedType key, IParsedType value, ParsedStorageTag storage) {
        this.position = position;
        this.key = key;
        this.value = value;
        this.storage = storage;
    }

    @Override
    public StoredType compile(TypeResolutionContext context) {
        StorageTag storage = this.storage.resolve(this.position, context);
        StoredType key = this.key.compile(context);
        StoredType value = this.value.compile(context);
        return context.getTypeRegistry().getAssociative(key, value).stored(storage);
    }

    @Override
    public TypeID compileUnstored(TypeResolutionContext context) {
        if (this.storage != ParsedStorageTag.NULL) {
            return new InvalidTypeID(this.position, CompileExceptionCode.STORAGE_NOT_SUPPORTED, "Storage tag not supported here");
        }
        StorageTag storage = this.storage.resolve(this.position, context);
        StoredType key = this.key.compile(context);
        StoredType value = this.value.compile(context);
        return context.getTypeRegistry().getAssociative(key, value);
    }
}

