/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Modifiers;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.JavaExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaSwitchKeyVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaParameterInfo;
import org.openzen.zenscript.javashared.JavaTypeParameterInfo;

public class CompilerUtils {
    private CompilerUtils() {
    }

    public static boolean isPrimitive(TypeID id) {
        return id instanceof BasicTypeID || id.isOptional() && id.withoutOptional() == BasicTypeID.USIZE;
    }

    public static boolean isLarge(StoredType type) {
        return type.type == BasicTypeID.DOUBLE || type.type == BasicTypeID.DOUBLE;
    }

    public static int calcAccess(int modifiers) {
        int out = 0;
        if (Modifiers.isStatic(modifiers)) {
            out |= 8;
        }
        if (Modifiers.isFinal(modifiers)) {
            out |= 0x10;
        }
        if (Modifiers.isPublic(modifiers)) {
            out |= 1;
        }
        if (Modifiers.isPrivate(modifiers)) {
            out |= 2;
        }
        if (Modifiers.isProtected(modifiers)) {
            out |= 4;
        }
        if (Modifiers.isAbstract(modifiers)) {
            out |= 0x400;
        }
        return out;
    }

    public static void tagMethodParameters(JavaBytecodeContext context, JavaCompiledModule module, FunctionHeader header, boolean isStatic) {
        Taggable parameter;
        int i;
        int index = header.getNumberOfTypeParameters();
        for (i = 0; i < header.typeParameters.length; ++i) {
            parameter = header.typeParameters[i];
            module.setTypeParameterInfo((TypeParameter)parameter, new JavaTypeParameterInfo(index++));
        }
        for (i = 0; i < header.parameters.length; ++i) {
            parameter = header.parameters[i];
            String parameterType = context.getDescriptor(((FunctionParameter)parameter).type);
            module.setParameterInfo((FunctionParameter)parameter, new JavaParameterInfo(isStatic ? index : index + 1, parameterType));
            ++index;
        }
    }

    public static void tagConstructorParameters(JavaBytecodeContext context, JavaCompiledModule module, HighLevelDefinition definition, FunctionHeader header, boolean isEnum) {
        Taggable parameter;
        int i;
        int index = header.getNumberOfTypeParameters();
        for (i = 0; i < definition.typeParameters.length; ++i) {
            JavaTypeParameterInfo info = module.getTypeParameterInfo(definition.typeParameters[i]);
            if (info.field == null) continue;
            ++index;
        }
        for (i = 0; i < header.typeParameters.length; ++i) {
            parameter = header.typeParameters[i];
            module.setTypeParameterInfo((TypeParameter)parameter, new JavaTypeParameterInfo(index++));
        }
        for (i = 0; i < header.parameters.length; ++i) {
            parameter = header.parameters[i];
            String parameterType = context.getDescriptor(((FunctionParameter)parameter).type);
            module.setParameterInfo((FunctionParameter)parameter, new JavaParameterInfo(isEnum ? i + 3 : i + 1, parameterType));
        }
    }

    public static void writeDefaultFieldInitializers(JavaBytecodeContext context, JavaWriter constructorWriter, HighLevelDefinition definition, boolean staticFields) {
        JavaExpressionVisitor expressionVisitor = new JavaExpressionVisitor(context, context.getJavaModule(definition.module), constructorWriter);
        for (IDefinitionMember definitionMember : definition.members) {
            FieldMember field;
            if (!(definitionMember instanceof FieldMember) || (field = (FieldMember)definitionMember).isStatic() != staticFields || field.initializer == null) continue;
            if (!staticFields) {
                constructorWriter.loadObject(0);
            }
            field.initializer.accept(expressionVisitor);
            if (staticFields) {
                constructorWriter.putStaticField(definition.name, field.name, context.getDescriptor(field.getType()));
                continue;
            }
            constructorWriter.putField(definition.name, field.name, context.getDescriptor(field.getType()));
        }
    }

    public static int getKeyForSwitch(SwitchValue expression) {
        return expression.accept(JavaSwitchKeyVisitor.INSTANCE);
    }
}

