/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.ModuleSpace;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.PackageDefinitions;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.definition.ClassDefinition;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.InterfaceDefinition;
import org.openzen.zenscript.codemodel.definition.StructDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.expression.ConstantByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantDoubleExpression;
import org.openzen.zenscript.codemodel.expression.ConstantFloatExpression;
import org.openzen.zenscript.codemodel.expression.ConstantIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantLongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantSByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantULongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUShortExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionSymbol;
import org.openzen.zenscript.codemodel.expression.StaticGetterExpression;
import org.openzen.zenscript.codemodel.expression.StorageCastExpression;
import org.openzen.zenscript.codemodel.generic.ParameterTypeBound;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.FunctionalMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StaticStorageTag;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaFunctionalInterfaceStorageTag;
import org.openzen.zenscript.javashared.JavaImplementation;
import org.openzen.zenscript.javashared.JavaMethod;
import stdlib.Strings;

public class JavaNativeModule {
    public final Module module;
    private final ZSPackage pkg;
    private final String basePackage;
    private final GlobalTypeRegistry registry;
    private final PackageDefinitions definitions = new PackageDefinitions();
    private final JavaCompiledModule compiled;
    private final Map<Class<?>, HighLevelDefinition> definitionByClass = new HashMap();
    private final Map<Class<?>, TypeID> typeByClass = new HashMap();
    private final Map<Class<?>, TypeID> unsignedByClass = new HashMap();
    public final Map<String, ISymbol> globals = new HashMap<String, ISymbol>();

    public JavaNativeModule(ZSPackage pkg, String name, String basePackage, GlobalTypeRegistry registry, JavaNativeModule[] dependencies) {
        this.pkg = pkg;
        this.basePackage = basePackage;
        this.module = new Module(name);
        this.registry = registry;
        for (JavaNativeModule dependency : dependencies) {
            this.definitionByClass.putAll(dependency.definitionByClass);
        }
        this.compiled = new JavaCompiledModule(this.module, FunctionParameter.NONE);
        this.typeByClass.put(Void.TYPE, BasicTypeID.VOID);
        this.typeByClass.put(Boolean.TYPE, BasicTypeID.BOOL);
        this.typeByClass.put(Byte.TYPE, BasicTypeID.SBYTE);
        this.typeByClass.put(Short.TYPE, BasicTypeID.SHORT);
        this.typeByClass.put(Integer.TYPE, BasicTypeID.INT);
        this.typeByClass.put(Long.TYPE, BasicTypeID.LONG);
        this.typeByClass.put(Float.TYPE, BasicTypeID.FLOAT);
        this.typeByClass.put(Double.TYPE, BasicTypeID.DOUBLE);
        this.typeByClass.put(String.class, StringTypeID.INSTANCE);
        this.typeByClass.put(Boolean.class, registry.getOptional(BasicTypeID.BOOL));
        this.typeByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.typeByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.typeByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.typeByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
        this.typeByClass.put(Float.class, registry.getOptional(BasicTypeID.FLOAT));
        this.typeByClass.put(Double.class, registry.getOptional(BasicTypeID.DOUBLE));
        this.unsignedByClass.put(Byte.TYPE, BasicTypeID.BYTE);
        this.unsignedByClass.put(Short.TYPE, BasicTypeID.USHORT);
        this.unsignedByClass.put(Integer.TYPE, BasicTypeID.UINT);
        this.unsignedByClass.put(Long.TYPE, BasicTypeID.ULONG);
        this.unsignedByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.unsignedByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.unsignedByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.unsignedByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
    }

    public SemanticModule toSemantic(ModuleSpace space) {
        return new SemanticModule(this.module, SemanticModule.NONE, FunctionParameter.NONE, SemanticModule.State.NORMALIZED, space.rootPackage, this.pkg, this.definitions, Collections.emptyList(), space.registry, space.collectExpansions(), space.getAnnotations(), space.getStorageTypes());
    }

    public JavaCompiledModule getCompiled() {
        return this.compiled;
    }

    public HighLevelDefinition addClass(Class<?> cls) {
        if (this.definitionByClass.containsKey(cls)) {
            return this.definitionByClass.get(cls);
        }
        HighLevelDefinition result = this.convertClass(cls);
        return result;
    }

    public void addGlobals(Class<?> cls) {
        ZenCodeGlobals.Global global;
        ClassDefinition definition = new ClassDefinition(CodePosition.NATIVE, this.module, this.pkg, "__globals__", 1);
        JavaClass jcls = JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.CLASS);
        this.compiled.setClassInfo(definition, jcls);
        StoredType thisType = this.registry.getForMyDefinition(definition).stored();
        TypeVariableContext context = new TypeVariableContext();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(field.getModifiers())) continue;
            global = field.getAnnotation(ZenCodeGlobals.Global.class);
            StoredType type = this.loadStoredType(context, field.getAnnotatedType());
            String name = global.value().isEmpty() ? field.getName() : global.value();
            FieldMember fieldMember = new FieldMember(CodePosition.NATIVE, (HighLevelDefinition)definition, 129, name, thisType, type, this.registry, 1, 0, null);
            definition.addMember(fieldMember);
            JavaField javaField = new JavaField(jcls, field.getName(), JavaNativeModule.getDescriptor(field.getType()));
            this.compiled.setFieldInfo(fieldMember, javaField);
            this.compiled.setFieldInfo(fieldMember.autoGetter, javaField);
            this.globals.put(name, new ExpressionSymbol((position, scope) -> new StaticGetterExpression(CodePosition.BUILTIN, fieldMember.autoGetter.ref(thisType, GenericMapper.EMPTY))));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(((Method)accessibleObject).getModifiers())) continue;
            global = ((Method)accessibleObject).getAnnotation(ZenCodeGlobals.Global.class);
            String name = global.value().isEmpty() ? ((Method)accessibleObject).getName() : global.value();
            MethodMember methodMember = new MethodMember(CodePosition.NATIVE, definition, 129, name, this.getHeader(context, (Method)accessibleObject), null);
            definition.addMember(methodMember);
            boolean isGenericResult = methodMember.header.getReturnType().isGeneric();
            this.compiled.setMethodInfo(methodMember, new JavaMethod(jcls, JavaMethod.Kind.STATIC, ((Method)accessibleObject).getName(), false, JavaNativeModule.getMethodDescriptor((Method)accessibleObject), ((Method)accessibleObject).getModifiers(), isGenericResult));
            this.globals.put(name, new ExpressionSymbol((position, scope) -> {
                TypeMembers members = scope.getTypeMembers(thisType);
                return new PartialStaticMemberGroupExpression((CodePosition)position, (TypeScope)scope, thisType.type, members.getGroup(name), StoredType.NONE);
            }));
        }
    }

    public FunctionalMemberRef loadStaticMethod(Method method) {
        if (!JavaNativeModule.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method is not static");
        }
        HighLevelDefinition definition = this.addClass(method.getDeclaringClass());
        JavaClass jcls = JavaClass.fromInternalName(JavaNativeModule.getInternalName(method.getDeclaringClass()), JavaClass.Kind.CLASS);
        TypeVariableContext context = new TypeVariableContext();
        MethodMember methodMember = new MethodMember(CodePosition.NATIVE, definition, 129, method.getName(), this.getHeader(context, method), null);
        definition.addMember(methodMember);
        boolean isGenericResult = methodMember.header.getReturnType().isGeneric();
        this.compiled.setMethodInfo(methodMember, new JavaMethod(jcls, JavaMethod.Kind.STATIC, method.getName(), false, JavaNativeModule.getMethodDescriptor(method), method.getModifiers(), isGenericResult));
        return methodMember.ref(this.registry.getForDefinition(definition, new StoredType[0]).stored());
    }

    private boolean isInBasePackage(String className) {
        return className.startsWith(this.basePackage + ".");
    }

    private ZSPackage getPackage(String className) {
        if (!className.contains(".") || className.startsWith("java.lang")) {
            return this.pkg;
        }
        if (className.startsWith(".")) {
            className = className.substring(1);
        } else if (className.startsWith(this.basePackage + ".")) {
            className = className.substring(this.basePackage.length() + 1);
        } else {
            throw new IllegalArgumentException("Invalid class name: not in the given base package");
        }
        String[] classNameParts = Strings.split(className, '.');
        ZSPackage classPkg = this.pkg;
        for (int i = 0; i < classNameParts.length - 1; ++i) {
            classPkg = classPkg.getOrCreatePackage(classNameParts[i]);
        }
        return classPkg;
    }

    private <T> HighLevelDefinition convertClass(Class<T> cls) {
        FunctionalMember member;
        JavaClass javaClass;
        HighLevelDefinition definition;
        TypeID type;
        if ((cls.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("Class must be public");
        }
        String className = cls.getName();
        boolean isStruct = cls.getAnnotation(ZenCodeType.Struct.class) != null;
        ZSPackage classPkg = this.getPackage(className);
        ZenCodeType.Name name = cls.getDeclaredAnnotation(ZenCodeType.Name.class);
        String string = className = className.contains(".") ? className.substring(className.lastIndexOf(46) + 1) : className;
        if (name != null) {
            String specifiedName = name.value();
            if (specifiedName.startsWith(".")) {
                classPkg = this.getPackage(specifiedName);
                className = className.substring(className.lastIndexOf(46) + 1);
            } else if (specifiedName.indexOf(46) >= 0) {
                if (!specifiedName.startsWith(this.pkg.fullName)) {
                    throw new IllegalArgumentException("Specified @Name as " + specifiedName + " but it's not in the module root package");
                }
                classPkg = this.getPackage(this.basePackage + specifiedName.substring(this.pkg.fullName.length()));
                className = className.substring(className.lastIndexOf(46) + 1);
            } else {
                className = name.value();
            }
        }
        TypeVariableContext context = new TypeVariableContext();
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        for (int i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Class<T>> typeVariable = javaTypeParameters[i];
            TypeParameter parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            for (AnnotatedType bound : typeVariable.getAnnotatedBounds()) {
                type = this.loadType((TypeVariableContext)context, (AnnotatedType)bound).type;
                parameter.addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
            typeParameters[i] = parameter;
            context.put(typeVariable, parameter);
        }
        String internalName = JavaNativeModule.getInternalName(cls);
        if (cls.isInterface()) {
            definition = new InterfaceDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.INTERFACE);
        } else if (cls.isEnum()) {
            definition = new EnumDefinition(CodePosition.NATIVE, this.module, this.pkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.ENUM);
        } else if (isStruct) {
            definition = new StructDefinition(CodePosition.NATIVE, this.module, this.pkg, className, 1, null);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
        } else {
            definition = new ClassDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1);
            javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
            if (cls.getAnnotatedSuperclass() != null && this.shouldLoadType(cls.getAnnotatedSuperclass().getType())) {
                definition.setSuperType(this.loadType((TypeVariableContext)context, (AnnotatedType)cls.getAnnotatedSuperclass()).type);
            }
        }
        for (AnnotatedType iface : cls.getAnnotatedInterfaces()) {
            if (!this.shouldLoadType(iface.getType())) continue;
            type = this.loadType((TypeVariableContext)context, (AnnotatedType)iface).type;
            ImplementationMember implementationMember = new ImplementationMember(CodePosition.NATIVE, definition, 1, type);
            definition.members.add(implementationMember);
            this.compiled.setImplementationInfo(implementationMember, new JavaImplementation(true, javaClass));
        }
        definition.typeParameters = typeParameters;
        this.compiled.setClassInfo(definition, javaClass);
        this.definitionByClass.put(cls, definition);
        StoredType thisType = new StoredType(this.registry.getForMyDefinition(definition), AutoStorageTag.INSTANCE);
        for (Field field : cls.getDeclaredFields()) {
            ZenCodeType.Field field2 = field.getAnnotation(ZenCodeType.Field.class);
            if (field2 == null || !JavaNativeModule.isPublic(field.getModifiers())) continue;
            String fieldName = field2.value().isEmpty() ? field.getName() : field2.value();
            StoredType fieldType = this.loadStoredType(context, field.getAnnotatedType());
            FieldMember member2 = new FieldMember(CodePosition.NATIVE, definition, 1, fieldName, thisType, fieldType, this.registry, 0, 0, null);
            definition.addMember(member2);
            this.compiled.setFieldInfo(member2, new JavaField(javaClass, field.getName(), JavaNativeModule.getDescriptor(field.getType())));
        }
        boolean hasConstructor = false;
        for (Constructor<?> constructor : cls.getConstructors()) {
            ZenCodeType.Constructor constructorAnnotation = constructor.getAnnotation(ZenCodeType.Constructor.class);
            if (constructorAnnotation == null) continue;
            member = this.asConstructor(context, definition, constructor);
            definition.addMember(member);
            this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, constructor));
            hasConstructor = true;
        }
        if (!hasConstructor) {
            ConstructorMember member4 = new ConstructorMember(CodePosition.BUILTIN, definition, 4, new FunctionHeader(BasicTypeID.VOID), BuiltinID.CLASS_DEFAULT_CONSTRUCTOR);
            definition.addMember(member4);
        }
        for (Executable executable : cls.getDeclaredMethods()) {
            ZenCodeType.Caster caster;
            ZenCodeType.Operator operator;
            ZenCodeType.Setter setter;
            ZenCodeType.Method methodAnnotation = ((Method)executable).getAnnotation(ZenCodeType.Method.class);
            if (methodAnnotation != null) {
                member = this.asMethod(context, definition, (Method)executable, methodAnnotation);
                definition.addMember(member);
                this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, (Method)executable, ((MethodMember)member).header.getReturnType()));
                continue;
            }
            ZenCodeType.Getter getter = ((Method)executable).getAnnotation(ZenCodeType.Getter.class);
            if (getter != null) {
                GetterMember member2 = this.asGetter(context, definition, (Method)executable, getter);
                definition.addMember(member2);
                this.compiled.setMethodInfo(member2, JavaNativeModule.getMethod(javaClass, (Method)executable, member2.getType()));
            }
            if ((setter = ((Method)executable).getAnnotation(ZenCodeType.Setter.class)) != null) {
                SetterMember member5 = this.asSetter(context, definition, (Method)executable, setter);
                definition.addMember(member5);
                this.compiled.setMethodInfo(member5, JavaNativeModule.getMethod(javaClass, (Method)executable, BasicTypeID.VOID.stored));
            }
            if ((operator = ((Method)executable).getAnnotation(ZenCodeType.Operator.class)) != null) {
                OperatorMember member6 = this.asOperator(context, definition, (Method)executable, operator);
                definition.addMember(member6);
                this.compiled.setMethodInfo(member6, JavaNativeModule.getMethod(javaClass, (Method)executable, member6.header.getReturnType()));
            }
            if ((caster = ((Method)executable).getAnnotation(ZenCodeType.Caster.class)) == null) continue;
            CasterMember member7 = this.asCaster(context, definition, (Method)executable, caster);
            definition.addMember(member7);
            this.compiled.setMethodInfo(member7, JavaNativeModule.getMethod(javaClass, (Method)executable, member7.toType));
        }
        return definition;
    }

    private boolean shouldLoadType(Type type) {
        if (type instanceof Class) {
            return this.shouldLoadClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.shouldLoadType(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    private boolean shouldLoadClass(Class<?> cls) {
        return this.isInBasePackage(cls.getName());
    }

    private boolean isGetterName(String name) {
        return name.startsWith("get") || name.startsWith("is") || name.startsWith("has");
    }

    private String translateGetterName(String name) {
        if (name.startsWith("get")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private String translateSetterName(String name) {
        if (name.startsWith("set")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private ConstructorMember asConstructor(TypeVariableContext context, HighLevelDefinition definition, Constructor method) {
        FunctionHeader header = this.getHeader(context, method);
        return new ConstructorMember(CodePosition.NATIVE, definition, 1, header, null);
    }

    private MethodMember asMethod(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Method annotation) {
        String name = annotation != null && !annotation.value().isEmpty() ? annotation.value() : method.getName();
        FunctionHeader header = this.getHeader(context, method);
        return new MethodMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, header, null);
    }

    private OperatorMember asOperator(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Operator annotation) {
        FunctionHeader header = this.getHeader(context, method);
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("operator method cannot be static");
        }
        return new OperatorMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), OperatorType.valueOf(annotation.value().toString()), header, null);
    }

    private GetterMember asGetter(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Getter annotation) {
        StoredType type = this.loadStoredType(context, method.getAnnotatedReturnType());
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateGetterName(method.getName());
        }
        return new GetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private SetterMember asSetter(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Setter annotation) {
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Illegal setter: must have exactly 1 parameter");
        }
        StoredType type = this.loadStoredType(context, method.getAnnotatedParameterTypes()[0]);
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateSetterName(method.getName());
        }
        return new SetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private CasterMember asCaster(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Caster annotation) {
        boolean implicit = annotation != null && annotation.implicit();
        int modifiers = 1;
        if (implicit) {
            modifiers |= 0x200;
        }
        StoredType toType = this.loadStoredType(context, method.getAnnotatedReturnType());
        return new CasterMember(CodePosition.NATIVE, definition, modifiers, toType, null);
    }

    private FunctionHeader getHeader(TypeVariableContext context, Constructor constructor) {
        return this.getHeader(context, null, constructor.getParameters(), constructor.getTypeParameters(), constructor.getAnnotatedExceptionTypes());
    }

    private FunctionHeader getHeader(TypeVariableContext context, Method method) {
        return this.getHeader(context, method.getAnnotatedReturnType(), method.getParameters(), method.getTypeParameters(), method.getAnnotatedExceptionTypes());
    }

    private Expression getDefaultValue(Parameter parameter, StoredType type) {
        if (parameter.isAnnotationPresent(ZenCodeType.Optional.class)) {
            Expression defaultValue = type.type.getDefaultValue();
            if (defaultValue == null) {
                throw new IllegalArgumentException(type.toString() + " doesn't have a default value");
            }
            return defaultValue;
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalInt.class)) {
            ZenCodeType.OptionalInt annotation = parameter.getAnnotation(ZenCodeType.OptionalInt.class);
            if (type.type == BasicTypeID.BYTE) {
                return new ConstantByteExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.SBYTE) {
                return new ConstantSByteExpression(CodePosition.NATIVE, (byte)annotation.value());
            }
            if (type.type == BasicTypeID.SHORT) {
                return new ConstantShortExpression(CodePosition.NATIVE, (short)annotation.value());
            }
            if (type.type == BasicTypeID.USHORT) {
                return new ConstantUShortExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.INT) {
                return new ConstantIntExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.UINT) {
                return new ConstantUIntExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use int default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalLong.class)) {
            ZenCodeType.OptionalLong annotation = parameter.getAnnotation(ZenCodeType.OptionalLong.class);
            if (type.type == BasicTypeID.LONG) {
                return new ConstantLongExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.ULONG) {
                return new ConstantULongExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use long default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalFloat.class)) {
            ZenCodeType.OptionalFloat annotation = parameter.getAnnotation(ZenCodeType.OptionalFloat.class);
            if (type.type == BasicTypeID.FLOAT) {
                return new ConstantFloatExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use float default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalDouble.class)) {
            ZenCodeType.OptionalDouble annotation = parameter.getAnnotation(ZenCodeType.OptionalDouble.class);
            if (type.type == BasicTypeID.DOUBLE) {
                return new ConstantDoubleExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use double default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalString.class)) {
            ZenCodeType.OptionalString annotation = parameter.getAnnotation(ZenCodeType.OptionalString.class);
            if (type.type == StringTypeID.INSTANCE) {
                Expression result = new ConstantStringExpression(CodePosition.NATIVE, annotation.value());
                if (type.getActualStorage() != StaticStorageTag.INSTANCE) {
                    result = new StorageCastExpression(CodePosition.NATIVE, result, type);
                }
                return result;
            }
            throw new IllegalArgumentException("Cannot use string default values for " + type.toString());
        }
        return null;
    }

    private FunctionHeader getHeader(TypeVariableContext context, AnnotatedType javaReturnType, Parameter[] javaParameters, TypeVariable<Method>[] javaTypeParameters, AnnotatedType[] exceptionTypes) {
        StoredType returnType = javaReturnType == null ? BasicTypeID.VOID.stored : this.loadStoredType(context, javaReturnType);
        FunctionParameter[] parameters = new FunctionParameter[javaParameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = javaParameters[i];
            AnnotatedType parameterType = parameter.getAnnotatedType();
            StoredType type = this.loadStoredType(context, parameter.getAnnotatedType());
            Expression defaultValue = this.getDefaultValue(parameter, type);
            parameters[i] = new FunctionParameter(type, parameter.getName(), defaultValue, parameter.isVarArgs());
        }
        TypeParameter[] typeParameters = new TypeParameter[javaTypeParameters.length];
        for (int i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Method> javaTypeParameter = javaTypeParameters[i];
            typeParameters[i] = new TypeParameter(CodePosition.UNKNOWN, javaTypeParameter.getName());
            context.put(javaTypeParameter, typeParameters[i]);
            for (AnnotatedType bound : javaTypeParameter.getAnnotatedBounds()) {
                typeParameters[i].addBound(new ParameterTypeBound(CodePosition.NATIVE, this.loadType((TypeVariableContext)context, (AnnotatedType)bound).type));
            }
        }
        if (exceptionTypes.length > 1) {
            throw new IllegalArgumentException("A method can only throw a single exception type!");
        }
        StoredType thrownType = exceptionTypes.length == 0 ? null : this.loadStoredType(context, exceptionTypes[0]);
        return new FunctionHeader(typeParameters, returnType, thrownType, AutoStorageTag.INSTANCE, parameters);
    }

    private StoredType loadStoredType(TypeVariableContext context, AnnotatedType annotatedType) {
        return this.loadType(context, annotatedType);
    }

    private StoredType loadType(TypeVariableContext context, AnnotatedType annotatedType) {
        if (annotatedType.isAnnotationPresent(ZenCodeType.USize.class)) {
            return BasicTypeID.USIZE.stored;
        }
        if (annotatedType.isAnnotationPresent(ZenCodeType.NullableUSize.class)) {
            return this.registry.getOptional(BasicTypeID.USIZE).stored();
        }
        boolean nullable = annotatedType.isAnnotationPresent(ZenCodeType.Nullable.class);
        boolean unsigned = annotatedType.isAnnotationPresent(ZenCodeType.Unsigned.class);
        Type type = annotatedType.getType();
        return this.loadType(context, type, nullable, unsigned);
    }

    private StoredType loadType(TypeVariableContext context, Type type, boolean nullable, boolean unsigned) {
        StoredType result = this.loadType(context, type, unsigned);
        if (nullable) {
            result = new StoredType(this.registry.getOptional(result.type), result.getSpecifiedStorage());
        }
        return result;
    }

    private StoredType loadType(TypeVariableContext context, Type type, boolean unsigned) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (unsigned) {
                if (this.unsignedByClass.containsKey(classType)) {
                    return this.unsignedByClass.get(classType).stored();
                }
                throw new IllegalArgumentException("This class cannot be used as unsigned: " + classType);
            }
            if (classType.isArray()) {
                return this.registry.getArray(this.loadType(context, classType.getComponentType(), false, false), 1).stored();
            }
            if (classType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, classType, new Type[0]);
            }
            if (this.typeByClass.containsKey(classType)) {
                return this.typeByClass.get(classType).stored();
            }
            HighLevelDefinition definition = this.addClass(classType);
            return this.registry.getForDefinition(definition, new StoredType[0]).stored();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (rawType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, rawType, parameterizedType.getActualTypeArguments());
            }
            HighLevelDefinition definition = this.addClass(rawType);
            Type[] parameters = parameterizedType.getActualTypeArguments();
            StoredType[] codeParameters = new StoredType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                codeParameters[i] = this.loadType(context, parameters[i], false, false);
            }
            return this.registry.getForDefinition(definition, codeParameters).stored();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return this.registry.getGeneric(context.get(variable)).stored();
        }
        throw new IllegalArgumentException("Could not analyze type: " + type);
    }

    private StoredType loadFunctionalInterface(TypeVariableContext loadContext, Class<?> cls, Type[] parameters) {
        Method functionalInterfaceMethod = this.getFunctionalInterfaceMethod(cls);
        TypeVariableContext context = this.convertTypeParameters(cls);
        FunctionHeader header = this.getHeader(context, functionalInterfaceMethod);
        HashMap<TypeParameter, StoredType> mapping = new HashMap<TypeParameter, StoredType>();
        TypeVariable<Class<?>>[] javaParameters = cls.getTypeParameters();
        for (int i = 0; i < javaParameters.length; ++i) {
            mapping.put(context.get(javaParameters[i]), this.loadType(loadContext, parameters[i], false, false));
        }
        JavaMethod method = new JavaMethod(JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.INTERFACE), JavaMethod.Kind.INTERFACE, functionalInterfaceMethod.getName(), false, JavaNativeModule.getMethodDescriptor(functionalInterfaceMethod), 1025, header.getReturnType().type.isGeneric());
        JavaFunctionalInterfaceStorageTag tag = new JavaFunctionalInterfaceStorageTag(functionalInterfaceMethod, method);
        return this.registry.getFunction(header).stored(tag);
    }

    private <T> TypeVariableContext convertTypeParameters(Class<T> cls) {
        TypeVariableContext context = new TypeVariableContext();
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        for (int i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Class<T>> typeVariable = javaTypeParameters[i];
            TypeParameter parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            for (AnnotatedType bound : typeVariable.getAnnotatedBounds()) {
                TypeID type = this.loadType((TypeVariableContext)context, (AnnotatedType)bound).type;
                parameter.addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
            typeParameters[i] = parameter;
            context.put(typeVariable, parameter);
        }
        return context;
    }

    private Method getFunctionalInterfaceMethod(Class<?> functionalInterface) {
        for (Method method : functionalInterface.getDeclaredMethods()) {
            if (method.isDefault()) continue;
            return method;
        }
        return null;
    }

    private int getMethodModifiers(Method method) {
        int result = 1;
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            result |= 0x80;
        }
        if (JavaNativeModule.isFinal(method.getModifiers())) {
            result |= 0x10;
        }
        return result;
    }

    private static boolean isPublic(int modifiers) {
        return (modifiers & 1) > 0;
    }

    private static boolean isStatic(int modifiers) {
        return (modifiers & 8) > 0;
    }

    private static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    private static String getInternalName(Class<?> cls) {
        return org.objectweb.asm.Type.getInternalName(cls);
    }

    private static String getDescriptor(Class<?> cls) {
        return org.objectweb.asm.Type.getDescriptor(cls);
    }

    private static String getMethodDescriptor(Constructor constructor) {
        return org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor);
    }

    private static String getMethodDescriptor(Method method) {
        return org.objectweb.asm.Type.getMethodDescriptor((Method)method);
    }

    private static JavaMethod getMethod(JavaClass cls, Constructor constructor) {
        return new JavaMethod(cls, JavaMethod.Kind.CONSTRUCTOR, "<init>", false, JavaNativeModule.getMethodDescriptor(constructor), constructor.getModifiers(), false);
    }

    private static JavaMethod getMethod(JavaClass cls, Method method, StoredType result) {
        JavaMethod.Kind kind = method.getName().equals("<init>") ? JavaMethod.Kind.CONSTRUCTOR : (method.getName().equals("<clinit>") ? JavaMethod.Kind.STATICINIT : (JavaNativeModule.isStatic(method.getModifiers()) ? JavaMethod.Kind.STATIC : JavaMethod.Kind.INSTANCE));
        return new JavaMethod(cls, kind, method.getName(), false, JavaNativeModule.getMethodDescriptor(method), method.getModifiers(), result.isGeneric());
    }

    private static class TypeVariableContext {
        private final Map<TypeVariable, TypeParameter> typeVariables = new HashMap<TypeVariable, TypeParameter>();

        private TypeVariableContext() {
        }

        public void put(TypeVariable variable, TypeParameter parameter) {
            this.typeVariables.put(variable, parameter);
        }

        public TypeParameter get(TypeVariable variable) {
            if (!this.typeVariables.containsKey(variable)) {
                throw new IllegalStateException("Could not find type variable " + variable.getName());
            }
            return this.typeVariables.get(variable);
        }
    }
}

