/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.generic;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.generic.TypeParameterBound;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class TypeParameter
extends Taggable {
    public static final TypeParameter[] NONE = new TypeParameter[0];
    public final CodePosition position;
    public final String name;
    public StorageTag storage = null;
    public final List<TypeParameterBound> bounds = new ArrayList<TypeParameterBound>();

    public TypeParameter(CodePosition position, String name) {
        this.position = position;
        this.name = name;
    }

    public void addBound(TypeParameterBound bound) {
        this.bounds.add(bound);
    }

    public boolean isObjectType() {
        for (TypeParameterBound bound : this.bounds) {
            if (!bound.isObjectType()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(LocalMemberCache cache, TypeID type) {
        for (TypeParameterBound bound : this.bounds) {
            if (bound.matches(cache, type)) continue;
            return false;
        }
        return true;
    }

    public String getCanonical() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (TypeParameterBound bound : this.bounds) {
            result.append(':');
            result.append(bound.getCanonical());
        }
        return result.toString();
    }

    public String toString() {
        return this.name + "@" + this.position.toShortString();
    }
}

