/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseDAO<T> {
    private final Connection connection;
    private final String table;
    private final Reader<T> reader;
    private final PreparedStatement getById;
    private final PreparedStatement deleteById;

    public BaseDAO(Connection connection, String table, Reader<T> reader) throws SQLException {
        this.connection = connection;
        this.table = table;
        this.reader = reader;
        this.getById = connection.prepareStatement("SELECT * FROM " + table + " WHERE id=?");
        this.deleteById = connection.prepareStatement("DELETE FROM " + table + " WHERE id=?");
    }

    public T getById(long id) {
        try {
            this.getById.setLong(1, id);
            ResultSet rs = this.getById.executeQuery();
            return this.reader.read(rs);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract long insert(T var1) throws SQLException;

    public abstract void update(T var1) throws SQLException;

    public boolean delete(long id) {
        try {
            this.deleteById.setLong(1, id);
            ResultSet rs = this.deleteById.executeQuery();
            this.reader.read(rs);
            return rs.rowDeleted();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected long getInsertId(PreparedStatement statement) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        return 0L;
    }

    public static interface Reader<T> {
        public T read(ResultSet var1) throws SQLException;
    }
}

