/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.ConnectionPool;
import org.openzen.zengarden.basedao.DatabaseVersion;
import org.openzen.zengarden.function.Function;

public class SQLiteConnectionPool<DB extends BaseDatabase>
extends ConnectionPool<DB> {
    private static final Logger LOGGER = Logger.getLogger(ConnectionPool.class.getName());

    public SQLiteConnectionPool(File file, DatabaseVersion[] schema, Function<Connection, DB> factory) {
        super(SQLiteConnectionPool.createDataSource(file), schema, factory);
    }

    private static ComboPooledDataSource createDataSource(File file) {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass("org.sqlite.JDBC");
            dataSource.setJdbcUrl("jdbc:sqlite:" + file.getAbsolutePath());
        }
        catch (PropertyVetoException ex) {
            LOGGER.log(Level.SEVERE, "Could not create data source", ex);
        }
        return dataSource;
    }
}

