/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.model.Setting;

public class SettingsDAO
extends BaseDAO<Setting> {
    private final PreparedStatement insert;
    private final PreparedStatement update;

    public SettingsDAO(BaseDatabase database, Connection connection) throws SQLException {
        super(connection, "settings", rs -> new Setting(rs));
        this.insert = connection.prepareStatement("INSERT INTO settings (key, value) VALUES (?, ?)");
        this.update = connection.prepareStatement("UPDATE settings SET value=? WHERE id=?");
    }

    @Override
    public long insert(Setting value) throws SQLException {
        this.insert.setString(1, value.key);
        this.insert.setString(2, value.value);
        this.insert.executeUpdate();
        return this.getInsertId(this.insert);
    }

    @Override
    public void update(Setting value) throws SQLException {
        this.update.setString(1, value.value);
        this.update.setLong(2, value.id);
        this.update.executeUpdate();
    }
}

