/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.io.File;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.openzen.zengarden.basedao.BaseConnectionPool;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.DatabaseFactory;
import org.openzen.zengarden.basedao.DatabaseVersion;
import org.sqlite.SQLiteDataSource;

public class SQLiteConnectionPool<DB extends BaseDatabase>
extends BaseConnectionPool<DB> {
    private static final Logger LOGGER = Logger.getLogger(BaseConnectionPool.class.getName());

    public SQLiteConnectionPool(File file, DatabaseVersion[] schema, DatabaseFactory<DB> factory) {
        super(SQLiteConnectionPool.createDataSource(file), schema, factory);
    }

    private static DataSource createDataSource(File file) {
        SQLiteDataSource dataSource = new SQLiteDataSource();
        dataSource.setUrl("jdbc:sqlite:" + file.getAbsolutePath());
        return dataSource;
    }
}

