/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseVersion {
    public final String[] updateCommands;

    public DatabaseVersion(String ... updateCommands) {
        this.updateCommands = updateCommands;
    }

    public final void apply(Connection connection) throws SQLException {
        boolean wasInAutoCommit = connection.getAutoCommit();
        if (!wasInAutoCommit) {
            connection.setAutoCommit(false);
        }
        for (String command : this.updateCommands) {
            try (Statement statement = connection.createStatement();){
                System.out.println(command);
                statement.executeUpdate(command);
            }
        }
        this.applyCustomUpdates(connection);
        connection.commit();
        if (!wasInAutoCommit) {
            connection.setAutoCommit(true);
        }
    }

    protected void applyCustomUpdates(Connection connection) throws SQLException {
    }
}

