/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;

public abstract class BaseDAOWithUUID<T>
extends BaseDAO<T> {
    private final BaseDAO.QueryStatement getById;
    private final BaseDAO.UpdateStatement deleteById;

    public BaseDAOWithUUID(Connection connection, String table, BaseDAO.Reader<T> reader, Class<T> type) throws SQLException {
        super(connection, table, reader, type);
        this.getById = new BaseDAO.QueryStatement("SELECT * FROM " + table + " WHERE uuid=?");
        this.deleteById = new BaseDAO.UpdateStatement("DELETE FROM " + table + " WHERE uuid=?");
    }

    public T getByUUID(String uuid) {
        try {
            this.getById.setString(1, uuid);
            return this.getById.queryFirst();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean delete(String uuid) {
        try {
            this.deleteById.setString(1, uuid);
            return this.deleteById.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

