/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;

public abstract class BaseDAOWithID<U, T>
extends BaseDAO<U, T> {
    private final BaseDAO.QueryStatement getById;
    private final BaseDAO.UpdateStatement deleteById;

    public BaseDAOWithID(Connection connection, String table, BaseDAO.Reader<T> reader, Class<T> type) throws SQLException {
        super(connection, table, reader, type);
        this.getById = new BaseDAO.QueryStatement("SELECT * FROM " + table + " WHERE id=?");
        this.deleteById = new BaseDAO.UpdateStatement("DELETE FROM " + table + " WHERE id=?");
    }

    public T getById(long id) {
        try {
            this.getById.setLong(1, id);
            return this.getById.queryFirst();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean delete(U user, long id) {
        try {
            this.deleteById.setLong(1, id);
            return this.deleteById.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

