/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.model.Setting;

public class SettingsDAO
extends BaseDAO<Void, Setting> {
    private final BaseDAO.QueryStatement get = new BaseDAO.QueryStatement("SELECT * FROM settings WHERE `key`=?");
    private final BaseDAO.InsertStatement insert = new BaseDAO.InsertStatement("INSERT INTO settings (`key`, value) VALUES (?, ?)");
    private final BaseDAO.UpdateStatement update = new BaseDAO.UpdateStatement("UPDATE settings SET value=? WHERE key=?");

    public SettingsDAO(BaseDatabase database, Connection connection) throws SQLException {
        super(connection, "settings", rs -> new Setting(rs), Setting.class);
    }

    public Setting get(String key) throws SQLException {
        this.get.setString(1, key);
        return (Setting)this.get.queryFirst();
    }

    @Override
    public void insert(Void user, Setting value) throws SQLException {
        this.insert.setString(1, value.key);
        this.insert.setString(2, value.value);
        this.insert.execute();
    }

    @Override
    public void update(Void user, Setting value) throws SQLException {
        this.update.setString(1, value.value);
        this.update.setString(2, value.key);
        this.update.execute();
    }
}

