/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.openzen.zengarden.collections.ZArrayList;
import org.openzen.zengarden.collections.ZList;

public abstract class BaseDAO<U, T> {
    protected final Connection connection;
    protected final String table;
    private final QueryStatement getAll;
    private final Reader<T> reader;
    private final Class<T> type;

    public BaseDAO(Connection connection, String table, Reader<T> reader, Class<T> type) throws SQLException {
        this.connection = connection;
        this.table = table;
        this.reader = reader;
        this.type = type;
        this.getAll = new QueryStatement("SELECT * FROM " + table);
    }

    public ZList<T> getAll() throws SQLException {
        return this.getAll.queryMany();
    }

    public abstract void insert(U var1, T var2) throws SQLException;

    public abstract void update(U var1, T var2) throws SQLException;

    public void close() throws SQLException {
        this.getAll.close();
    }

    protected long getInsertId(PreparedStatement statement) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        return 0L;
    }

    protected T loadOne(ResultSet rs) throws SQLException {
        try {
            if (rs.next()) {
                T t = this.reader.read(rs);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZList<T> loadAll(ResultSet rs) throws SQLException {
        try {
            ZArrayList results = new ZArrayList(this.type);
            while (rs.next()) {
                results.add(this.reader.read(rs));
            }
            ZArrayList zArrayList = results;
            return zArrayList;
        }
        finally {
            rs.close();
        }
    }

    public class QueryStatement
    extends BaseStatement {
        public QueryStatement(String statement) {
            super(statement);
        }

        public T queryFirst() throws SQLException {
            return BaseDAO.this.loadOne(this.get().executeQuery());
        }

        public ZList<T> queryMany() throws SQLException {
            return BaseDAO.this.loadAll(this.get().executeQuery());
        }
    }

    public class UpdateStatement
    extends BaseStatement {
        public UpdateStatement(String statement) {
            super(statement);
        }

        public boolean execute() throws SQLException {
            return this.get().executeUpdate() > 0;
        }
    }

    public class InsertStatement
    extends BaseStatement {
        public InsertStatement(String statement) {
            super(statement);
        }

        @Override
        public PreparedStatement get() throws SQLException {
            if (this.instance == null) {
                this.instance = BaseDAO.this.connection.prepareStatement(this.statement, 1);
            }
            return this.instance;
        }

        public void execute() throws SQLException {
            this.get().executeUpdate();
        }

        public long executeAndGetId() throws SQLException {
            this.get().executeUpdate();
            return BaseDAO.this.getInsertId(this.get());
        }
    }

    public class BaseStatement {
        protected final String statement;
        protected PreparedStatement instance;

        public BaseStatement(String statement) {
            this.statement = statement;
        }

        public PreparedStatement get() throws SQLException {
            if (this.instance == null) {
                this.instance = BaseDAO.this.connection.prepareStatement(this.statement);
            }
            return this.instance;
        }

        public void setBool(int i, boolean value) throws SQLException {
            this.get().setBoolean(i, value);
        }

        public void setInt(int i, int value) throws SQLException {
            this.get().setInt(i, value);
        }

        public void setLong(int i, long value) throws SQLException {
            this.get().setLong(i, value);
        }

        public void setDouble(int i, double value) throws SQLException {
            this.get().setDouble(i, value);
        }

        public void setString(int i, String value) throws SQLException {
            this.get().setString(i, value);
        }

        public void setDate(int i, long timestamp) throws SQLException {
            this.get().setDate(i, new Date(timestamp));
        }

        public void setTimestamp(int i, long timestamp) throws SQLException {
            this.get().setTimestamp(i, new Timestamp(timestamp));
        }

        public void setOptionalBool(int i, Boolean value) throws SQLException {
            if (value == null) {
                this.get().setNull(i, 16);
            } else {
                this.get().setBoolean(i, value);
            }
        }

        public void setOptionalInt(int i, Integer value) throws SQLException {
            if (value == null) {
                this.get().setNull(i, 4);
            } else {
                this.get().setInt(i, value);
            }
        }

        public void setOptionalLong(int i, Long value) throws SQLException {
            if (value == null) {
                this.get().setNull(i, -5);
            } else {
                this.get().setLong(i, value);
            }
        }

        public void setOptionalDouble(int i, Double value) throws SQLException {
            if (value == null) {
                this.get().setNull(i, 8);
            } else {
                this.get().setDouble(i, value);
            }
        }

        public void setOptionalString(int i, String value) throws SQLException {
            if (value == null) {
                this.get().setNull(i, 12);
            } else {
                this.get().setString(i, value);
            }
        }

        public void setOptionalDate(int i, Long timestamp) throws SQLException {
            if (timestamp == null) {
                this.get().setNull(i, 91);
            } else {
                this.get().setDate(i, new Date(timestamp));
            }
        }

        public void setOptionalTimestamp(int i, Long timestamp) throws SQLException {
            if (timestamp == null) {
                this.get().setNull(i, 93);
            } else {
                this.get().setTimestamp(i, new Timestamp(timestamp));
            }
        }

        public void close() throws SQLException {
            if (this.instance != null) {
                this.instance.close();
                this.instance = null;
            }
        }
    }

    public static interface Reader<T> {
        public T read(ResultSet var1) throws SQLException;
    }
}

