/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.sql.DataSource;
import org.openzen.zengarden.basedao.BaseConnectionPool;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.DatabaseFactory;
import org.openzen.zengarden.basedao.DatabaseVersion;
import org.openzen.zengarden.basedao.MySQLConnectionInfo;

public class MySQLConnectionPool<DB extends BaseDatabase>
extends BaseConnectionPool<DB> {
    public MySQLConnectionPool(MySQLConnectionInfo connectionInfo, DatabaseVersion[] schema, DatabaseFactory<DB> factory) {
        super(MySQLConnectionPool.createDataSource(connectionInfo), schema, factory);
    }

    @Override
    protected String getCreateSettingsCommand() {
        return "CREATE TABLE settings (`key` VARCHAR(255), value VARCHAR(255), PRIMARY KEY(`key`))";
    }

    private static DataSource createDataSource(MySQLConnectionInfo connectionInfo) {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setJdbcUrl("jdbc:mysql://" + connectionInfo.server + ":" + connectionInfo.port + "/" + connectionInfo.database);
        dataSource.setUser(connectionInfo.username);
        dataSource.setPassword(connectionInfo.password);
        return dataSource;
    }
}

