/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.openzen.zengarden.basedao.BaseDatabase;
import org.openzen.zengarden.basedao.DatabaseFactory;
import org.openzen.zengarden.basedao.DatabaseVersion;

public abstract class BaseConnectionPool<DB extends BaseDatabase> {
    private final DataSource dataSource;
    private final DatabaseVersion[] schema;
    private final DatabaseFactory<DB> factory;
    private final WeakHashMap<Connection, DB> cachedInstances = new WeakHashMap();

    public BaseConnectionPool(DataSource dataSource, DatabaseVersion[] schema, DatabaseFactory<DB> factory) {
        this.dataSource = dataSource;
        this.schema = schema;
        this.factory = factory;
        try {
            this.upgradeDatabase();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DB connect() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        BaseDatabase database = (BaseDatabase)this.cachedInstances.get(connection);
        if (database != null) {
            System.out.println("Reusing cached database");
            return (DB)database;
        }
        database = (BaseDatabase)this.factory.build(connection);
        this.cachedInstances.put(connection, database);
        System.out.println("Creating new database (" + this.cachedInstances.size() + " cached)");
        return (DB)database;
    }

    protected abstract String getCreateSettingsCommand();

    private void upgradeDatabase() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            int version;
            if (version == this.schema.length) {
                return;
            }
            for (version = this.initializeSettings(connection); version < this.schema.length; ++version) {
                this.schema[version].apply(connection);
            }
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("UPDATE settings SET value=" + version + " WHERE `key`='version'");
            }
        }
    }

    private int initializeSettings(Connection connection) throws SQLException {
        Statement statement;
        boolean hasSettings;
        DatabaseMetaData meta = connection.getMetaData();
        try (ResultSet rs = meta.getTables(null, null, "settings", new String[]{"TABLE"});){
            hasSettings = rs.next();
        }
        int version = 0;
        if (!hasSettings) {
            statement = connection.createStatement();
            Throwable throwable = null;
            try {
                statement.executeUpdate(this.getCreateSettingsCommand());
                statement.executeUpdate("INSERT INTO settings (`key`, value) VALUES ('version', 0)");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        statement = connection.createStatement();
        Throwable throwable = null;
        try {
            ResultSet versionRC = statement.executeQuery("SELECT value FROM settings WHERE `key`='version'");
            if (versionRC.next()) {
                version = versionRC.getInt("value");
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (statement != null) {
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    statement.close();
                }
            }
        }
        return version;
    }
}

