/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao;

import java.sql.Connection;
import java.sql.SQLException;
import org.openzen.zengarden.basedao.BaseDAO;
import org.openzen.zengarden.basedao.statement.QueryStatement;
import org.openzen.zengarden.basedao.statement.UpdateStatement;

public abstract class BaseDAOWithID<U, T>
extends BaseDAO<U, T> {
    private final QueryStatement<T> getById;
    private final UpdateStatement deleteById;

    public BaseDAOWithID(Connection connection, String table, BaseDAO.Reader<T> reader, Class<T> type) throws SQLException {
        super(connection, table, reader, type);
        this.getById = this.query("SELECT * FROM " + table + " WHERE id=?");
        this.deleteById = this.update("DELETE FROM " + table + " WHERE id=?");
    }

    public T getById(long id) {
        try {
            this.getById.setLong(1, id);
            return this.getById.queryFirst();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean delete(U user, long id) {
        try {
            this.deleteById.setLong(1, id);
            return this.deleteById.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.getById.close();
        this.deleteById.close();
    }
}

