/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.basedao.statement;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class BaseStatement {
    protected final Connection connection;
    protected final String statement;
    protected PreparedStatement instance;

    public BaseStatement(Connection connection, String statement) {
        this.connection = connection;
        this.statement = statement;
    }

    public PreparedStatement get() throws SQLException {
        if (this.instance == null) {
            this.instance = this.connection.prepareStatement(this.statement);
        }
        return this.instance;
    }

    public void setBool(int i, boolean value) throws SQLException {
        this.get().setBoolean(i, value);
    }

    public void setInt(int i, int value) throws SQLException {
        this.get().setInt(i, value);
    }

    public void setLong(int i, long value) throws SQLException {
        this.get().setLong(i, value);
    }

    public void setDouble(int i, double value) throws SQLException {
        this.get().setDouble(i, value);
    }

    public void setString(int i, String value) throws SQLException {
        this.get().setString(i, value);
    }

    public void setDate(int i, long timestamp) throws SQLException {
        this.get().setDate(i, new Date(timestamp));
    }

    public void setTimestamp(int i, long timestamp) throws SQLException {
        this.get().setTimestamp(i, new Timestamp(timestamp));
    }

    public void setOptionalBool(int i, Boolean value) throws SQLException {
        if (value == null) {
            this.get().setNull(i, 16);
        } else {
            this.get().setBoolean(i, value);
        }
    }

    public void setOptionalInt(int i, Integer value) throws SQLException {
        if (value == null) {
            this.get().setNull(i, 4);
        } else {
            this.get().setInt(i, value);
        }
    }

    public void setOptionalLong(int i, Long value) throws SQLException {
        if (value == null) {
            this.get().setNull(i, -5);
        } else {
            this.get().setLong(i, value);
        }
    }

    public void setOptionalDouble(int i, Double value) throws SQLException {
        if (value == null) {
            this.get().setNull(i, 8);
        } else {
            this.get().setDouble(i, value);
        }
    }

    public void setOptionalString(int i, String value) throws SQLException {
        if (value == null) {
            this.get().setNull(i, 12);
        } else {
            this.get().setString(i, value);
        }
    }

    public void setOptionalDate(int i, Long timestamp) throws SQLException {
        if (timestamp == null) {
            this.get().setNull(i, 91);
        } else {
            this.get().setDate(i, new Date(timestamp));
        }
    }

    public void setOptionalTimestamp(int i, Long timestamp) throws SQLException {
        if (timestamp == null) {
            this.get().setNull(i, 93);
        } else {
            this.get().setTimestamp(i, new Timestamp(timestamp));
        }
    }

    public void close() throws SQLException {
        if (this.instance != null) {
            this.instance.close();
            this.instance = null;
        }
    }
}

